/* 
Copyright (C) 2004  Mika Raento - Renaud Petit

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
   
    
     email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


/* Copyright (c) 2001, Nokia. All rights reserved */

#ifndef __SOCKETSWRITER_H__
#define __SOCKETSWRITER_H__

#include <in_sock.h>
#include <TimeOut.h>
#include <app_context.h>

class MEngineNotifier;

/*! 
@class CSocketsWriter

  @discussion This class handles writing data to the socket.
  Data to be written is accumulated in iTransferBuffer, and is then transferred
  to iWriteBuffer for the actual write to the socket.
*/
class CSocketsWriter : public CActive, public MTimeOut, public MContextBase
{
public:
/*!
@function NewL

  @discussion Create a CSocketsWriter object
  @param aEngineNotifier An observer for status reporting
  @param aSocket socket to write to
  @result a pointer to the created instance of CSocketsWriter
	*/
	static CSocketsWriter* NewL(MEngineNotifier& aEngineNotifier, RSocket& aSocket, MApp_context& Context);
	
	/*!
	@function NewLC
	
	  @discussion Create a CSocketsWriter object
	  @param aEngineNotifier An observer for status reporting
	  @param aSocket socket to write to
	  @result a pointer to the created instance of CSocketsWriter
	*/
	static CSocketsWriter* NewLC(MEngineNotifier& aEngineNotifier, RSocket& aSocket, MApp_context& Context);
	
	/*!
	@function ~CSocketsWriter
	
	  @discussion Destroy the object and release all memory objects
	*/
	~CSocketsWriter();
	
	/*!
	@function IssueWrite
	
	  @discussion Write the data to the socket (buffered)
	  @param aData the data to be written
	*/
	void IssueWriteL(const TDesC16& aData);
	
public: // From MTimeOut
	/*!
	@function expired
	
	  @discussion Handle a timeout event
	*/
	void expired(CBase*); 
	
protected: // from CActive
	   /*!
	   @function DoCancel
	   
	     @discussion cancel any outstanding operation
	*/
	void DoCancel();
	
	/*!
	@function RunL
	
	  @discussion called when operation complete
	*/
	void RunL();	
	TInt CheckedRunError(TInt aError);
private:
/*!
@function CSocketsWriter

  @discussion Perform the first phase of two phase construction 
  @param aEngineNotifier An observer for status reporting
  @param aSocket socket to read from
	*/
	CSocketsWriter(MEngineNotifier& aEngineNotifier, RSocket& aSocket, MApp_context& Context);
	
	/*!
	@function ConstructL
	
	  @discussion Perform the second phase construction of a CSocketsWriter 
	*/
	void ConstructL();
	
	/*!
	@function SendNextPacket
	
	  @discussion Handle a 'write buffer empty' situation.
	*/    
	void SendNextPacket();
	
	
private: // Member variables
	
	/*! @const The size of the write buffer in bytes */
	enum {KWriteBufferSize = 400};
	
	/*! @const The maximum time allowed for a write to complete */
	static const TInt KTimeOut;
	
	/*!
	@enum TWriteState
	
	  @discussion Records whether a write request is pending
	  @value ESending A write request is pending with the socket server
	  @value EWaiting The idle state for this object
	*/
	enum TWriteState 
	{
		ESending, 
			EWaiting
	};
	
	/*! @var The socket to write to */
	RSocket&                iSocket;
	
	/*! @var An observer for status reporting */
	MEngineNotifier&        iEngineNotifier;
	
	/*! @var Accumulate data to send in here */
	HBufC8*			iTransferBuffer;
	
	/*! @var Holds data currently being sent to socket */
	HBufC8*			iWriteBuffer;
	
	/*! @var A timer used to cancel an outstanding write after a predefined timeout */
	CTimeOut*          iTimer;
	
	/*! @var The timeout to use */
	TInt                    iTimeOut;
	
	/*! @var The state of this active object */
	TWriteState             iWriteStatus;
	CCnvCharacterSetConverter *iCC;
    };
    
#endif // __SOCKETSWRITER_H__
    
