/*
 * $Id: BigInteger.h,v 1.1.1.1 2004/08/06 10:53:19 mraento Exp $
 *
 * Visual Codes for Symbian OS
 * Copyright (C) 2004 Beat Gfeller, Michael Rohs (rohs@inf.ethz.ch)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef BIGINTEGER_H
#define BIGINTEGER_H


// INCLUDES

#include <e32base.h>


// CONSTANTS


// FORWARD DECLARATIONS


// CLASS DECLARATION


class CBigInteger : public CBase {

public:

	CBigInteger();
	void ConstructL(TInt aBits);
	void ConstructL(const CBigInteger& bi);
	~CBigInteger();

	inline TInt GetBitCount() const { return iBits; }

	/** Set this big integer to the hex value argument. */
	void Set(const TDesC& hexNum);

	/** Set this big integer to the signed integer argument. */
	void Set(TInt aI);

	void Copy(const CBigInteger* aSrc);
	TBool Equals(const CBigInteger* aBigInt) const;

	void ShiftLeft();
	void ShiftRight();
	void ShiftLeft(TInt i);
	void ShiftRight(TInt i);

	void SetLSB();
	void ClearBit(TInt i);
	void SetBit(TInt i);
	TInt GetBit(TInt i) const;

	void And(const CBigInteger* aBigInt);
	void Or(const CBigInteger* aBigInt);
	void Xor(const CBigInteger* aBigInt);

	const TUint8* GetBuffer() const;

	/** Append this BigInteger as a hex string to the given argument string. */
	IMPORT_C void AppendToString(TDes& aString) const;

	/** Return least significant 32 bit as an integer. */
	TInt ToInt() const;

	/** Treat this and the other big integer as signed and add them together. */
	void Add(const CBigInteger* aBigInt);

	/** Add the signed integer to this big signed integer. */
	void Add(TInt aI);

private:

	/** Maximum number of bits in integer. */
	TInt iBits;

	/** Buffer for the bits. Least significant byte resides in iBuffer[0]. */
	HBufC8* iBuffer;

	inline TInt Hex2Num(TUint x) const;

};


#endif

// End of File