/*
 * $Id: RealPoint.h,v 1.1.1.1 2004/08/06 10:53:19 mraento Exp $
 *
 * Visual Codes for Symbian OS
 * Copyright (C) 2004 Beat Gfeller, Michael Rohs (rohs@inf.ethz.ch)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef REALPOINT_H
#define REALPOINT_H

// INCLUDES

#include <e32base.h>

// CONSTANTS

// FORWARD DECLARATIONS

// CLASS DECLARATION

/**
 * A two-dimensional point with coordinates of type TReal.
 */
class TRealPoint {

public:
	inline TRealPoint() 
	{ 
		SetXY(0, 0); 
	}
	
	inline TRealPoint(TReal aX, TReal aY) 
	{ 
		SetXY(aX, aY);
	}

	inline TReal operator==(const TRealPoint& aPoint) const 
	{
		return iX == aPoint.iX && iY == aPoint.iY;
	}

	inline TReal operator!=(const TRealPoint& aPoint) const
	{
		return iX != aPoint.iX || iY != aPoint.iY;
	}

	inline void SetXY(TReal aX, TReal aY)
	{ 
		iX = aX; iY = aY; 
	}

	inline TRealPoint& operator+=(const TRealPoint& aPoint)
	{
		iX += aPoint.iX; 
		iY += aPoint.iY;
		return *this;
	}

	inline TRealPoint& operator-=(const TRealPoint& aPoint)
	{
		iX -= aPoint.iX; 
		iY -= aPoint.iY;
		return *this;
	}

	/*
	inline TRealPoint& operator-=(const TRealPoint& aPoint);
	inline TRealPoint& operator+=(const TRealPoint& aPoint);
	inline TRealPoint operator-(const TRealPoint& aPoint) const;
	inline TRealPoint operator+(const TRealPoint& aPoint) const;
	inline TRealPoint operator-() const;
	*/

public:
	TReal iX;
	TReal iY;

};

#endif

// End of File