/*
 * $Id: VisualCodeObserver.h,v 1.1.1.1 2004/08/06 10:53:19 mraento Exp $
 *
 * Visual Codes for Symbian OS
 * Copyright (C) 2004 Beat Gfeller, Michael Rohs (rohs@inf.ethz.ch)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef VISUALCODEOBSERVER_H
#define VISUALCODEOBSERVER_H

// INCLUDES

#include <e32base.h>
#include <fbs.h>

#include "CodeInfo.h"

// CONSTANTS

// FORWARD DECLARATIONS

// CLASS DECLARATION


/**
 * Observes code sightings coming from the visual code system.
 */
class MVisualCodeObserver 
{
public:

	virtual void PictureUpdate(
		CFbsBitmap& aBitmap, 
		RPointerArray<CCodeInfo>* aCodes, 
		const TPoint& aTranslation,
		TInt aMinDiffTranslation,
		TInt aRotation,
		TInt aMinDiffRotation) = 0;

	virtual void PictureTaken(
		CFbsBitmap* aBitmap, 
		RPointerArray<CCodeInfo>* aCodes) = 0;

};

#endif
