/*
 * $Id: PictureTaker.h,v 1.1.1.1 2004/08/06 10:53:19 mraento Exp $
 *
 * Visual Codes for Symbian OS
 * Copyright (C) 2004 Beat Gfeller, Michael Rohs (rohs@inf.ethz.ch)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef PICTURETAKER_H
#define PICTURETAKER_H

// INCLUDES

#include <e32base.h>
#include <CameraServ.h>

//#include "VisualCodeSystem.h"

// CONSTANTS

// FORWARD DECLARATIONS

class CFbsBitmap;
class RCameraServ;
class CVisualCodeSystem;

// CLASS DECLARATION

class CPictureTaker : public CActive {

public:

	CPictureTaker(CVisualCodeSystem& aObserver);
	void ConstructL();
	virtual ~CPictureTaker();

	void StartL(
		TBool aSendUpdates, 
		TBool aSendTranslation,
		TBool aSendRotation);
	void StopL(); 

	inline CFbsBitmap* GetBitmap() { return iBmp; }

	void SetSendTranslation(TBool aSendTranslation);
	void SetSendRotation(TBool aSendRotation);

protected:

    virtual void RunL();
    virtual void DoCancel();

private:

	void CameraOnL();
	void CameraOffL();

private:

	CFbsBitmap* iBmp;
	RCameraServ* iCamera;
	TBool iTakePictureStop;
	TBool iCameraIsOn;
	TBool iBitmapInitialized;

private: 

	TBool GetImageMovement(CFbsBitmap& iBmp);

	TBuf8<3*160>* scanline; // @todo: make dynamic

	TInt (*blocks1)[10];
	TInt (*blocks2)[10];
	TInt currentBlock;

	TInt iMinDiffTranslation;
	TInt iMinDiffRotation;

private:

	CVisualCodeSystem& iObserver;

	TBool iSendUpdates;
	TBool iSendTranslation;
	TBool iSendRotation;

	TPoint iTranslation;
	TInt iRotation;

	TInt iFrameCounter;

public:

	TInt debugTInt;
	TBuf<256> debugTBuf;

};

#endif

// End of File
