/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#if !defined(CALL_RECORDER_H_INCLUDED)

#define CALL_RECORDER_H_INCLUDED 1

#include "call_listener.h"
#include "mda_recorder.h"

class CCall_record : public Ccall_listener, public Mrecorder_callback, public MSettingListener  {
public:
	virtual ~CCall_record();

	static CCall_record* NewL(MApp_context& Context, i_status_notif* i_cb, TDirection dir);
	void test();
private:
	CCall_record(MApp_context& Context);
	void ConstructL(i_status_notif* i_cb, TDirection dir);
	virtual void handle_answered();
	virtual void stopped(bool reset=false);
	virtual void error(const TDesC& descr);
	virtual void opened();

	void SettingChanged(TInt Setting);
	bool can_record;
	bool record_all;
	CMda_recorder* recorder;
};

#endif
