#ifndef CL_CAMERA_H_INCLUDED
#define CL_CAMERA_H_INCLUDED 1

#include "status_notif.h"
#include <checkedactive.h>
#include <app_context.h>

class MSnapShotNofifier {
public:
	virtual void Error(TInt aCode, const TDesC& aDescription) = 0;
	virtual void Taken(const TDesC& aFileName) = 0;
	virtual void Info(const TDesC& aMsg) = 0;
};

class CSnapShot {
public:
	static CSnapShot* NewL(MApp_context& Context);
	virtual void TakeSnapShot(const TDesC& aDir, MSnapShotNofifier* aNotifier) = 0;
	virtual void CancelSnapShot(MSnapShotNofifier* aNotifier) = 0;
	virtual ~CSnapShot() { }
};

#endif //CL_CAMERA_H_INCLUDED
