/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#ifndef CL_CIRCULAR_H_INCLUDED
#define CL_CIRCULAR_H_INCLUDED 1

#include "badesca.h"

class MListObserver {
public:
	virtual void ContentsChanged() = 0;
};

class CCircularLog : public MDesCArray, public CBase {
public:
	static CCircularLog* NewL(int Size, bool Reverse);
	void AddL(const TDesC& String);
	void DeleteLast();
	~CCircularLog();
	void SetObserver(MListObserver* Observer);

	// From MDesCArray
	virtual TInt MdcaCount() const;
	virtual TPtrC16 MdcaPoint(TInt aIndex) const;
private:
	CCircularLog(bool Reverse);
	void ConstructL(int Size);

	bool	iReverse;
	int	iSize;
	int	iFirst;
	int	iLast;

	CDesCArrayFlat*	iArray;
	MListObserver*	iObserver;
};

#endif // CL_CIRCULAR_H_INCLUDED
