/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#ifndef CL_HTTP_H_INCLUDED
#define CL_HTTP_H_INCLUDED 1

#include "ver.h"
#include "ftp.h"

class CHttp : public CBase, public MContextBase, public MTimeOut, public MSocketObserver {
public:
	static CHttp* NewL(MApp_context& Context, MSocketObserver& obs);
	~CHttp();
	void Connect(TUint32 IapID, const TDesC& UrlBase, const TDesC& Proxy, TInt ProxyPort);
	void Store(const TDesC& filename, const TDesC& meta=KNullDesC, HBufC8* Packet=0);
	void Close();
	void Cwd(const TDesC& dir);
	static void AppendUrlEncoded(TDes& into, const TDesC& str);
private:
	CHttp(MApp_context& Context, MSocketObserver& obs);
	void ConstructL();
	MSocketObserver& observer;
	void HandleFileL();
	bool HandleFile();
	void RetryHandleFile();

	// MSocketObserver
	virtual void success(CBase* source);
	virtual void error(CBase* source, TInt code, const TDesC& reason);
	virtual void info(CBase* source, const TDesC& msg);

	void expired(CBase*);

	bool ReadFile();

	enum state { IDLE, READING_FILE, CONNECTING, CONNECTING_SOCKET, HEAD_TX, BODY_TX, CONNECTED, RESULT_OK_WAIT,
		RETRY_HANDLE};
	state current_state;


	TUint32		iIapId;
	CConnectionOpener *iInitiator;
	RSocketServ	iOwnedServ;
#ifdef __S60V2__
	RConnection	iOwnedConnection;
#endif
	CProtoSocket*	iSocket;

	RFile		file;
	RFile		input;
	TBuf<256>	iPath;
	TBuf<128>	iHost;
	TBuf<128>	iProxy; TInt iProxyPort;

	TInetAddr	iAddr; bool iAddrKnown;

	TBuf<40>	iState;
	TFileName	iFilename;
	HBufC8*		iContents;
	HBufC*		iURL;
	TBuf8<500>	head;
	TInt		iFileSize;
	TInt		iOffset;
	TInt		iRetryCount; TInt iLastError;
	static const TInt	MAX_RETRIES;
	TInt		MAXSIZE;
	CTimeOut	*iWait;
	TBuf<200>	iMeta;
	HBufC8*		iPacket;
	bool		last_part;
};

#endif
