/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


// Mlogger.h: interface for the Mlogger class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_I_LOGGER_H__3E3A2582_93BF_4024_ABEC_8399BB61A5B5__INCLUDED_)
#define AFX_I_LOGGER_H__3E3A2582_93BF_4024_ABEC_8399BB61A5B5__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "e32std.h"

_LIT(KLog_cellid, "area, cell, nw");
_LIT(KLog_profile, "profile");
_LIT(KLog_cellname, "base");
_LIT(KLog_location, "location");
_LIT(KLog_activity, "UserActivity");
_LIT(KLog_app, "app");
_LIT(KLog_bt, "devices");
_LIT(KLog_gps, "gps");

class Mlogger  
{
public:
	enum log_priority {
		INFO,
		DEBUG,
		VALUE,
		UNCHANGED_VALUE,
		ERR
	};

	virtual void register_source(const TDesC& name, const TDesC& initial_value, const TTime& time) = 0;
	virtual void new_value(log_priority priority, const TDesC& name, const TDesC& value, const TTime& time) = 0;
	virtual void unregister_source(const TDesC& name, const TTime& time) = 0;
	virtual const TDesC& name() const = 0;
	Mlogger() { };
	virtual ~Mlogger() { };

};

#endif // !defined(AFX_I_LOGGER_H__3E3A2582_93BF_4024_ABEC_8399BB61A5B5__INCLUDED_)
