/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#ifndef LOG_BASE_IMPL_H_INCLUDED

#define LOG_BASE_IMPL_H_INCLUDED

#include "i_log_source.h"
#include <e32base.h>
#include <f32file.h>
#include "i_logger.h"
#include "app_context.h"

class Mlog_base_impl : public i_log_source, public MContextBase {
public:
	void add_sinkL(Mlogger* sink);
	void add_sinkL(Mlogger* sink, const TTime& time);
	void release_sinks();
	const TDesC& get_name();
	const TDesC& get_value();
	virtual void ConstructL(const TDesC& name, const TDesC& format);
	Mlog_base_impl(MApp_context& Context);
	virtual ~Mlog_base_impl();
	void post_new_value(const TDesC& value, Mlogger::log_priority priority=Mlogger::VALUE);
	void post_new_value(const TDesC& value, const TTime& time, Mlogger::log_priority priority=Mlogger::VALUE);
protected:
	HBufC* log_name;
	HBufC* log_format;
	CArrayFixFlat<Mlogger*>* loggers;
};

class Clog_base_impl : public Mlog_base_impl, public CBase {
public:
	Clog_base_impl(MApp_context& Context);
	static Clog_base_impl* NewL(MApp_context& Context, const TDesC& name, const TDesC& format);
};

#endif
