/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#if !defined(LOG_SOUNDLEVEL_H_INCLUDED)

#define LOG_SOUNDLEVEL_H_INCLUDED

#include "i_log_source.h"
#include "log_base_impl.h"
#include <e32base.h>
#include <MdaAudioInputStream.h>
#include <f32file.h>
#include <etelbgsm.h>
#include "riff.h"
#include "recorder.h"
#include "app_context.h"
#include "mda_recorder.h"

class Clog_soundlevel : public CTimer, public Mrecorder, public Mlog_base_impl {
public:
	~Clog_soundlevel();

	const TDesC& get_value();

	void RunL();

	static Clog_soundlevel* NewL(MApp_context& Context);
	virtual void stopped(bool reset=false);
	virtual void opened();
	virtual void error(const TDesC& descr);
	virtual void record();
private:
	Clog_soundlevel(MApp_context& Context);
	void ConstructL();

	HBufC* soundlevel_value;

	double prev_soundlevel;

	int doFile(WaveFile& inWave, unsigned long *lastFreq, long *maxSample);
	
	enum state { OPENING, IDLE, RECORDING };
	state current_state;
	void calculate();
	void set_timer(TInt seconds);

	RLine line;
};

#endif
