/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#if !defined(MDA_RECORDER_H_INCLUDED)

#define MDA_RECORDER_H_INCLUDED 1

#include <e32base.h>

#define NULL 0
#include <MdaAudioSampleEditor.h>
#include <f32file.h>
#include "app_context.h"
#include "riff.h"
#include <mda/Common/GsmAudio.h>

#ifndef __S60V2__
#include <AmrMda.h>
#endif

class Mrecorder_callback {
public:
	virtual void stopped(bool reset=false) = 0;
	virtual void error(const TDesC& descr) = 0;
	virtual void opened() = 0;
};

class CMda_recorder : public CTimer, public MMdaObjectStateChangeObserver, public MContextBase {
public:
	virtual ~CMda_recorder();

	static CMda_recorder* NewL(MApp_context& Context, Mrecorder_callback* i_cb, TInt channels, TInt freq, TInt seconds);
	virtual void MoscoStateChangeEvent(CBase* aObject, TInt aPreviousState, TInt aCurrentState, TInt aErrorCode);

	//virtual void record();
	virtual void record(const TDesC& filename);
	void save(const TDesC& filename);
	bool IsIdle() { return current_state==IDLE; }

protected:
	void ConstructL(Mrecorder_callback* i_cb, TInt channels, TInt freq, TInt seconds);
	//HBufC8*	buf; TPtr8 bufdes;
	CMda_recorder(MApp_context& Context);
	void open();
	void RunL();
private:
	Mrecorder_callback* cb;
	void do_record();

	enum state { IDLE, OPENING, STARTING_RECORD, RECORDING, STOPPING };
	state current_state;

#ifndef __S60V2__
	TMdaRawAmrClipFormat format;
	TMdaRawAmrAudioCodec* codec; 
	TMdaAudioDataSettings args;
	CMdaServer* audio_server;
#endif
	//TMdaDesClipLocation *clip;
	TMdaFileClipLocation *clip;

	CMdaAudioRecorderUtility* recorder_util;

	TBuf<100> msg;
	int rec_seconds;
	int rec_freq;
	int rec_channels;
};

#endif
