/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#if !defined(RECORDER_H_INCLUDED)


#define RECORDER_H_INCLUDED 1

#include <e32base.h>
#include <MdaAudioInputStream.h>
#include <mda/common/audio.h>
#include <f32file.h>
#include "app_context.h"
#include "riff.h"


class Mrecorder : public MMdaAudioInputStreamCallback {
public:
	virtual ~Mrecorder();

	const TDesC& get_value();

	void CheckedRunL();

	static Mrecorder* NewL();
	void  MaiscOpenComplete (TInt aError);
	void  MaiscBufferCopied (TInt aError, const TDesC8 &aBuffer);
	void  MaiscRecordComplete (TInt aError);	

	virtual void stopped(bool reset=false) = 0;
	virtual void error(const TDesC& descr) = 0;
	virtual void opened() = 0;
	virtual void record();
	void save(const TDesC& filename);

protected:
	void ConstructL(TInt channels, TInt freq, TInt seconds);
	HBufC8*	buf; TPtr8 bufdes;
	Mrecorder();
	void open();
private:
	CMdaAudioInputStream* istream;

	TMdaWavClipFormat format;
	TMdaPcmWavCodec codec; 
	TMdaAudioDataSettings args;
	TMdaFileClipLocation audio_loc;

	TBuf<100> msg;
	int rec_seconds;
	int rec_freq;
	int rec_channels;
};

#endif