#ifndef CL_TRANSFER2_H_INCLUDED
#define CL_TRANSFER2_H_INCLUDED 1

#include <d32dbms.h>
#include <app_context.h>
#include "status_notif.h"
#include <connectioninit.h>
#include <xmlbuf.h>

class CHttpTransfer2 : public CCheckedActive {
public:
	static CHttpTransfer2* NewL(MApp_context& Context,
		RDbDatabase& Db, MSocketObserver* aStatusNotif);

	virtual void AddFileToQueueL(const TDesC& aFileName, TInt UrlSetting,
		TInt ScriptSetting, TBool DeleteAfter, const TDesC& aMeta,
		CXmlBuf* aPacket, TInt aWaitTime=0) = 0;
	virtual TInt DeleteFile(const TDesC& aFileName) = 0;
	virtual TInt DoNotTransfer(const TDesC& aFileName) = 0;
	virtual TInt MoveToOld(const TDesC& aFileName) = 0;
	virtual TBool FileIsQueued(const TDesC& aFileName) = 0;
	virtual void Trigger(TBool Force=EFalse) = 0;

	CHttpTransfer2();
	virtual ~CHttpTransfer2();
};

#endif