/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#ifndef CL_WEB_H_INCLUDED
#define CL_WEB_H_INCLUDED 1

#include <aknform.h>
#include "db.h"
#include "ftp.h"
#include "log_base_impl.h"

class CSavedPoints : public MDBStore, public MContextBase, public CBase {
public:
	enum TEndPoint { FROM=0, TO=1 };

	static CSavedPoints* NewL(MApp_context& Context, RDbDatabase& Db);
	const CDesCArray& Points(TEndPoint p) const;
	void AddPoint(TEndPoint p, const TDesC& Point);
	void IncUsage(TEndPoint p, TInt PointIdx);

	virtual ~CSavedPoints();
private:
	CSavedPoints(MApp_context& Context, RDbDatabase& Db);
	void ConstructL();

	CDesCArray*		iPoints[2];
	CArrayFixFlat<TInt>*	iIdxs[2];
	TInt			iNextIdx;
};

class CWebForm : public CAknForm, public MContextBase
{
public:
        static CWebForm* NewL(MApp_context& Context, CConnectionOpener& Opener, Mlog_base_impl& Log);
	
        virtual ~CWebForm();
	
        TInt ExecuteLD(); 
        void PrepareLC(); 
	
private:  // Constructor
        CWebForm(MApp_context& Context, CConnectionOpener& Opener, Mlog_base_impl& Log);
        void ConstructL();
	
private:  // Functions from base class
        void PostLayoutDynInitL();
        TBool QuerySaveChangesL();
        TBool SaveFormDataL(); 
        void DoNotSaveFormDataL();
	virtual TBool OkToExitL( TInt aButtonId ) ;

	TInt  GetCurrentItem(TInt Id);

	CSavedPoints*	iPoints;
	CDb*		iDb;
	bool		iSaved[2];
	TInt		iLastKey;

	CConnectionOpener& iOpener;
	Mlog_base_impl& iLog;
};

#endif
