#!/usr/bin/perl

open(NAMES, "<names.txt");
while(<NAMES>) {
	chop;
	($cell, $name)=split(/\t/);
	$oname=$name;
	if ($seen{$name}) {
		$name.="_" . $seen{$name};
	}
	$seen{$oname}++;
	$names{$cell}=$name;
}
close(NAMES);

while(<>) {
	last if (/^MAPP/);
	chop;
	if (/merging/) {
		/^([^ ]+) merging:/;
		$dt=$1;
		/merging: (.*) into/;
		$cells=$1;
		/into ([0-9]+)/;
		$into=$1;
		push(@merging, [ $dt, $cells, $into ]);
		next;
	}
	/^([0-9]+):/;
	$id=$1;
	$m=undef;
	next unless (/merged to ([0-9]+)$/);
	$m=$1;
	next if ($id eq $m); 
	push(@{$merged{$m}}, $id);
	$into{$id}=$m;
}

foreach $m (keys %merged) {
	$r=$m;
	while ( $into{$m} ) {
		$m=$into{$m};
	}
	next if ($r==$m);
	push(@{$merged{$m}}, @{$merged{$r}});
	delete $merged{$r}
}

while(<>) {
	chop;
	($id, $cell)=split(/\t/);
	$cells{$id}=$cell;
}

foreach $m (@merging) {
	($dt, $cells, $into)=@{$m};
	@cells=split(/ +/, $cells);
	print $dt, " merging: ";
	$sep="";
	foreach $c (@cells) {
		$cell=$cells{$c};
		$cell=$names{$cell} if ($names{$cell}); 
		print $sep, $cell;
		$sep="\t";
	}
	$cell=$cells{$into};
	$cell=$names{$cell} if ($names{$cell}); 
	print " into ", $cell, "\n";
}

foreach $m (keys %merged) {
	@ids=@{$merged{$m}};
	push(@ids, $m);
	@ids=grep { ++$count{$_} < 2 } @ids;
	foreach $id (@ids) {
		$cell=$cells{$id};
		$cell=$names{$cell} if ($names{$cells{$id}}); 
		print $cell, "\t";
	}
	print "\n";
}

