/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#pragma warning(disable: 4706)
/*
* ============================================================================
*  Name     : CContext_logAppUi from Context_logAppUi.cpp
*  Part of  : context_log
*  Created  : 13.2.2003 by 
*  Implementation notes:
*     Initial content was generated by Series 60 AppWizard.
*  Version  :
*  Copyright: 
* ============================================================================
*/

#include "local_defaults.h"

// INCLUDE FILES
#include "Context_logAppUi.h"
#include "Context_logContainer.h" 
#include <context_log.rsg>
#include <sendnorm.rsg>
#include "context_log.hrh"
#include "context_logapp.h"

#include <avkon.hrh>
#include <aknquerydialog.h> 
#include <eikenv.h> // ieikonenv
#include <apgtask.h> // Going background 

#include <eikmenup.h>
#include <eiklabel.h>
#include <apgcli.h>

#include <stdlib.h> // for CloseSTDLIB()
#include <bautils.h>

#include <RPbkViewResourceFile.h>
#include <CPbkContactEditorDlg.h>
#include <CPbkContactEngine.h>
#include <CPbkSelectFieldDlg.h>
#include <CPbkContactItem.h>

#include "sms.h"
#include "web.h"

#include "keycapture.h"
#include <apgwgnam.h>

#include "userview.h"
#include "presencedetailview.h"

#include "cl_settings.h"
#include "log_systemevent.h"

#include <sacls.h>

#include "hideview.h"

#include "sms_snapshot.h"
#include "notifystate.h"
#include <context_log.mbg>
#include "btlist.h"
#include "transferdir2.h"
#include "viewids.h"

#include <raii_apgcli.h>

enum JOYSTICK_EVENTS {
	JOY_LEFT = 0xF807,
	JOY_RIGHT = 0xF808,
	JOY_UP = 0xF809,
	JOY_DOWN = 0xF80A,
	JOY_CLICK = 0xF845
};

const TUid KUidPhone = { 0x100058b3 };
const TUid KUidMenu = {  0x101f4cd2 };

const TInt KUidCloseLogValue=0x2003;
const TUid KUidCloseLog={KUidCloseLogValue};
const TInt KUidToBackgroundValue=0x2004;
const TUid KUidToBackground={KUidToBackgroundValue};

_LIT(cellid_file, "cellid_names.txt");
_LIT(install_cellid_file, "cellid_names_inst.txt");
_LIT(transfer_cellid_file, "cellid_names_trans.txt");

#ifndef __WINS__
_LIT(KIconFile, "c:\\system\\data\\context_log.mbm");
#else
_LIT(KIconFile, "z:\\system\\data\\context_log.mbm");
#endif

_LIT(file_prefix, "log");



// ================= MEMBER FUNCTIONS =======================

#ifdef __WINS__
class TDummyMsvObserver : public MMsvSessionObserver
{
	void HandleSessionEvent(TMsvSessionEvent, TAny*, TAny*, TAny*) { }
	void HandleSessionEventL(TMsvSessionEvent, TAny*, TAny*, TAny*) { }
};
#endif

void CContext_logAppUi::ReportError(const TDesC& Source,
	const TDesC& Reason, TInt Code)
{
	TBuf<256> msg=_L("Unhandled error ");
	msg.AppendNum(Code);
	msg.Append(_L(" "));
	msg.Append(Reason.Left(120));
	if (app_log) {
		TInt err;
		TRAP(err, app_log->post_new_value(msg));
		TRAP(err, app_log->post_new_value(Source));
	}
}

TErrorHandlerResponse CContext_logAppUi::HandleError(TInt aError,
     const SExtendedError& /*aExtErr*/,
     TDes& aErrorText,
     TDes& aContextText)
{
	// TODO: handle aExtErr
	TBuf<256> msg;
	msg.Format(_L("Unhandled error %d %S %S"), aError, &aContextText, &aErrorText);
	if (app_log) {
		TRAPD(err, app_log->post_new_value(msg));

		HBufC* stack=AppContext().GetFormattedCallStack(_L("AppUi"));
		if (stack) {
			TRAP(err, app_log->post_new_value(*stack));
		}
		delete stack;
		AppContext().ResetCallStack();
	}

	PrepareToExit();
	//CActiveScheduler::Stop();
	RDebug::Print(_L("delete this"));
	delete this;
	RDebug::Print(_L("User::Exit"));
	User::Exit(2003);
	return ENoDisplay;
}

void CContext_logAppUi::LogAppEvent(const TDesC& msg)
{
	CALLSTACKITEM(_L("CContext_logAppUi::LogAppEvent"));

	if (iLastLog) iLastLog->AddL(msg);
	if (app_log) app_log->post_new_value(msg);
}

void CContext_logAppUi::ConstructL()
{
	CALLSTACKITEM(_L("CContext_logAppUi::ConstructL"));


#ifdef __WINS__
	//SetTime();
        TTime now;
        now.HomeTime();
        now+=TTimeIntervalHours(2);
        User::SetHomeTime(now);
#endif

#ifdef __WINS__
	//{ TRAPD(errs, StartStarterL(_L("context_log"), KUidcontext_log, true, iEikonEnv->WsSession())); }
#else
	{ TRAPD(errs, StartStarterL(_L("context_log"), KUidcontext_log, true)); }
#endif


#if defined(__WINS__) && 0
	{
	TDummyMsvObserver d;
	CMsvSession *s=CMsvSession::OpenSyncL(d);
	CClientMtmRegistry *r=CMtmUiRegistry::NewL(*s);
	TBuf<128> msg;
	for (int i=0; i< r->NumRegisteredMtmDlls(); i++) {
		TUid mtmuid=r->MtmTypeUid(i);
		const CMtmDllInfo& i=r->RegisteredMtmDllInfo(mtmuid);
		msg=mtmuid.Name();
		msg.Append(_L(" "));
		msg.Append(i.HumanReadableName());
		TUid tech=r->TechnologyTypeUid(mtmuid);
		msg.Append(_L(" ")); msg.Append(tech.Name());
		RDebug::Print(msg);
	}
	delete r; delete s;
	}
#endif
	state=_L("setting exception handler");

	RThread me;
	me.Open(me.Id());
	me.SetExceptionHandler(exceptionhandler, 
		KExceptionAbort|KExceptionFault|KExceptionFpe|KExceptionInteger|
		KExceptionKill|KExceptionUserInterrupt);
	me.Close();

#ifndef __WINS__
	bool wins=false;
#else
	bool wins=true;
#endif

	state=_L("fl");
	fl=Cfile_logger::NewL(AppContext(), file_prefix, Mlogger::INFO);
	AppContext().SetFileLog(fl);

	state=_L("create app event");
	app_log=Clog_base_impl::NewL(AppContext(), _L("app event"), _L(""));
	app_log->add_sinkL(fl);
	AppContext().SetActiveErrorReporter(this);

	TInt notif_err;
	TRAP(notif_err, iContextRunning=CNotifyState::NewL(AppContext(), KIconFile));
	if (iContextRunning) iContextRunning->SetCurrentState( EMbmContext_logC, EMbmContext_logC );

	TBool logging_enabled;
	Settings().GetSettingL(SETTING_LOGGING_ENABLE, logging_enabled);
	TRAP(notif_err, iLoggingRunning=CNotifyState::NewL(AppContext(), KIconFile));
	if (logging_enabled) {
		if(iLoggingRunning) iLoggingRunning->SetCurrentState( EMbmContext_logL, EMbmContext_logL );
	} else {
		if(iLoggingRunning) iLoggingRunning->SetCurrentState( EMbmContext_logL_not, EMbmContext_logL_not );
	}

	state=_L("creating op waiter");

	iWait=CTimeOut::NewL(*this);
	iWaitingOps=CList<TCallBack>::NewL();

	TInt iap;
	Settings().GetSettingL(SETTING_IP_AP, iap);
	Settings().WriteSettingL(SETTING_CURRENT_AP, iap);

	iAPSettingMaintainer=CApSettingMaintainer::NewL(AppContext());


#ifndef NO_PRESENCE

	iBTDb=CDb::NewL(AppContext(), _L("BTDEV"), EFileRead|EFileWrite|EFileShareAny);
	iBuddyBTs = CBTDeviceList::NewL(AppContext(), iBTDb->Db(), _L("BUDDIES"));
#endif //NO_PRESENCE

#ifndef REALLY_ONLY_LOGGING
	iApBTs = CBTDeviceList::NewL(AppContext(), iBTDb->Db(), _L("AP"));
	state=_L("creating connection opener");

	iServ.Connect();
#ifndef __S60V2__
	iConnectionOpener=CConnectionOpener::NewL(*this, iServ);
#else
	iConnection.Open(iServ);
	iConnectionOpener=CConnectionOpener::NewL(*this, iServ, iConnection);
#endif
	//iConnectionOpener->MakeConnectionL(1);
#endif

	ringing=false;

	state=_L("BaseConstructL");

	BaseConstructL();

	iCaptionMyContext=CEikonEnv::Static()->AllocReadResourceL(R_ME_CAPTION);
	
	state=_L("notify");

	Settings().NotifyOnChange(SETTING_LOGGING_ENABLE, this);

	//__UHEAP_MARK;

	state=_L("smsh");

	//iSmsSocket=CSmsSocket::NewL(AppContext(), _L("itse"), this);

	smsh=new (ELeave) sms;
	smsh->ConstructL();

#ifndef NO_PRESENCE
	state=_L("iUserContextLog");

	iUserContextLog=CCircularLog::NewL(1,ETrue);
	
	CEikonEnv::Static()->ReadResourceAsDes16(prev, R_PREVIOUS);
	CEikonEnv::Static()->ReadResourceAsDes16(not_avail, R_JABBER_NOT_AVAIL);

	iUserContext=HBufC::NewL(iCaptionMyContext->Length()+256);
	PresenceToListBoxL(0, iUserContext, iCaptionMyContext, 0,
		prev, not_avail);
	iUserContextLog->AddL(*iUserContext);

#endif

	LogAppEvent(_L("Starting"));
	iLastLog=CCircularLog::NewL(20, true);

#if __WINS__
	int xi=0, count1=40, count2=15;
	for (xi=0; xi<count1; xi++) {
		TBuf<20> t=_L("test log ");
		t.AppendNum(xi);
		LogAppEvent(t);
	}
	for (xi=0; xi<count2; xi++) {
		iLastLog->DeleteLast();
	}
#endif

	LogAppEvent(_L("Starting 1.2"));
	state=_L("create cell map");
	iCellDb=CDb::NewL(AppContext(), _L("CELLS"), EFileRead|EFileWrite);

	LogAppEvent(_L("Starting 1.5"));
	iCellMap=CCellMap::NewL(AppContext(), iCellDb->Db());
	// NOTE: we must construct base_counter directly after
	// cellmap so that the mappings get transfered correctly
	// from the base db to the cell map db after upgrading

	LogAppEvent(_L("Starting 2"));
	state=_L("create base counter");
	base_counter=new (ELeave) bases(this, AppContext(), *iCellMap);
	base_counter->ConstructL();
	base_counter->test(); // NOP on ARMI
	//return;

	//iRouteRecorder = CRouteRecorder::NewL(AppContext(), *iCellMap, *base_counter);

	state=_L("create status view");
	iStatusView = CStatusView::NewL(AppContext(), *iCellMap);
	iAppContainer = iStatusView->Container();
	AddViewL( iStatusView );      // transfer ownership to CAknViewAppUi
	SetDefaultViewL(*iStatusView);

	iLoggers=new (ELeave) CArrayPtrFlat<Mlog_base_impl>(10);
	iMediaPublishers=new (ELeave) CArrayPtrFlat<CPicturePublisher>(10);

	discoverer=CDiscover::NewL(AppContext());
	iLoggers->AppendL(discoverer);

#ifndef NO_PRESENCE
	state=_L("create presence publisher");
	iPresencePublisher=CPresencePublisher::NewL(AppContext(), this, *this, iBuddyBTs);
#endif

#ifndef REALLY_ONLY_LOGGING
	state=_L("create upload view");
	TUid uploadv1=KUploadView1;
	iUploadView = CUploadView::NewL(AppContext(), iPresencePublisher, &(iStatusView->iNextViewId),
		uploadv1, false, discoverer);
	AddViewL( iUploadView );      // transfer ownership to CAknViewAppUi

	TUid uploadv2=KUploadView2;
	iUploadViewTagOnly = CUploadView::NewL(AppContext(), iPresencePublisher, &(iStatusView->iNextViewId),
		uploadv2, true, discoverer);
	AddViewL( iUploadViewTagOnly );      // transfer ownership to CAknViewAppUi

	state=_L("create code prompt");
	TUid statusv=KStatusView;

#ifdef USE_VISUALCODES
	iCodePrompt=CVisualCodePrompt::NewL(this, statusv, &(iStatusView->iNextViewId));
#endif

	state=_L("create multiprompt");
	iMultiPrompt=CMultiPrompt::NewL(AppContext());
	iMultiPrompt->AddPromptL(0, iUploadView);
	iMultiPrompt->AddPromptL(1, iUploadViewTagOnly);
	iMultiPrompt->AddPromptL(2, iCodePrompt);
	MUploadPrompt *pr=iMultiPrompt;

	iTransferDir=CTransferDir::NewL(AppContext(), *this);

	state=_L("create picture publisher");
	AddMediaPublisher(CPicturePublisher::NewL(AppContext(), *this, _L("?:\\nokia\\images"),
		_L("*jpg"), SETTING_PICTURE_ENABLE, *pr, iTransferDir));
	AddMediaPublisher(CPicturePublisher::NewL(AppContext(), *this, _L("?:\\images"),
		_L("*jpg"), SETTING_PICTURE_ENABLE, *pr, iTransferDir));

	AddMediaPublisher(CPicturePublisher::NewL(AppContext(), *this, _L("?:\\nokia\\videos"),
		_L("*3gp"), SETTING_PICTURE_ENABLE, *pr, iTransferDir));
	AddMediaPublisher(CPicturePublisher::NewL(AppContext(), *this, _L("?:\\videos"),
		_L("*3gp"), SETTING_PICTURE_ENABLE, *pr, iTransferDir));

	AddMediaPublisher(CPicturePublisher::NewL(AppContext(), *this, _L("?:\\nokia\\Sounds\\digital"),
		_L("*amr"), SETTING_PICTURE_ENABLE, *pr, iTransferDir, _L("*aac")));
	AddMediaPublisher(CPicturePublisher::NewL(AppContext(), *this, _L("?:\\Sounds\\digital"),
		_L("*amr"), SETTING_PICTURE_ENABLE, *pr, iTransferDir, _L("*aac")));

	// n-gage
	AddMediaPublisher(CPicturePublisher::NewL(AppContext(), *this, _L("?:\\Record"),
		_L("*amr"), SETTING_PICTURE_ENABLE, *pr, iTransferDir, _L("*aac")));
	
	AddMediaPublisher(CPicturePublisher::NewL(AppContext(), *this, _L("?:\\Sounds\\digital"),
		_L("*amr"), SETTING_PICTURE_ENABLE, *pr, iTransferDir, _L("*aac")));	

	AddMediaPublisher(CPicturePublisher::NewL(AppContext(), *this, _L("?:\\system\\apps\\ContextNote"),
		_L("*txt"), SETTING_PICTURE_ENABLE, *pr, iTransferDir));
#endif //REALLY_ONLY_LOGGING

	LogAppEvent(_L("Starting 3"));
	state=_L("create settings view");
	auto_ptr<CSettingsView> iSettingsView(CSettingsView::NewL(AppContext()));
	AddViewL(iSettingsView.get());
	iSettingsView.release();

	state=_L("create log view");
	auto_ptr<CAppLogView> logview(CAppLogView::NewL(iLastLog));
	AddViewL(logview.get());
	iLogView=logview.release();

	TBool enable_options=false;

#ifndef NO_PRESENCE
	state=_L("create user view");
	auto_ptr<CUserView> userview(CUserView::NewL(iUserContextLog, iPresencePublisher));
	AddViewL(userview.get());
	CUserView* v=userview.release();
#  ifdef REALLY_ONLY_LOGGING
	SetDefaultViewL(*v);
#  else
	if ( ! Settings().GetSettingL(SETTING_OPTIONS_ENABLE, enable_options) || !enable_options) {
		SetDefaultViewL(*v);
	}
#  endif
#endif // NO_PRESENCE

#if 0
	state=_L("create hide view");
	auto_ptr<CHideView> Hideview(CHideView::NewL());
	AddViewL(Hideview.get()); 
	if ( Settings().GetSettingL(SETTING_OPTIONS_ENABLE, enable_options) && enable_options) {
		Hideview.release();
	} else {
		SetDefaultViewL(*(Hideview.release()));
	}
#endif

#ifndef NO_PRESENCE
	state=_L("create presence detail");
	auto_ptr<CPresenceDetailView> detailview(CPresenceDetailView::NewL());
	AddViewL(detailview.get());
	iPresenceDetailView=detailview.release();

	auto_ptr<CBTDevApView> btView2(CBTDevApView::NewL(AppContext(), iBuddyBTs, EFalse));
	AddViewL(btView2.get());
	iBTBuddiesView = btView2.release();
#endif //NO_PRESENCE

#ifndef REALLY_ONLY_LOGGING
	state=_L("create btdevap view");
	auto_ptr<CBTDevApView> btView(CBTDevApView::NewL(AppContext(), iApBTs));
	AddViewL(btView.get());
	iBTDevApView = btView.release();

	iBTAPManager = CBTAPManager::NewL(AppContext(), iApBTs);
#endif //REALLY_ONLY_LOGGING

	state=_L("create cell callback");
	caller=new (ELeave) name_cell_callback(this);
	caller->ConstructL();

	name_times=new (ELeave) CArrayFixFlat<TTime>(2);
	name_names=new (ELeave)CArrayFixFlat<HBufC*>(2);

	state=_L("create note");
	globalNote=CAknGlobalNote::NewL();

#ifndef REALLY_ONLY_LOGGING
	state=_L("create snapshot");
	iSnapShot=CSnapShot::NewL(AppContext());

	state=_L("create mms");
	iMMS=CMMS::NewL();
#endif // REALLY_ONLY_LOGGING

	state=_L("create keylock");
	User::LeaveIfError(keylock.Connect());

	iEikonEnv->AddForegroundObserverL(*this);

	{
		MoveIntoDataDirL(AppContext(), cellid_file);
		// copy the installed cellid_names over the real one, if
		// one has been installed

		TFileName install_cellid_filen, cellid_filen;
		install_cellid_filen.Format(_L("%S%S"), &AppDir(), &install_cellid_file);
		cellid_filen.Format(_L("%S%S"), &DataDir(), &cellid_file);
		if (BaflUtils::FileExists(Fs(), install_cellid_filen)) {
			User::LeaveIfError(BaflUtils::CopyFile(Fs(), install_cellid_filen, cellid_filen));
			User::LeaveIfError(BaflUtils::DeleteFile(Fs(), install_cellid_filen));
		}

		if (cellid_name_file.Open(Fs(), cellid_filen, 
			EFileShareAny | EFileStreamText | EFileRead | EFileWrite)!=KErrNone) {
			User::LeaveIfError(cellid_name_file.Create(Fs(), cellid_filen, 
				EFileShareAny | EFileStreamText | EFileRead | EFileWrite));
		}
	}

	CC()->PrepareToConvertToOrFromL(KCharacterSetIdentifierIso88591, Fs());
	read_cellid_names();
		
	iAppContainer->CurrentLoc()->add_sinkL(iPresencePublisher);
	iAppContainer->CurrentLoc()->add_sinkL(iAppContainer);

#if !defined(REALLY_ONLY_LOGGING) || defined(DO_LOCATIONING)
	state=_L("create locationing");

	loc=Clocationing::NewL(AppContext(), this, this, smsh, iPresencePublisher);
#endif

	state=_L("create cell ann");
	cell_ann=Clog_base_impl::NewL(AppContext(), _L("cell ann"), _L(""));
	cell_ann->add_sinkL(fl);
	// don't show in UI
	//cell_ann->add_sinkL(iAppContainer);

	//NOTHERE

#ifndef REALLY_ONLY_LOGGING
	state=_L("create context name");
	context_ann=Clog_base_impl::NewL(AppContext(), _L("context name"), _L(""));
	context_ann->add_sinkL(fl);

	state=_L("create web search");
	web_log=Clog_base_impl::NewL(AppContext(), _L("web search"), _L(""));
	web_log->add_sinkL(fl);
#endif //REALLY_ONLY_LOGGING

	state=_L("create log cellid");
	lc=Clog_cellid::NewL(AppContext(), *iCellMap);
	iLoggers->AppendL(lc);
	if (lc) lc->add_sinkL(iAppContainer);
	if (lc) lc->add_sinkL(fl);
	if (lc) lc->add_sinkL(base_counter);
	if (lc) lc->add_sinkL(iPresencePublisher);
	//if (lc) lc->add_sinkL(iRouteRecorder);
	
	state=_L("create log sms");
	lsms=CLog_sms::NewL(AppContext(), _L("SMS "));
	iLoggers->AppendL(lsms);
	smsh->AddHandler(lsms);
	lsms->add_sinkL(fl);
	
#ifndef REALLY_ONLY_LOGGING
	state=_L("create sms snapshot");
	iSmsSnapshot=CSmsSnapshot::NewL(AppContext(), this, iPresencePublisher, iTransferDir->Transferer());
	smsh->AddHandler(iSmsSnapshot);
#endif //REALLY_ONLY_LOGGING

	state=_L("create log profile");
	lp=Clog_profile::NewL(AppContext());
	iLoggers->AppendL(lp);
	lp->add_sinkL(iAppContainer);
	lp->add_sinkL(fl);
	lp->add_sinkL(iPresencePublisher);

	/*
	if (wins && 0) {
		ls=Clog_soundlevel::NewL(AppContext());
		iLoggers->AppendL(ls);
		ls->add_sinkL(iAppContainer);
		ls->add_sinkL(fl);
	}
	*/

	state=_L("create log appuse");
	lau=CLog_AppUse::NewL(AppContext());
	iLoggers->AppendL(lau);
	if (wins) 
		lau->add_sinkL(iAppContainer);
	lau->add_sinkL(fl);

	state=_L("create commlog");
	comml=Clog_comm::NewL(AppContext(), this);
	ll=CLog_local::NewL(AppContext(), KLog_activity);
	iLoggers->AppendL(ll);
	iKeycaptureArgs.iKeyStatus=ll->RequestStatus();
	if (wins) 
		ll->add_sinkL(iAppContainer);
	ll->add_sinkL(fl);
	ll->add_sinkL(iPresencePublisher);

	state=_L("create system event loggers");
	Mlog_base_impl* l;
	l=CLog_SystemEvent::NewL(AppContext(), _L("Charger"), KUidChargerStatus); 
	iLoggers->AppendL(l); l->add_sinkL(fl);
	l->add_sinkL(iBTAPManager);
	l=CLog_SystemEvent::NewL(AppContext(), _L("Network status"), KUidNetworkStatus); 
	iLoggers->AppendL(l); l->add_sinkL(fl);

	//l=CLog_SystemEvent::NewL(AppContext(), _L("Signal strength"), KUidNetworkStrength); 
	//iLoggers->AppendL(l); l->add_sinkL(fl);

	discoverer->add_sinkL(iAppContainer);
	discoverer->add_sinkL(fl);
	discoverer->add_sinkL(iPresencePublisher);
	discoverer->add_sinkL(iBTAPManager);

#ifndef REALLY_ONLY_LOGGING
	iGps=CLogGps::NewL(AppContext());
	iLoggers->AppendL(iGps); 
	discoverer->add_sinkL(iGps);
	iGps->add_sinkL(iAppContainer);
	iGps->add_sinkL(fl);
	iGps->add_sinkL(iPresencePublisher);
#endif

	state=_L("create transferer");
	transferer=CSendUITransfer::NewL(AppContext(), this, Econtext_logCmdSendAppUi, DataDir(), AppDir());
	transferer->add_filesL(_L("log*txt"), true);
	transferer->add_filesL(_L("starter*txt"), true);
	transferer->add_filesL(_L("book*txt"), true);
	transferer->add_filesL(_L("calllog*txt"), true);
	transferer->add_filesL(_L("comm*txt"), false);
	transferer->add_filesL(_L("rec*amr"), false);
	transferer->add_filesL(_L("cellid_names_trans.txt"), false);

	iPeriodicTransfer=CPeriodicTransfer::NewL(AppContext(), 24, this);

	TInt pos=0;
	cellid_name_file.Seek(ESeekEnd, pos);

	/*
	answerer=Canswering::NewL(AppContext(), this);
	lp->add_sinkL(answerer);
	iAppContainer->CurrentLoc()->add_sinkL(answerer);
	*/
	//NOTHERE

	state=_L("create call recorders");
	in_recorder=CCall_record::NewL(AppContext(), this, CCall_record::INCOMING);
	out_recorder=CCall_record::NewL(AppContext(), this, CCall_record::OUTGOING);

	iAlerter=CAlerter::NewL(AppContext(), lp);
#ifndef REALLY_ONLY_LOGGING
	iUserNotifier = CUserNotifier::NewL(AppContext(), iAlerter);
#endif

	iKeycaptureArgs.iAppContext=&AppContext();

	state=_L("start keycapture");
	RWindowGroup wg=iEikonEnv->RootWin();
	iKeycaptureArgs.iParentWg=wg.Identifier();
	keycapture.start(_L("keycapture"), start_keycapture, (TAny*)&iKeycaptureArgs);
	
	iAppContainer->set_status(_L(""));

	iEikonEnv->SetSystem(ETrue);

	if (!wins)
		QueueOp(&CContext_logAppUi::hide);

	LogAppEvent(_L("Started"));

	current_state=IDLE;
	initialising=false;

	state=_L("");
	
}

void CContext_logAppUi::AddMediaPublisher(CPicturePublisher* aPublisher)
{
	auto_ptr<CPicturePublisher> p(aPublisher);
	iMediaPublishers->AppendL(aPublisher);
	p.release();
	iAppContainer->CurrentLoc()->add_sinkL(aPublisher);
}

void CContext_logAppUi::PublishOldMedia()
{
	if (iTransferDir && iTransferDir->Transferer()) {
		iTransferDir->Transferer()->Trigger();
	}
	if (iMediaPublishers) {
		for (int i=0; i< iMediaPublishers->Count(); i++) {
			iMediaPublishers->At(i)->PublishOld();
		}
	}
}

// ----------------------------------------------------
// CContext_logAppUi::~CContext_logAppUi()
// Destructor
// Frees reserved resources
// ----------------------------------------------------
//
CContext_logAppUi::~CContext_logAppUi()
{
	CALLSTACKITEM(_L("CContext_logAppUi::~CContext_logAppUi"));
	{
	CALLSTACKITEM(state);

	{
		CALLSTACKITEM(_L("1"));

		TTime t2;
		t2.HomeTime();
		if (fl) fl->new_value(Mlogger::VALUE, _L("APP close"), state, t2);

		delete iAPSettingMaintainer;

		Settings().CancelNotifyOnChange(SETTING_LOGGING_ENABLE, this);

		if (iTestFileOpen) iTestFile.Close();

		CEikonEnv::Static()->RemoveForegroundObserver(*this);
		keycapture.stop();

		delete iSmsSnapshot;

		delete comml;

		delete iUserNotifier;

		delete iCaptionMyContext;
		
		//delete lt;
		if (t) {
			t->Kill(0);
			delete t;
		}
	}


	{
		CALLSTACKITEM(_L("2"));
		//delete iRouteRecorder;

		delete cell_ann;
		delete context_ann;
		delete app_log;
		AppContext().SetActiveErrorReporter(0);
		delete web_log;
	}

	{
		CALLSTACKITEM(_L("3"));
		delete transferer;
		delete ftp_transfer;
		delete iPeriodicTransfer;

		delete iConnectionOpener;

		if (iAppContainer && iAppContainer->CurrentLoc()) iAppContainer->CurrentLoc()->release_sinks();
	}

	{
		CALLSTACKITEM(_L("4"));
		if (iLoggers) {
			for (int i=0; i< iLoggers->Count(); i++) {
				iLoggers->At(i)->release_sinks();
			}
			iLoggers->ResetAndDestroy();
		}
		delete iLoggers;

		AppContext().SetFileLog(0);
		delete iPresencePublisher;
		delete iUserContextLog;
		delete iUserContext;

		if (iMediaPublishers) {
			iMediaPublishers->ResetAndDestroy();
		}
		delete iMediaPublishers;

		delete iTransferDir;

		delete iMultiPrompt;
	}

	TTime t;
	t.HomeTime();
	{
		CALLSTACKITEM(_L("5"));

		if (fl) fl->new_value(Mlogger::VALUE, _L("APP"), state, t);
	}
	{
		CALLSTACKITEM(_L("5.1"));
		delete answerer;
		delete in_recorder;
		delete out_recorder;
		delete base_counter;
	}

	cellid_name_file.Close();
	keylock.Close();

	if (fl) fl->new_value(Mlogger::VALUE, _L("APP"), _L("del 1"), t);
	if (name_names) {
		for (int i=0; i< name_names->Count(); i++) {
			delete (*name_names)[i];
		}
	}

	delete name_times; delete name_names;

	delete globalNote;

	delete caller;
	delete loc;
	delete smsh;
	//delete iSmsSocket;

	delete iCodePrompt; 

	delete iSnapShot;
	delete iMMS;

	if (fl) fl->new_value(Mlogger::VALUE, _L("APP"), _L("del 2"), t);

	delete iCellMap;
	delete iCellDb;

	delete iBTAPManager;

	delete iApBTs;
	delete iBuddyBTs;
	delete iBTDb;

	delete iLastLog;

#ifdef __S60V2__
	iConnection.Close();
#endif
	iServ.Close();
	delete iWaitingOps;
	delete iWait;

	delete iAlerter;
	
	if (fl) fl->new_value(Mlogger::VALUE, _L("APP"), _L("del 3"), t);

	delete fl;

	{
		CALLSTACKITEM(_L("iLoggingRunning"));
		delete iLoggingRunning;
	}
	{
		CALLSTACKITEM(_L("iContextRunning"));
		delete iContextRunning;
	}

	{
		CALLSTACKITEM(_L("CloseSTDLIB"));
		CloseSTDLIB();
	}

#if defined(__S60V2__) && ! defined(__WINS__)
	// the cell change notification keeps the thread from
	// exiting otherwise
	{
		CALLSTACKITEM(_L("Force"));
		PrepareToExit();
		delete &iContext;
		User::Exit(0);
	}
#endif
	}
	//__UHEAP_MARKEND;
}

void CContext_logAppUi::hide()
{
	CALLSTACKITEM(_L("CContext_logAppUi::hide"));

	RWsSession& wsSession=CEikonEnv::Static()->WsSession();
	
	TApaTask task(wsSession);
	task.SetWgId(CEikonEnv::Static()->RootWin().Identifier());
	task.SendToBackground();
}

void CContext_logAppUi::unhide()
{
	CALLSTACKITEM(_L("CContext_logAppUi::unhide"));

	RWsSession& wsSession=CEikonEnv::Static()->WsSession();
	TApaTask task(wsSession);
	task.SetWgId(CEikonEnv::Static()->RootWin().Identifier());
	task.BringToForeground();
}


// ------------------------------------------------------------------------------
// CContext_logAppUi::::DynInitMenuPaneL(TInt aResourceId,CEikMenuPane* aMenuPane)
//  This function is called by the EIKON framework just before it displays
//  a menu pane. Its default implementation is empty, and by overriding it,
//  the application can set the state of menu items dynamically according
//  to the state of application data.
// ------------------------------------------------------------------------------
//
void CContext_logAppUi::DynInitMenuPaneL(
					 TInt aResourceId,CEikMenuPane* aMenuPane)
{
	CALLSTACKITEM(_L("CContext_logAppUi::DynInitMenuPaneL"));

	switch(aResourceId) {
	case R_CONTEXT_LOG_MENU:
#ifndef REALLY_ONLY_LOGGING
		if (fl) {
			if (fl->is_paused()) {
				aMenuPane->SetItemDimmed(Econtext_logCmdAppPauseLog, ETrue);	
				aMenuPane->SetItemDimmed(Econtext_logCmdAppUnPauseLog, EFalse);
			} else {
				aMenuPane->SetItemDimmed(Econtext_logCmdAppPauseLog, EFalse);	
				aMenuPane->SetItemDimmed(Econtext_logCmdAppUnPauseLog, ETrue);
			}
		} else {
			aMenuPane->SetItemDimmed(Econtext_logCmdAppPauseLog, ETrue);	
			aMenuPane->SetItemDimmed(Econtext_logCmdAppUnPauseLog, ETrue);
		}
#endif
#ifndef REALLY_ONLY_LOGGING
		if (iPresencePublisher) {
			if (iPresencePublisher->ConnectionSuspended()) {
				aMenuPane->SetItemDimmed(Econtext_logCmdAppSuspendPresence, ETrue);	
				aMenuPane->SetItemDimmed(Econtext_logCmdAppResumePresence, EFalse);
			} else {
				aMenuPane->SetItemDimmed(Econtext_logCmdAppSuspendPresence, EFalse);	
				aMenuPane->SetItemDimmed(Econtext_logCmdAppResumePresence, ETrue);
			}
		} else {
			aMenuPane->SetItemDimmed(Econtext_logCmdAppSuspendPresence, ETrue);	
			aMenuPane->SetItemDimmed(Econtext_logCmdAppResumePresence, ETrue);
		}
#endif
		break;
	case R_SENDUI_TOPMENU:
		transferer->DisplaySendMenuL(*aMenuPane, 1);
		break;
	case R_SENDUI_MENU:
		// sendui cascade
		transferer->DisplayMenuL(*aMenuPane);
		break;
	default:
		break;
	}
}

// ----------------------------------------------------
// CContext_logAppUi::HandleKeyEventL(
//     const TKeyEvent& aKeyEvent,TEventCode /*aType*/)
// ?implementation_description
// ----------------------------------------------------
//
TKeyResponse CContext_logAppUi::HandleKeyEventL(
						const TKeyEvent& /*aKeyEvent*/,TEventCode /*aType*/)
{
	CALLSTACKITEM(_L("CContext_logAppUi::HandleKeyEventL"));
	if (iAlerter) iAlerter->StopAlert();

	return EKeyWasNotConsumed;
}

void CContext_logAppUi::HandleSystemEventL  (  const TWsEvent &    aEvent  )
{
	CALLSTACKITEM(_L("CContext_logAppUi::HandleSystemEventL"));

	TApaSystemEvent event;
	event = *(TApaSystemEvent*)aEvent.EventData();

	switch ( event ) {
		case EApaSystemEventShutdown:
			LogAppEvent(_L("ext shutdown"));
			Exit();
			return;
			break;
		default:
			break;
	}
	CAknViewAppUi::HandleSystemEventL(aEvent);
	//CEikAppUi::HandleSystemEventL(aEvent);
}

void CContext_logAppUi::ProcessMessageL(TUid aUid,const TDesC8& aParams)
{
	if (aUid==KUidCloseLog) {
		Exit();
	/*} else if (aUid==KUidToBackground) {
		hide();*/
	} else {
		CAknViewAppUi::ProcessMessageL(aUid,aParams);
	}
}

void CContext_logAppUi::HandleWsEventL(const TWsEvent& aEvent, CCoeControl* aDestination)
{
	AppContext().ResetCallStack();
	CALLSTACKITEM(_L("CContext_logAppUi::HandleWsEventL"));

	TInt type=aEvent.Type();
	switch (type) {
		case EEventCaseOpened:
			case_closed=false;
			break;
		case EEventCaseClosed:
			case_closed=true;
			break;
	}
	TRAPD(err, CAknAppUi::HandleWsEventL(aEvent, aDestination));
	if (err==KErrCancel) {
		AppContext().ResetCallStack();
		return;
	}

	User::LeaveIfError(err);
}

void CContext_logAppUi::QueueOp(TCallBack Op, int AfterSeconds)
{
	CALLSTACKITEM(_L("CContext_logAppUi::QueueOp"));

	iWaitingOps->AppendL(Op);
	iWait->Wait(AfterSeconds);
}
void CContext_logAppUi::expired(CBase*)
{
	CALLSTACKITEM(_L("CContext_logAppUi::expired"));

	TCallBack op=iWaitingOps->Pop();
	((*this).*op)();
	while (iWaitingOps->iFirst && iWaitingOps->Top()==op) iWaitingOps->Pop();
	if (iWaitingOps->iFirst) {
		iWait->Wait(1);
	}
}

void CContext_logAppUi::HandleCommandL(TInt aCommand)
{
	CALLSTACKITEM(_L("CContext_logAppUi::HandleCommandL"));
	switch ( aCommand )
	{
	case EAknSoftkeyBack:
		QueueOp(&CContext_logAppUi::hide);
		break;
	case EEikCmdExit:
		{
			LogAppEvent(_L("user shutdown"));
			Exit();
			break;
		}
	case Econtext_logDetailedView:
		ActivateLocalViewL(KStatusView);
		break;

	case Econtext_logPresenceDetails:
		PresenceDetails();
		break;

	case Econtext_logCmdAppNameCell:
		{
		TTime now; now.HomeTime();

		name_cell(CAknQueryDialog::ENoTone, lc->get_value(), now);
		}
		break;
	case Econtext_logCmdAppNameContext:
		name_context();
		break;
	case Econtext_logCmdAppRecordDesc:
		record_description();
		break;
	case Econtext_logCmdAppPauseLog:
		Settings().WriteSettingL(SETTING_LOGGING_ENABLE, EFalse);
		if(iLoggingRunning) iLoggingRunning->SetCurrentState( EMbmContext_logL_not, EMbmContext_logL_not );
		break;
	case Econtext_logCmdAppUnPauseLog:
		Settings().WriteSettingL(SETTING_LOGGING_ENABLE, ETrue);
		if(iLoggingRunning) iLoggingRunning->SetCurrentState( EMbmContext_logL, EMbmContext_logL );
		break;
	case Econtext_logCmdAppGetCommLog:
		{
		if (comml->write_comm_log()) {
			_LIT(getting, "Getting comm log");
			iAppContainer->set_status(getting);
		} else {
			_LIT(no, "Nothing to do");
			iAppContainer->set_status(no);
		}
		break;
		}
	case Econtext_logCmdBTBuddies:
		if (iBTBuddiesView)
			ActivateLocalViewL(KBtDevSetViewId);
		break;
	case Econtext_logCmdBT_Dev_AP:
		if (iBTDevApView)
			ActivateLocalViewL(KBtDevApViewId);
		break;
	case Econtext_logCmdCancelSend:
		// do nothing
		break;
	case Econtext_logCmdAppTest:
		{
		//loc->test();
		//recorder->test();
		DialogTest();
		}
		break;
	case Econtext_logCmdAppCrash:
		{
		TBuf<2> buf; buf.Append(_L("xxxx"));
		}
		break;
	case Econtext_logCmdAppImsi:
		{
			if (loc) status_change(loc->GetImsi());
			else {
#ifndef __WINS__
				TPlpVariantMachineId machineId;
				PlpVariant::GetMachineIdL(machineId);
				status_change(machineId);
#else
				// Return a fake IMEI when working on emulator
				_LIT(KEmulatorImsi, "244050000000000");
				status_change(KEmulatorImsi);
#endif
			}
		}
			
		break;
	case Econtext_logCmdAppSettings:
		ActivateLocalViewL(KSettingsViewId);
		break;
	case Econtext_logCmdBaseLog:
		iLogView->SetLog( iAppContainer->BaseLog() );
		ActivateLocalViewL(KLogViewId);
		break;
	case Econtext_logCmdAppLog:
		iLogView->SetLog( iLastLog );
		ActivateLocalViewL(KLogViewId);
		break;
	case Econtext_logMyContext:
		ActivateLocalViewL(KUserViewId);
		break;
	case Econtext_logCmdGPS:
		if (iGps) iGps->SelectDevice();
		break;
	case Econtext_logCmdGPSTest:
		if (iGps) iGps->TestDevice();
		break;
	case Econtext_logCmdSettingsCancel:
	case Econtext_logCmdSettingsSave:
	case Econtext_logCmdlogviewClose:
		ActivateLocalViewL(KStatusView);
		break;
	case Econtext_logCmdAppWeb:
		{
		CWebForm* f=CWebForm::NewL(AppContext(), *iConnectionOpener, *web_log);
		f->ExecuteLD();
		}
		break;
	case Econtext_logCmdAppSuspendPresence:
		{
			LogAppEvent(_L("User suspended presence"));
			Settings().WriteSettingL(SETTING_PRESENCE_ENABLE, 0);
		}
		break;
	case Econtext_logCmdAppResumePresence:
		{
			LogAppEvent(_L("User resumed presence"));
			Settings().WriteSettingL(SETTING_PRESENCE_ENABLE, 1);
		}
		break;
	case Econtext_logCmdSnapShot:
		{
			iSnapShot->TakeSnapShot(_L("c:\\nokia\\images\\"), this);
		}
		break;
	case Econtext_logCmdPublishOld:
		{
			PublishOldMedia();
		}
		break;
	default:
		if (aCommand>Econtext_logCmdSendAppUi || aCommand==Econtext_logCmdSendFtp) {
			
			if (aCommand==Econtext_logCmdSendFtp) {
				//ftp_transfer->TransferFiles();
				//iPeriodicTransfer->Transfer(false);
				iPeriodicTransfer->Transfer(true);
			} else {
				status_change(_L("trying transfer"));

				cellid_name_file.Close();
				
				TFileName transfer_cellid_filen, cellid_filen;
				transfer_cellid_filen.Format(_L("%S%S"), &AppDir(), &transfer_cellid_file);
				cellid_filen.Format(_L("%S%S"), &DataDir(), &cellid_file);

				TInt ferr=BaflUtils::CopyFile(Fs(), cellid_filen, transfer_cellid_filen);
				if (ferr!=KErrNone) {
					TBuf<30> errmsg;
					errmsg.Format(_L("copy: %d"), ferr);
					error(errmsg);
					return;
				}
				ferr=cellid_name_file.Open(Fs(), cellid_filen, 
					EFileShareAny | EFileStreamText | EFileRead | EFileWrite);
				if (ferr!=KErrNone) {
					TBuf<30> errmsg;
					errmsg.Format(_L("reopen: %d, RESTART NOW"), ferr);
					error(errmsg);
					return;
				}
				fl->switch_file();

				transferer->transfer_files(aCommand);
			}
			
		}
		break;
	}
}

void CContext_logAppUi::finished()
{
	CALLSTACKITEM(_L("CContext_logAppUi::finished"));

	_LIT(got, "finished op");
	iAppContainer->set_status(got);
}

void CContext_logAppUi::error(const TDesC& descr)
{	
	CALLSTACKITEM(_L("CContext_logAppUi::error"));

	if (descr.Length()>0) {
		TBuf<200> msg;
		msg.Append(_L("ERROR: "));
		msg.Append(descr.Left(190));
		//globalNote->ShowNoteL(EAknGlobalInformationNote, descr	);
		LogAppEvent(msg);
		RDebug::Print(msg);
	}
	if (iAppContainer) iAppContainer->set_error(descr);
}

void CContext_logAppUi::status_change(const TDesC& status)
{
	CALLSTACKITEM(_L("CContext_logAppUi::status_change"));

	//globalNote->ShowNoteL(EAknGlobalInformationNote, status);
	if (status.Length()>0) {
		TBuf<200> msg;
		msg.Append(_L("STATUS: "));
		msg.Append(status.Left(190));
		LogAppEvent(msg);
	}
	if (iAppContainer) iAppContainer->set_status(status);
}

void CContext_logAppUi::write_to_output(const TDesC& str)
{
	CALLSTACKITEM(_L("CContext_logAppUi::write_to_output"));

	TInt pos=0, len;
	len=buf.MaxLength();
	while (pos < str.Length()) {
		TInt real_len;
		if (pos+len > str.Length()) {
			real_len=str.Length()-pos;
		} else {
			real_len=len;
		}
		CC()->ConvertFromUnicode(buf, str.Mid(pos, real_len));
		pos+=len;
		cellid_name_file.Write(buf);
	}

}

void CContext_logAppUi::read_cellid_names()
{
	CALLSTACKITEM(_L("CContext_logAppUi::read_cellid_names"));

	TBuf<128> unibuf;
	TBuf<200> cell_name, cellid;
	TInt pos=0; TChar cur; TInt len;
	bool read_id=false;

	TInt state=CCnvCharacterSetConverter::KStateDefault;
	cellid_name_file.Read(buf);
	while ( (len=buf.Length()) ) {
		CC()->ConvertToUnicode(unibuf, buf, state);
		while (pos<len) {
			while (!read_id && pos<len && (cur=unibuf[pos])!=L'\t') {
				cellid.Append(cur);
				pos++;
			}
			if (pos<len) {
				read_id=true;
				pos++; // skip tab
			}
			while (pos<len && (cur=unibuf[pos])!=L'\n') {
				cell_name.Append(cur);
				pos++;
			}
			if (pos<len) {
				pos++; //skip nl for next
				if (cellid.Length() && cell_name.Length()) 
					iAppContainer->add_cellid_name(cellid, cell_name);
				cellid.Zero();
				cell_name.Zero();
				read_id=false;
			}
		}
		buf.Zero();
		pos=0;
		cellid_name_file.Read(buf);
	}
}

void CContext_logAppUi::now_at_location(const TDesC& cellid, TInt id, bool is_base, bool loc_changed, TTime time)
{
	CALLSTACKITEM(_L("CContext_logAppUi::now_at_location"));

	if (loc) loc->now_at_location(cellid, id, is_base, loc_changed, time);

	//globalNote->ShowNoteL(EAknGlobalInformationNote, cellid);
	//if (initialising) return;
	if (!iAppContainer) return;
	iAppContainer->CurrentLoc()->now_at_location(cellid, id, is_base, loc_changed, time);
	if (id<0) return;

	TInt id_for_cell=iCellMap->GetId(cellid);
	if (is_base && ! iAppContainer->is_named(id) && ! iAppContainer->is_named(id_for_cell) ) {
		if (loc && loc->LocationgAvailable()) {
			loc->GetNameL(cellid);
		} else {
			TBool ask_for_name;
			if ( Settings().GetSettingL(SETTING_PROMPT_FOR_NAMES, ask_for_name) && !ask_for_name) return;
			// don't insert duplicates
			for (int i=0; i < name_names->Count(); i++) {
				if ( ! (*name_names)[i]->Des().Compare(cellid) ) return;
			}

			TTime now;
			now.HomeTime();
			

			name_times->AppendL(now);
			HBufC* cell;
			cell=HBufC::NewL(cellid.Length());
			*cell=cellid;
			name_names->AppendL(cell);
			caller->call();
		}
	}
}

void CContext_logAppUi::name_cells()
{	
	CALLSTACKITEM(_L("CContext_logAppUi::name_cells"));

	RWsSession& wsSession=CEikonEnv::Static()->WsSession();
	TInt id = CEikonEnv::Static()->RootWin().Identifier();
	TApaTask task(wsSession);
	task.SetWgId(id);
	TBool hide_me = EFalse;
	if ( wsSession.GetFocusWindowGroup() != id )
	{
		task.BringToForeground();
		hide_me = ETrue;
	}
	//unhide();

	current_state=NAME_CELLS;

	// cannot play tone if we want to play a ringtone
	CAknQueryDialog::TTone tone=CAknQueryDialog::ENoTone; 
	iAlerter->AlertUser();

	{
		for (int i=0; i<name_names->Count(); i++) {
			HBufC* cell=(*name_names)[i];
			name_cell(tone, cell->Des(), (*name_times)[i]);
			name_times->Delete(i);
			name_names->Delete(i);
			delete cell;
		}
		name_times->Compress();
		name_names->Compress();
	}

	if (iAlerter) iAlerter->StopAlert();

	if (hide_me) 
	{
		hide();
	}
	current_state=IDLE;

}

void CContext_logAppUi::HandleGainingForeground()
{
	CALLSTACKITEM(_L("CContext_logAppUi::HandleGainingForeground"));

	// this is used to close a connection made for
	// the web browser after the browser is closed
	// and the log comes to the foregroud - of course
	// if the user switches away from the browser
	// in some other way this doesn't work FIXME!
	if (iConnectionOpener && iConnectionOpener->MadeConnection()) {
		iConnectionOpener->CloseConnection();
	}
}

void CContext_logAppUi::HandleLosingForeground() 
{
	CALLSTACKITEM(_L("CContext_logAppUi::HandleLosingForeground"));

}

void CContext_logAppUi::name_cell(const CAknQueryDialog::TTone tone, const TDesC & cell, TTime time)
{
	if (IsDisplayingMenuOrDialog()) return;

	const TInt NAME_LENGTH=100;
	auto_ptr<HBufC> textData(HBufC::NewL(NAME_LENGTH));
	
	TBuf<50> cellid;
	cellid=cell;

	TPtr16 p=textData->Des();

	auto_ptr<HBufC> f(CEikonEnv::Static()->AllocReadResourceL(R_CL_NAME_CELL_CAPTION));
	auto_ptr<HBufC> pr(HBufC::NewL(f->Des().Length()+4));
	TDateTime dt(time.DateTime());
	pr->Des().Format(f->Des(), dt.Hour(), dt.Minute());

	CAknTextQueryDialog* dlg = new(ELeave) CAknTextQueryDialog(p, tone);
	CleanupStack::PushL(dlg);
	dlg->SetMaxLength(NAME_LENGTH);
	dlg->SetPromptL(*pr);
	CleanupStack::Pop();
	iShowingDialog=true;
	if (dlg->ExecuteLD(R_CONTEXT_LOG_NAME_INPUT) && textData->Length())
	{
		add_cellid_name(cellid, *textData);
	}
}

void CContext_logAppUi::add_cellid_name(const TDesC& cellid, const TDesC& name)
{
	CALLSTACKITEM(_L("CContext_logAppUi::add_cellid_name"));

	cell_ann->post_new_value(name);
	iAppContainer->add_cellid_name(cellid, name);
	write_to_output(cellid);
	_LIT(tab, "\t");
	write_to_output(tab);
	write_to_output(name);
	_LIT(nl, "\n");
	write_to_output(nl);
	//write_nl();
}

void CContext_logAppUi::name_context()
{
	if (IsDisplayingMenuOrDialog()) return;

	CALLSTACKITEM(_L("CContext_logAppUi::name_context"));

	const TInt CONTEXT_LENGTH=100;
	auto_ptr<HBufC> textData(HBufC::NewL(CONTEXT_LENGTH));
	TPtr16 p=textData->Des();
	CAknTextQueryDialog* dlg = new(ELeave) CAknTextQueryDialog(p, CAknQueryDialog::ENoTone);
	CleanupStack::PushL(dlg);
	dlg->SetMaxLength(CONTEXT_LENGTH);
	_LIT(pr, "Context name");
	dlg->SetPromptL(pr);
	CleanupStack::Pop();
	if (dlg->ExecuteLD(R_CONTEXT_LOG_NAME_INPUT))
	{
		context_ann->post_new_value(textData->Des());
	}
}

void CContext_logAppUi::record_description()
{
	CALLSTACKITEM(_L("CContext_logAppUi::record_description"));

}

name_cell_callback::name_cell_callback(CContext_logAppUi* i_ui) : 
	CCheckedActive(EPriorityIdle, _L("name_cell_callback")), ui(i_ui) { }

void name_cell_callback::ConstructL()
{
	CALLSTACKITEM(_L("name_cell_callback::ConstructL"));

	timer.CreateLocal();
	CActiveScheduler::Add(this); // add to scheduler
}

void name_cell_callback::call()
{
	CALLSTACKITEM(_L("name_cell_callback::call"));

	if (is_active) return;
	TTimeIntervalMicroSeconds32 w(1*1000*1000);
	timer.After(iStatus, w);
	is_active=true;
	SetActive();
}

void name_cell_callback::CheckedRunL()
{
	CALLSTACKITEM(_L("name_cell_callback::CheckedRunL"));

	if (ui) {
		ui->name_cells();
	}
	is_active=false;
}

void name_cell_callback::DoCancel()
{
	CALLSTACKITEM(_L("name_cell_callback::DoCancel"));

	timer.Cancel();
}

name_cell_callback::~name_cell_callback()
{
	CALLSTACKITEM(_L("name_cell_callback::~name_cell_callback"));

	Cancel();
	timer.Close();
}

class CLogEventTest : public CActive {
public:
	static CLogEventTest* NewL(RFs& Fs) {
		auto_ptr<CLogEventTest> ret(new (ELeave) CLogEventTest);
		ret->ConstructL(Fs);
		return ret.release();
	}
	CLogEventTest() : CActive(EPriorityNormal) { }
	void ConstructL(RFs& Fs) {
		lc=CLogClient::NewL(Fs);
		le=CLogEvent::NewL();
		le->SetEventType(KLogCallEventTypeUid);
		le->SetContact(1);
		le->SetDirection(_L("Missed call"));
		le->SetDuration(1);
		le->SetDurationType(KLogDurationValid);
		le->SetNumber(_L("0505536758"));
		TTime now; now.HomeTime();

		le->SetTime(now);
		le->SetRemoteParty(_L("mika"));
		CActiveScheduler::Add(this);
		lc->AddEvent(*le, iStatus);
		SetActive();
	}
	void RunL() {
		delete this;
	}
	void DoCancel() { }
	~CLogEventTest() {
		Cancel();
		delete lc;
		delete le;
	}
private:
	CLogClient*	lc;
	CLogEvent*	le;
};

void CContext_logAppUi::PresenceDetails()
{
	iPresenceDetailView->SetData(*iCaptionMyContext, iPresencePublisher);

	ActivateLocalViewL(KPresenceDetailView);

	return;
}

void CContext_logAppUi::DialogTest()
{
	/*
	_LIT(KS, "Liittymn 0407679267 sijainti: HELSINKI, Esplanadi, N60:10'06\", E24:56'57\" (ast:min'sek\" WGS84:ss)");
	TMsvId dummy(1);
	i_handle_received_sms* s=loc;
	s->handle_reception(dummy, dummy, _L("15400"), KS);
	return;
	_LIT(KS, "Liittymn 0407679267 sijainti: HELSINKI, Esplanadi, N60:10'06\", E24:56'57\" (ast:min'sek\" WGS84:ss)");
	TMsvId dummy(1);
	i_handle_received_sms* s=lsms;
	s->handle_sending(dummy, _L("0505536758"), KS);
	return;
	*/

	/*
	TMsvId dummy(1);
	iSmsSnapshot->handle_reception(dummy, dummy, _L("0505536758"), _L("WINS"));
	return;
	*/

	/*
	CALLSTACKITEM(_L("CContext_logAppUi::DialogTest"));
	iSmsSnapshot->Test();
	return;
	*/

	/*CLogEventTest* t=CLogEventTest::NewL(Fs());
	
	return;*/

	/*
	TBuf<100> err;
	TInt ret=iMMS->SendMessage(_L("0505536758"), _L("body of msg"), _L("c:\\http.txt"), err, false);
	if (ret!=KErrNone) Error(ret, err);
	else status_change(_L("message sent"));
	return; */

	/**/

	//TBuf<2> buf; buf.Append(_L("xxxx"));

	if (iTestFileOpen) {
		iTestFile.Close();
		iTestFileOpen=false;
	} else {
		
		
		TFileName filen=_L("C:\\nokia\\images\\img");
		TInt i=2; filen.AppendNum(i); filen.Append(_L(".jpg"));
		while (BaflUtils::FileExists(Fs(), filen)) {
			filen=_L("C:\\nokia\\images\\img");
			++i; filen.AppendNum(i); filen.Append(_L(".jpg"));
		}
		{
			TFileName from=_L("C:\\nokia\\images\\img.jpg");
			BaflUtils::CopyFile(Fs(), from, filen);
		}
		{
			TFileName from2=_L("C:\\nokia\\images\\old\\img.jpg");
			BaflUtils::CopyFile(Fs(), from2, filen);
		}
		/*
		if (iTestFile.Open(Fs(), filen, EFileWrite)==KErrNone) {
			iTestFileOpen=true;
		}
		*/
	}
	return;

	/*
	if (IsDisplayingMenuOrDialog()) return;

	CALLSTACKITEM(_L("CContext_logAppUi::DialogTest"));

	CCoeEnv *env = CEikonEnv::Static();
	RPbkViewResourceFile pbkRes( *env);
	pbkRes.OpenL();
	CleanupClosePushL(pbkRes);

	CPbkContactEngine *ipPabEng=CPbkContactEngine::NewL();
	CleanupStack::PushL(ipPabEng);

	CPbkContactItem* aContactItem = ipPabEng->ReadContactL( 1 );
	CleanupStack::PushL(aContactItem);

	// launch the contacts dialog
	CPbkContactEditorDlg *ipPabDlg =
	CPbkContactEditorDlg::NewL(*ipPabEng, *aContactItem, EFalse);

	ipPabDlg->SetMopParent( this );

	TInt res = KErrNone;
	TRAPD( err, res = ipPabDlg->ExecuteLD());

	
	//CPbkSelectFieldDlg *d=new (ELeave) CPbkSelectFieldDlg;
	//TPbkContactItemField* res=d->ExecuteLD(aContactItem->CardFields(), R_AVKON_SOFTKEYS_OPTIONS_BACK);
	

	CleanupStack::PopAndDestroy(3); //engine, pbkRes, aContactItem
	*/
}

void CContext_logAppUi::start_app(TUid app, TInt view)
{
	CALLSTACKITEM(_L("CContext_logAppUi::start_app"));

	if (view==0) {
		RAApaLsSession ls; ls.ConnectLA();
		TThreadId tid;

		User::LeaveIfError( ls.StartDocument(_L(""), app, tid) );

	} else {
		CCoeAppUi::ActivateViewL(TVwsViewId(app, TUid::Uid(view)));
	}
}

void CContext_logAppUi::NotifyNewPresence(const MPresenceData* d)
{
	CALLSTACKITEM(_L("CContext_logAppUi::NotifyNewPresence"));


	TTime now; now.HomeTime();

	PresenceToListBoxL(d, iUserContext,
		iCaptionMyContext, 0, prev, not_avail);

	iUserContextLog->AddL(*iUserContext);
}

void CContext_logAppUi::SettingChanged(TInt Setting)
{
	if (Setting==SETTING_LOGGING_ENABLE) {
		TApaTaskList tl(Ws());
		TApaTask booktask=tl.FindApp(KUidcontextbook);
		if (booktask.Exists()) {
			booktask.SendSystemEvent(EApaSystemEventShutdown);
		}
	}
}

void CContext_logAppUi::Error(TInt aCode, const TDesC& aDescription)
{
	TBuf<100> msg=aDescription;
	msg.Append(_L(": "));
	msg.AppendNum(aCode);
	error(msg);
}

void CContext_logAppUi::Taken(const TDesC& aFileName)
{
	if (0) {
		TBuf<100> err;
		TInt ret=iMMS->SendMessage(_L("0415601669"), _L("SnapShot!"), aFileName, err, false);
		if (ret!=KErrNone) Error(ret, err);
		else status_change(_L("message sent"));
	} else {
		TBuf<200> msg=_L("pic taken ");
		msg.Append(aFileName);
		status_change(msg);
	}
}

void CContext_logAppUi::Info(const TDesC& aMsg)
{
	status_change(aMsg);
}

// End of File  
