/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


/*
* ============================================================================
*  Name     : CSettingsView from SettingsView.h
*  Part of  : Settings
*  Created  : 13.1.2004 by 
*  Implementation notes:
*     Initial content was generated by Series 60 AppWizard.
*  Version  :
*  Copyright: 
* ============================================================================
*/

// INCLUDE FILES
#include  <aknviewappui.h>
#include  <avkon.hrh>
#include  <context_log.rsg>
#include  "SettingsView.h"
#include <aknsettingitemlist.h> 
#include <cdbcols.h>
#include <commdb.h>
#include "symbian_auto_ptr.h"
#include "cl_settings.h"
#include "context_log.hrh"

CCLSettingList::~CCLSettingList()
{
	for (int i=0; i<SETTINGS_COUNT; i++) {
		if (! iData[i]) continue;
		const TSettingItem s=TClSettings::KClSettings[i];
		switch (s.iDatatype) {
		case EAP:
		case EInt:
		case EBool:
		case EEnum:
			delete (TInt*)iData[i];
			break;
		case EString:
			delete (TBuf<50>*)iData[i];
			break;
		}
	}
}

CAknSettingItem* CCLSettingList::CreateSettingItemL( TInt identifier )
{
	CALLSTACKITEM(_L("CCLSettingList::CreateSettingItemL"));

	CAknSettingItem* settingItem = NULL;
	const TSettingItem i=TClSettings::KClSettings[identifier];
	switch (i.iDatatype) {
	case EAP:
		{
		TInt *p=new (ELeave) TInt;
		*p=1;
		if (i.iDefaultExists) *p=i.iIntDefault;
		iData[identifier]=p;
		settingItem = iItems[identifier] = new (ELeave) 
			CAknEnumeratedTextPopupSettingItem(identifier, *p );
		break;
		}
	case EString:
		{
		TBuf<50>* p=new (ELeave) TBuf<50>;
		iData[identifier]=p;
		if (i.iDefaultExists && i.iStringDefault) *p=TPtrC((TText*)i.iStringDefault);
		settingItem = iItems[identifier] = new (ELeave) 
			CAknTextSettingItem(identifier, *p);
		break;
		}
	case EBool:
	case EEnum:
		{
		TInt *p=new (ELeave) TInt;
		*p=1;
		if (i.iDefaultExists) *p=i.iIntDefault;
		iData[identifier]=p;
		settingItem = iItems[identifier] = new (ELeave) 
			CAknEnumeratedTextPopupSettingItem(identifier, *p );
		break;
		}
	case EInt:
		{
		TInt *p=new (ELeave) TInt;
		*p=0;
		if (i.iDefaultExists) *p=i.iIntDefault;
		iData[identifier]=p;
		settingItem = iItems[identifier] = new (ELeave) 
			CAknIntegerEdwinSettingItem(identifier, *p );
		break;
		}
	default:
		break;
	}

	if (!settingItem) {
		User::Leave(-1027);
	}
	return settingItem;
}

void CCLSettingList::SetListData()
{
	CALLSTACKITEM(_L("CCLSettingList::SetListData"));

	for (int i=0; i< SETTINGS_COUNT; i++) {
		if ( ! iItems[i] ) continue;
		TSettingItem s=TClSettings::KClSettings[i];
		switch(s.iDatatype) {
		case EAP:
			{
			CAknEnumeratedTextPopupSettingItem *list=(CAknEnumeratedTextPopupSettingItem *)iItems[i];
			TInt *list_id=(TInt*)iData[i];
			auto_ptr<CCommsDatabase> db(CCommsDatabase::NewL(EDatabaseTypeIAP));
			CCommsDbTableView* iViewP=db->OpenTableLC(TPtrC(IAP));
			CleanupStack::Pop();
			auto_ptr<CCommsDbTableView> iView(iViewP);

			auto_ptr<CArrayPtr< CAknEnumeratedText > > enumarr(
				new (ELeave) CArrayPtrFlat< CAknEnumeratedText >(4));
			auto_ptr<CArrayPtr< HBufC > > popuparr( 
				new (ELeave) CArrayPtrFlat< HBufC >(4));

			TInt err;
			TUint32 id=-1;
			{
				TBuf<16> KNoAp=_L("No connection");
				auto_ptr<HBufC> text(KNoAp.AllocL());
				auto_ptr<HBufC> popup(KNoAp.AllocL());
				auto_ptr<CAknEnumeratedText> item(new (ELeave) CAknEnumeratedText(-1, text.get()));
				text.release();
				enumarr->AppendL(item.get());
				item.release();
				popuparr->AppendL(popup.get());
				popup.release();
			}
			bool seen=false;
			while( (err=iView->GotoNextRecord()) == KErrNone ) {
				iView->ReadUintL(TPtrC(COMMDB_ID), id);
				if ( (TInt)id==*list_id) { seen=true; }
				auto_ptr<HBufC> text(HBufC::NewL(KCommsDbSvrMaxColumnNameLength));
				TPtr ptr(text->Des());
				iView->ReadTextL(TPtrC(COMMDB_NAME), ptr);
				auto_ptr<HBufC> popup(text->AllocL());
				auto_ptr<CAknEnumeratedText> item(new (ELeave) CAknEnumeratedText(TInt(id), text.get()));
				text.release();
				enumarr->AppendL(item.get());
				item.release();
				popuparr->AppendL(popup.get());
				popup.release();
			}
			if (!seen) *list_id=-1;

			//FIXME: what if no records?
			list->SetEnumeratedTextArrays(enumarr.release(), popuparr.release());
			list->HandleTextArrayUpdateL();
			list->UpdateListBoxTextL ();
			}
		default:
			break;
		}
	}
}

void CCLSettingList::UpdateSettings()
{
	CALLSTACKITEM(_L("CCLSettingList::UpdateSettings"));

	for (int i=0; i< SETTINGS_COUNT; i++) {
		if ( ! iItems[i] ) continue;
		CAknSettingItem* list= iItems[i];
		list->LoadL();
		list->UpdateListBoxTextL();
	}
}

// ================= MEMBER FUNCTIONS =======================

CSettingsView* CSettingsView::NewL(MApp_context& Context)
{
	CALLSTACKITEMSTATIC(_L("CSettingsView::NewL"));

	auto_ptr<CSettingsView> ret(new (ELeave) CSettingsView(Context));
	ret->ConstructL();
	return ret.release();
}

CSettingsView::CSettingsView(MApp_context& Context) : MContextBase(Context)
{
	CALLSTACKITEM(_L("CSettingsView::CSettingsView"));

}

// ---------------------------------------------------------
// CSettingsView::ConstructL(const TRect& aRect)
// EPOC two-phased constructor
// ---------------------------------------------------------
//
void CSettingsView::ConstructL()
{
	CALLSTACKITEM(_L("CSettingsView::ConstructL"));

	BaseConstructL( R_SETTINGS_VIEW );
}


// ---------------------------------------------------------
// CSettingsView::~CSettingsView()
// ?implementation_description
// ---------------------------------------------------------
//
CSettingsView::~CSettingsView()
{
	CALLSTACKITEM(_L("CSettingsView::~CSettingsView"));

	if ( iListBox )
        {
		AppUi()->RemoveFromViewStack( *this, iListBox );
        }
	
	delete iListBox;
}

// ---------------------------------------------------------
// TUid CSettingsView::Id()
// ?implementation_description
// ---------------------------------------------------------
//
TUid CSettingsView::Id() const
{
	CALLSTACKITEM(_L("CSettingsView::Id"));

	return KSettingsViewId;
}

// ---------------------------------------------------------
// CSettingsView::HandleCommandL(TInt aCommand)
// ?implementation_description
// ---------------------------------------------------------
//
void CSettingsView::HandleCommandL(TInt aCommand)
{   
	CALLSTACKITEM(_L("CSettingsView::HandleCommandL"));

	switch ( aCommand )
        {
        case EAknSoftkeyOk:
	case Econtext_logCmdSettingsSave:
		{
			iListBox->StoreSettingsL();
			TBuf<50> prev_string; TInt prev_int;
			for (int i=0; i<SETTINGS_COUNT; i++) {
				if (! iListBox->iData[i]) continue;
				TSettingItem s=TClSettings::KClSettings[i];
				switch (s.iDatatype) {
				case EAP:
				case EInt:
				case EBool:
				case EEnum:
				{
					TInt *v=(TInt*)(iListBox->iData[i]);
					if (!Settings().GetSettingL(i, prev_int) || prev_int!=*v)
						Settings().WriteSettingL(i, *v);
				}
				break;
				case EString:
				{
					TBuf<50> *v=(TBuf<50>*)(iListBox->iData[i]);
					if (!Settings().GetSettingL(i, prev_string) || prev_string.Compare(*v))
						Settings().WriteSettingL(i, *v);
				}
				break;
				}
			}
		}
		AppUi()->HandleCommandL( Econtext_logCmdSettingsSave );
		break;
        default:
		AppUi()->HandleCommandL( Econtext_logCmdSettingsCancel );
		break;
        }
}

// ---------------------------------------------------------
// CSettingsView::HandleClientRectChange()
// ---------------------------------------------------------
//
void CSettingsView::HandleClientRectChange()
{
	CALLSTACKITEM(_L("CSettingsView::HandleClientRectChange"));

	if ( iListBox )
        {
		iListBox->SetRect( ClientRect() );
        }
}

// ---------------------------------------------------------
// CSettingsView::DoActivateL(...)
// ?implementation_description
// ---------------------------------------------------------
//
void CSettingsView::DoActivateL(
				const TVwsViewId& /*aPrevViewId*/,TUid /*aCustomMessageId*/,
				const TDesC8& /*aCustomMessage*/)
{
	CALLSTACKITEM(_L("CSettingsView::DoActivateL"));

	if (!iListBox)
        {
		iListBox = new (ELeave) CCLSettingList;
		iListBox->SetMopParent(this);
		iListBox->ConstructFromResourceL(R_CL_SETTINGS_LIST);

		TBuf<50> prev_string; TInt prev_int;
		for (int i=0; i<SETTINGS_COUNT; i++) {
			if (! iListBox->iData[i]) continue;
			TSettingItem s=TClSettings::KClSettings[i];
			switch (s.iDatatype) {
			case EAP:
			case EInt:
			case EBool:
			case EEnum:
			{
				TInt *v=(TInt*)(iListBox->iData[i]);
				if (Settings().GetSettingL(i, prev_int)) *v=prev_int;
			}
			break;
			case EString:
			{
				TBuf<50> *v=(TBuf<50>*)(iListBox->iData[i]);
				if (Settings().GetSettingL(i, prev_string)) *v=prev_string;
			}
			break;
			}
		}

		iListBox->SetListData();
		iListBox->UpdateSettings();

		AppUi()->AddToStackL( *this, iListBox );
		iListBox->MakeVisible(ETrue);
		iListBox->SetRect(ClientRect());
		iListBox->ActivateL();
		iListBox->DrawNow();
		
        } 
}

// ---------------------------------------------------------
// CSettingsView::HandleCommandL(TInt aCommand)
// ?implementation_description
// ---------------------------------------------------------
//
void CSettingsView::DoDeactivate()
{
	CALLSTACKITEM(_L("CSettingsView::DoDeactivate"));

	if ( iListBox )
        {
		AppUi()->RemoveFromViewStack( *this, iListBox );
        }
	
	delete iListBox;
	iListBox = NULL;
}

// End of File

