/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#include "call_recorder.h"
#include "file_output_base.h"
#include "cl_settings.h"

CCall_record::CCall_record(MApp_context& Context) : Ccall_listener(Context), can_record(false), recorder(0)
{
	CALLSTACKITEM(_L("CCall_record::CCall_record"));

}

CCall_record::~CCall_record()
{	
	CALLSTACKITEM(_L("CCall_record::~CCall_record"));
	Settings().CancelNotifyOnChange(SETTING_RECORD_ALL, this);
	delete recorder;
}

void CCall_record::SettingChanged(TInt Setting)
{
	TInt all;
	if (Settings().GetSettingL(SETTING_RECORD_ALL, all) && all) record_all=true;
}

void CCall_record::ConstructL(i_status_notif* i_cb, TDirection dir)
{
	CALLSTACKITEM(_L("CCall_record::ConstructL"));

	Ccall_listener::ConstructL(i_cb, dir);
	
	recorder=CMda_recorder::NewL(AppContext(), this, 1, 8000, 30);

	iSpecialGroups->AddGroupL(_L("Record"));
	iSpecialGroups->read_contact_groups();	

	record_all=false;
	TInt all;
	if (Settings().GetSettingL(SETTING_RECORD_ALL, all) && all) record_all=true;
	Settings().NotifyOnChange(SETTING_RECORD_ALL, this);
	opened();
}

CCall_record* CCall_record::NewL(MApp_context& Context, i_status_notif* i_cb, TDirection dir)
{
	CALLSTACKITEMSTATIC(_L("CCall_record::NewL"));

	auto_ptr<CCall_record> ret(new (ELeave) CCall_record(Context));
	ret->ConstructL(i_cb, dir);
	return ret.release();
}

void CCall_record::test()
{
	CALLSTACKITEM(_L("CCall_record::test"));

	cb->status_change(_L("recording call"));
	TFileName filen;
	Mfile_output_base::make_filename(filen, DataDir(), _L("rec"), _L("amr"));
	recorder->record(filen);
}

void CCall_record::handle_answered()
{
	CALLSTACKITEM(_L("CCall_record::handle_answered"));

	if (!can_record || NoSpaceLeft() || !recorder->IsIdle()) {
		cb->error(_L("Cannot record"));
		return;
	}

	if ( record_all || iSpecialGroups->is_special_contact() ) {
		cb->status_change(_L("recording call"));
		TFileName filen;
		Mfile_output_base::make_filename(filen, DataDir(), _L("rec"), _L("amr"));
		recorder->record(filen);
		can_record=false;
	}
}

void CCall_record::stopped(bool reset)
{
	CALLSTACKITEM(_L("CCall_record::stopped"));

	can_record=true;

	if (reset) {
		cb->error(_L("record failed"));
		return;
	}
	cb->status_change(_L("recorded"));
}

void CCall_record::opened()
{
	CALLSTACKITEM(_L("CCall_record::opened"));

	can_record=true;
}

void CCall_record::error(const TDesC& descr)
{
	CALLSTACKITEM(_L("CCall_record::error"));

	cb->error(descr);
}