/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#include "circular.h"
#include "symbian_auto_ptr.h"

#include "app_context.h"

CCircularLog* CCircularLog::NewL(int Size, bool Reverse)
{
	CALLSTACKITEM(_L("CCircularLog::NewL"));

	auto_ptr<CCircularLog> ret(new (ELeave) CCircularLog(Reverse));
	ret->ConstructL(Size);
	return ret.release();
}

void CCircularLog::DeleteLast()
{
	if (iLast==-1) return; //empty
	
	if (iLast == iFirst) {
		iLast=-1; iFirst=0;
		return;
	}

	--iLast;
	if (iLast<0) iLast+=iSize;
}

void CCircularLog::AddL(const TDesC& String)
{
	CALLSTACKITEM(_L("CCircularLog::AddL"));

	++iLast;
	if (iFirst!=0 && iLast==iFirst) iFirst=iLast+1;

	if (iLast>=iSize) {
		iLast=0;
		iFirst=1;
	}
	if (iArray->MdcaCount()==iSize) {
		iArray->Delete(iLast);
	}
	iArray->InsertL(iLast, String);

	RDebug::Print(_L("Log at %d %S"), iLast, &String);
}

CCircularLog::~CCircularLog()
{
	CALLSTACKITEM(_L("CCircularLog::~CCircularLog"));

	delete iArray;
}

CCircularLog::CCircularLog(bool Reverse) : iLast(-1)
{
	CALLSTACKITEM(_L("CCircularLog::CCircularLog"));

	iReverse=Reverse;
}

void CCircularLog::ConstructL(int Size)
{
	CALLSTACKITEM(_L("CCircularLog::ConstructL"));

	iArray=new (ELeave) CDesCArrayFlat(Size);
	iSize=Size;
}

TInt CCircularLog::MdcaCount() const
{
	CALLSTACKITEM(_L("CCircularLog::MdcaCount"));

	if (iLast==-1) return 0;

	if (iLast>=iFirst) return iLast-iFirst+1;
	else return iLast-iFirst+iSize+1;
}

TPtrC16 CCircularLog::MdcaPoint(TInt aIndex) const
{
	CALLSTACKITEM(_L("CCircularLog::MdcaPoint"));

	int idx;
	if (!iReverse) {
		idx=(iFirst+aIndex) % iSize;
	} else {
		idx=iLast-aIndex;
		if (idx<0) idx+=iSize;
	}
	return iArray->MdcaPoint(idx);
}

void CCircularLog::SetObserver(MListObserver* Observer)
{
	CALLSTACKITEM(_L("CCircularLog::SetObserver"));

	iObserver=Observer;
}