#include "cl_settings.h"

#include "local_defaults.h"

const TSettingItem TClSettings::KClSettings[] = {
	{ 0, EEmpty, 0, -1, EFalse },	// no setting 0
	{ SETTING_WAP_AP, EAP, 0, -1, EFalse }, // not in use
	{ SETTING_PHONENO, EString, 0, -1, EFalse },	// not in use
	{ SETTING_IP_AP, EAP, 0, -1, EFalse },	 
	{ SETTING_LAST_COMMLOG_UPLOAD, ETime, 0, 0, ETrue },	 
	{ SETTING_CELLMAP_CLOSED, EBool, 0, 1, ETrue },	 
	{ SETTING_BASEDB_VERSION, EInt, 0, 4, ETrue },	 
	{ SETTING_JABBER_NICK, EString, 0, -1, EFalse },	 
	{ SETTING_JABBER_PASS, EString, 0, -1, EFalse },	 
	{ SETTING_PRESENCE_ENABLE, EBool, 0, DEFAULT_PRESENCE_ENABLE, ETrue },
	/*10*/ 
	{ SETTING_LAST_BASE_STAMP, ETime, 0, -1, EFalse },
	{ SETTING_PICTURE_ENABLE, EBool, 0, DEFAULT_PICTURE_ENABLE, ETrue },
	{ SETTING_UPLOAD_URLBASE, EString, DEFAULT_UPLOAD_URLBASE, -1, ETrue },
	{ SETTING_PREV_BASE, EString, 0, -1, EFalse },
	{ SETTING_PREV_BASE_STAMP, ETime, 0, -1, EFalse },
	{ SETTING_UPLOAD_TAG, EString, 0, -1, EFalse },
	{ SETTING_OPTIONS_ENABLE, EBool, 0, DEFAULT_OPTIONS_ENABLE, ETrue },
	{ SETTING_DELETE_UPLOADED, EBool, 0, DEFAULT_DELETE_UPLOADED, ETrue },
	{ SETTING_LOGGING_ENABLE, EBool, 0, DEFAULT_LOGGING_ENABLE, ETrue },
	{ SETTING_LOCATIONSERVICE_ENABLE, EBool, 0, DEFAULT_LOCATIONSERVICE_ENABLE, ETrue },
	/*20*/ 
	{ SETTING_BT_SCAN_INTERVAL, EInt, 0, DEFAULT_BT_SCAN_INTERVAL, ETrue },
	{ SETTING_RECORD_ALL, EBool, 0, DEFAULT_RECORD_ALL, ETrue },
	{ SETTING_LOG_UPLOAD_ENABLE, EBool, 0, DEFAULT_LOG_UPLOAD_ENABLE, ETrue },
	{ SETTING_TAG_ONLY, EBool, 0, DEFAULT_TAG_ONLY, ETrue },
	{ SETTING_PROMPT_FOR_NAMES, EBool, 0, DEFAULT_PROMPT_FOR_NAMES, ETrue },
	{ SETTING_UPLOAD_PROMPT_TYPE, EEnum, 0, DEFAULT_UPLOAD_PROMPT_TYPE, ETrue },
	{ SETTING_PUBLISH_URLBASE, EString, DEFAULT_UPLOAD_URLBASE, -1, ETrue },
	{ SETTING_VIBRATE_ONLY, EBool, 0, ETrue, ETrue },
	{ SETTING_GPS_BT_ADDR, EString8, 0, -1, EFalse },
	{ SETTING_GPS_LOG_TIME, EInt, 0, 15, ETrue },
	/*30*/
	{ SETTING_GPS_BT_PORT, EInt, 0, -1, EFalse },
	{ SETTING_PUBLISH_AUTHOR, EString, 0, -1, EFalse },
	{ SETTING_SNAPSHOT_ON_SMS, EBool, 0, DEFAULT_SNAPSHOT_ON_SMS, ETrue },
	{ SETTING_PUBLISH_SCRIPT, EString, DEFAULT_UPLOAD_SCRIPT, -1, ETrue },
	{ SETTING_UPLOAD_SCRIPT, EString, DEFAULT_UPLOAD_SCRIPT, -1, ETrue },
	{ SETTING_IGNORE_NOTIFICATIONS, EBool, 0, EFalse, ETrue},
	{ SETTING_BT_AP, EAP, 0, -1, EFalse},
	{ SETTING_BT_DEV_ADDR, EString8, 0, -1, EFalse},
	{ SETTING_BT_DEV_NAME, EString, 0, -1, EFalse},
	{ SETTING_CURRENT_AP, EAP, 0, -1, EFalse},
	/*40*/
	{ SETTING_USE_MMC, EBool, 0, DEFAULT_USE_MMC, ETrue },
	{ SETTING_RECORD_TIME, EInt, 0, 30, ETrue },
#ifdef DEFAULT_PROXY
	{ SETTING_PROXY, EString, DEFAULT_PROXY, -1, ETrue },
#else
	{ SETTING_PROXY, EString, 0, -1, EFalse },
#endif
#ifdef DEFAULT_PROXY_PORT
	{ SETTING_PROXY_PORT, EInt, 0, DEFAULT_PROXY_PORT, ETrue },
#else
	{ SETTING_PROXY_PORT, EInt, 0, -1, EFalse },
#endif
};

bool TClSettings::GetDefaultL(TInt Setting, TDes& Value) const
{
	const TSettingItem i=KClSettings[Setting];
	if (i.iSettingNo!=Setting) User::Leave(-1025);

	if (i.iStringDefault) {
		Value=TPtrC((TText*)i.iStringDefault);
	} else {
		Value.Zero();
	}
	return i.iDefaultExists;
}

bool TClSettings::GetDefaultL(TInt Setting, TDes8& Value) const
{
	const TSettingItem i=KClSettings[Setting];
	if (i.iSettingNo!=Setting) User::Leave(-1025);

	if (i.iStringDefault) {
		Value=TPtrC8((TText8*)i.iStringDefault);
	} else {
		Value.Zero();
	}
	return i.iDefaultExists;
}

bool TClSettings::GetDefaultL(TInt Setting, TInt& Value) const
{
	const TSettingItem i=KClSettings[Setting];
	if (i.iSettingNo!=Setting) User::Leave(-1025);

	Value=i.iIntDefault;
	return i.iDefaultExists;
}

bool TClSettings::GetDefaultL(TInt Setting, TTime& Value) const
{
	const TSettingItem i=KClSettings[Setting];
	if (i.iSettingNo!=Setting) User::Leave(-1025);

	Value=i.iIntDefault;
	return i.iDefaultExists;
}
