#include "current_loc.h"
#include "basestack.h"
#include "cl_settings.h"

//void GetTime(TTime& t);

class CCurrentLocImpl : public CCurrentLoc {
	CCurrentLocImpl(MApp_context& Context, CGenericIntMap* acellid_names);
	~CCurrentLocImpl();

        void ConstructL();

	void now_at_location(const TDesC& cellid, TInt id, bool is_base, bool loc_changed, TTime time);
	CCircularLog*	BaseLog();

	void AddToLog(const CBaseStack::TBaseItem& b);
	void ReplaceLastLog(const CBaseStack::TBaseItem& b);
	void ReconstructLog();
	void EmptyLog();
	TInt CurrentBaseId(); // returns -1 if not at base

	const TDesC& get_value();

	CBaseStack::TBaseItem	iBase[2];
	CBaseStack*	iBaseStack;
	CCircularLog*	iBaseLog;
	bool	iFirstLoc; bool iIsBase;
	CGenericIntMap* cellid_names;

	friend class auto_ptr<CCurrentLocImpl>;
	friend class CCurrentLoc;
};

CCurrentLoc* CCurrentLoc::NewL(MApp_context& Context, CGenericIntMap* acellid_names)
{
	CALLSTACKITEM2(_L("CCurrentLoc::NewL"), &Context);

	auto_ptr<CCurrentLocImpl> ret(new (ELeave) CCurrentLocImpl(Context, acellid_names));
	ret->ConstructL();
	return ret.release();
}

CCurrentLoc::~CCurrentLoc()
{

}

CCurrentLoc::CCurrentLoc(MApp_context& Context) : Mlog_base_impl(Context)
{

}

CCurrentLocImpl::CCurrentLocImpl(MApp_context& Context, CGenericIntMap* acellid_names) : 
	CCurrentLoc(Context), cellid_names(acellid_names)
{
}

CCurrentLocImpl::~CCurrentLocImpl()
{
	CALLSTACKITEM(_L("CCurrentLocImpl::~CCurrentLocImpl"));

	delete iBaseStack;
	delete iBaseLog;
}

void CCurrentLocImpl::ConstructL()
{
	CALLSTACKITEM(_L("CCurrentLocImpl::ConstructL"));

	Mlog_base_impl::ConstructL(KLog_cellname, _L("%S"));

	iBaseStack=CBaseStack::NewL(AppContext());
	iBaseLog=CCircularLog::NewL(20, true);
	ReconstructLog();

	if (iBaseStack->LastL(iBase[0])) {
		iBaseStack->PrevL(iBase[1]);
	}

	iFirstLoc=true;
}

void CCurrentLocImpl::now_at_location(const TDesC& /*cellid*/, TInt id, bool is_base, bool loc_changed, TTime time) 
{
	CALLSTACKITEM(_L("CCurrentLocImpl::now_at_location"));

	//
	// FIXME: this is a hack for
	// the no coverage case, so that the code doesn't crash
	//
	if (id==-1) return;

	TBuf<60> tmp;
	if (iFirstLoc) {
		iFirstLoc=false;
		/*
		 * get the stored last base and post
		 *
		 */
		int previ=1;
		if (iBase[0].iLeft!=TTime(0)) {
			previ=0;
		} else {
			iIsBase=true;
		}
		tmp=_L("last: ");
		tmp.Append(iBase[previ].iBaseName);
		post_new_value(tmp, iBase[previ].iLeft);

		TTime iBaseStamp, now;
		GetTime(now);
		now-=TTimeIntervalMinutes(15);
		Settings().GetSettingL(SETTING_LAST_BASE_STAMP, iBaseStamp);

		if (iBase[0].iBaseId==-1 && is_base) {
			// no previous data
			HBufC* user_given_name=0;
			user_given_name=(HBufC*)cellid_names->GetData(id);
			if (user_given_name) {
				iBase[0]=CBaseStack::TBaseItem(id, *user_given_name, time);
			} else {
				iBase[0]=CBaseStack::TBaseItem(id, _L(""), time);
			}
			iBaseStack->PushBackL(iBase[0]);
			post_new_value(iBase[0].iBaseName, iBase[0].iEntered);
			AddToLog(iBase[0]);
			iIsBase=is_base;
			Settings().WriteSettingL(SETTING_LAST_BASE_STAMP, time);
			return;
		} else if (id!=-1 && id==iBase[0].iBaseId && now < iBaseStamp && (iBase[0].iLeft==TTime(0) || now < iBase[0].iLeft)) {
			if (now < iBase[0].iLeft) {
				iIsBase=true;
				tmp=_L("last: ");
				tmp.Append(iBase[1].iBaseName);
				post_new_value(tmp, iBase[1].iLeft);
			}
			iBase[0].iLeft=0; iBaseStack->SetLastLeft(TTime(0));
			post_new_value(iBase[0].iBaseName, iBase[0].iEntered);
			ReplaceLastLog(iBase[0]);
			iIsBase=is_base;
			Settings().WriteSettingL(SETTING_LAST_BASE_STAMP, time);
			return;
		} else if (id!=iBase[0].iBaseId && now >= iBaseStamp && iBase[0].iLeft==TTime(0)) {
			// moved out of the base while not running
			// cannot now the right time, let's use last observation
			iBase[0].iLeft=iBaseStamp; iBaseStack->SetLastLeft(iBaseStamp);
			ReplaceLastLog(iBase[0]);
			tmp=_L("last: ");
			tmp.Append(iBase[0].iBaseName);
			post_new_value(tmp, iBase[0].iLeft);
		}
	}

	Settings().WriteSettingL(SETTING_LAST_BASE_STAMP, time);

	if (loc_changed) {
		// did we stay long enough to count in current base
		bool last_changed=false;
		if (iBase[0].iLeft==TTime(0)) {
			if (iBase[0].iEntered+TTimeIntervalMinutes(7) > time) {
				// didn't stay
				iBaseStack->DeleteLastL();
				if (iBaseLog) iBaseLog->DeleteLast();
				if (iBaseStack->LastL(iBase[0]))
					iBaseStack->PrevL(iBase[1]);
			} else {
				iBase[0].iLeft=time;
				iBaseStack->SetLastLeft(time);
				ReplaceLastLog(iBase[0]);
			}
			last_changed=true;
		}

		// did we come back to previous
		TTime comp=time; comp-=TTimeIntervalMinutes(15);
		int previ=1;
		if (iBase[0].iLeft!=TTime(0)) previ=0;
		bool came_back=false;
		if (is_base && iBase[previ].iBaseId==id && comp < iBase[previ].iLeft) {
			came_back=true;
			// came back to previous quickly
			if (previ==0) {
				iBase[0].iLeft=0;
				iBaseStack->SetLastLeft(TTime(0));
			} else {
				iBaseStack->DeleteLastL();
				if (iBaseStack->LastL(iBase[0]))
					iBaseStack->PrevL(iBase[1]);
				if (iBaseLog) iBaseLog->DeleteLast();
			}
			tmp=_L("last: ");
			tmp.Append(iBase[1].iBaseName);
			post_new_value(tmp, iBase[1].iLeft);
			ReplaceLastLog(iBase[0]);
		} else if (last_changed) {
			tmp=_L("last: ");
			tmp.Append(iBase[0].iBaseName);
			post_new_value(tmp, iBase[0].iLeft);
		}

		// what base are we in now
		if (is_base && !came_back) {
			iBase[1]=iBase[0];
			HBufC* user_given_name=0;
			user_given_name=(HBufC*)cellid_names->GetData(id);
			if (user_given_name) {
				iBase[0]=CBaseStack::TBaseItem(id, *user_given_name, time);
			} else {
				iBase[0]=CBaseStack::TBaseItem(id, _L(""), time);
			}
			iBaseStack->PushBackL(iBase[0]);
			AddToLog(iBase[0]);
		}

		// prune stack
		while (iBaseStack->CountL()>20) {
			iBaseStack->DeleteFirstL();
		}
	} else {
		if (iIsBase!=is_base) {
			// noticed this cell is a base
			iBase[1]=iBase[0];
			HBufC* user_given_name=0;
			user_given_name=(HBufC*)cellid_names->GetData(id);
			if (user_given_name) {
				iBase[0]=CBaseStack::TBaseItem(id, *user_given_name, time);
			} else {
				iBase[0]=CBaseStack::TBaseItem(id, _L(""), time);
			}
			iBaseStack->PushBackL(iBase[0]);
			AddToLog(iBase[0]);
		} else {

			// skip if not changed location and no new name
			HBufC* user_given_name=0;
			user_given_name=(HBufC*)cellid_names->GetData(iBase[0].iBaseId);
			if (user_given_name==0) return;
			if (! ((*user_given_name).Left(50).Compare(iBase[0].iBaseName)) ) return;
			iBase[0].iBaseName=user_given_name->Left(50);
			iBaseStack->SetLastName(*user_given_name);
			ReplaceLastLog(iBase[0]);
		}
	}
	iIsBase=is_base;

	// always post value, so that naming works
	if (iBase[0].iLeft==TTime(0)) {
		post_new_value(iBase[0].iBaseName, iBase[0].iEntered);
	}
}

CCircularLog*	CCurrentLocImpl::BaseLog()
{
	CALLSTACKITEM(_L("CCurrentLocImpl::BaseLog"));

	return iBaseLog;
}

void CCurrentLocImpl::ReplaceLastLog(const CBaseStack::TBaseItem& b)
{
	CALLSTACKITEM(_L("CCurrentLocImpl::ReplaceLastLog"));

	if (!iBaseLog) return;

	iBaseLog->DeleteLast();
	AddToLog(b);
}

void CCurrentLocImpl::AddToLog(const CBaseStack::TBaseItem& b)
{
	CALLSTACKITEM(_L("CCurrentLocImpl::AddToLog"));

	if (!iBaseLog) return;

	TBuf<80> s;
	TDateTime ent=b.iEntered.DateTime();
	TDateTime left=b.iLeft.DateTime();
	if (b.iLeft!=TTime(0)) {
		s.Format(_L("%S %02d/%02d %02d:%02d - %02d/%02d %02d:%02d"), &(b.iBaseName), 
			(TInt)ent.Day()+1, (TInt)ent.Month()+1, (TInt)ent.Hour(), (TInt)ent.Minute(),
			(TInt)left.Day()+1, (TInt)left.Month()+1, (TInt)left.Hour(), (TInt)left.Minute());
	} else {
		s.Format(_L("%S %02d/%02d %02d:%02d -"), &(b.iBaseName),
			(TInt)ent.Day()+1, (TInt)ent.Month()+1, (TInt)ent.Hour(), (TInt)ent.Minute());
	}
	iBaseLog->AddL(s);
}

void CCurrentLocImpl::ReconstructLog()
{
	CALLSTACKITEM(_L("CCurrentLocImpl::ReconstructLog"));

	if (!iBaseLog) return;

	CBaseStack::TBaseItem b;
	if (iBaseStack->FirstL(b)) {
		AddToLog(b);
		while (iBaseStack->NextL(b)) {
			AddToLog(b);
		}
	}
}

const TDesC& CCurrentLocImpl::get_value()
{
	CALLSTACKITEM(_L("CCurrentLocImpl::get_value"));

	return KNullDesC;
}

void CCurrentLocImpl::EmptyLog()
{
	CALLSTACKITEM(_L("CCurrentLocImpl::EmptyLog"));

	iBase[1]=iBase[0]=CBaseStack::TBaseItem();
	while (iBaseStack->CountL()>20) {
		iBaseStack->DeleteFirstL();
	}
	iFirstLoc=true;
}

TInt CCurrentLocImpl::CurrentBaseId() // returns -1 if not at base
{
	CALLSTACKITEM(_L("CCurrentLocImpl::CurrentBaseId"));

	if (iBase[0].iLeft==TTime(0)) return -1;
	return iBase[0].iBaseId;
}
