/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#include "doublelinebox.h"

#include <eikfrlbd.h> 

#include "app_context.h"

drawer::drawer(MTextListBoxModel *aTextListBoxModel, const CFont *aFont, CFormattedCellListBoxData *aFormattedCellData) :
		CFormattedCellListBoxItemDrawer(aTextListBoxModel, aFont, aFormattedCellData)
		{
			itemd=aFormattedCellData;
			iTextListBoxModel=aTextListBoxModel;
			
		}


void drawer::DrawItemText (TInt aItemIndex, const TRect &aItemTextRect, 
		TBool aItemIsCurrent, TBool aViewIsEmphasized, TBool aItemIsSelected) const 
{
	CALLSTACKITEM(_L("drawer::DrawItemText"));

		//if ( (iTextListBoxModel->ItemText(aItemIndex) == TPtrC(0,0)) )
		//{
			CFormattedCellListBoxItemDrawer::DrawItemText(aItemIndex, aItemTextRect,
			aItemIsCurrent, aViewIsEmphasized, aItemIsSelected);
		//}
	}
	
doublelinebox::doublelinebox() : CEikFormattedCellListBox()
{
	CALLSTACKITEM(_L("doublelinebox::doublelinebox"));
}


void doublelinebox::CreateItemDrawerL(void)
{
	CALLSTACKITEM(_L("doublelinebox::CreateItemDrawerL"));

	auto_ptr<CFormattedCellListBoxData> itemd(CFormattedCellListBoxData::NewL());

	/*TMargins marg;
	TMargins marg_image;
	marg.iBottom=marg.iTop=marg_image.iBottom=marg_image.iTop=marg_image.iLeft=marg_image.iRight=0;
	marg.iLeft= 2;
	marg.iRight=0;

	//Name of contact
	itemd->SetSubCellMarginsL(0, marg);		
	itemd->SetSubCellSizeL(0, TSize(116, 20) );
	itemd->SetSubCellPositionL(0, TPoint(18, 0) );
	itemd->SetSubCellBaselinePosL(0, 16);
	itemd->SetSubCellFontL(0, iEikonEnv->DenseFont() );
	itemd->SetSubCellAlignmentL(0, CGraphicsContext::ELeft);
	
	//Textual PresenceInfo
	itemd->SetSubCellMarginsL(1, marg);
	itemd->SetSubCellSizeL(1, TSize(178, 20) );
	itemd->SetSubCellPositionL(1, TPoint(0, 20) );
	itemd->SetSubCellBaselinePosL(1, 32);
	itemd->SetSubCellFontL(1, iEikonEnv->DenseFont() );
	itemd->SetSubCellAlignmentL(1, CGraphicsContext::ELeft);

	// Contact Icon (type of number)
	itemd->SetSubCellMarginsL(2, marg_image);
	itemd->SetSubCellSizeL(2, TSize(18, 20) );
	itemd->SetSubCellPositionL(2, TPoint(0, 0) );
	itemd->SetSubCellBaselinePosL(2, 16);
	itemd->SetSubCellFontL(2, iEikonEnv->DenseFont() );
	itemd->SetGraphicsSubCellL(2,ETrue);
	itemd->SetSubCellAlignmentL(2, CGraphicsContext::ECenter);

	// Ringing volume
	itemd->SetSubCellMarginsL(3, marg_image);
	itemd->SetSubCellSizeL(3, TSize(18, 20) );
	itemd->SetSubCellPositionL(3, TPoint(134, 0) );
	itemd->SetSubCellBaselinePosL(3, 16);
	itemd->SetSubCellFontL(3, iEikonEnv->DenseFont() );
	itemd->SetSubCellAlignmentL(3, CGraphicsContext::ECenter);
	itemd->SetGraphicsSubCellL(3,ETrue);

	// Vibrator
	itemd->SetSubCellMarginsL(4, marg_image);
	itemd->SetSubCellSizeL(4, TSize(28, 20) );
	itemd->SetSubCellPositionL(4, TPoint(150, 0) );
	itemd->SetSubCellBaselinePosL(4, 16);
	itemd->SetSubCellFontL(4, iEikonEnv->DenseFont() );
	itemd->SetSubCellAlignmentL(4, CGraphicsContext::ECenter);
	itemd->SetGraphicsSubCellL(4,ETrue);
	*/

	TMargins marg, marg2;
	marg.iBottom=marg.iTop=marg.iLeft=marg.iRight=0;
	marg2.iBottom=marg2.iTop=marg2.iRight=0;
	marg2.iLeft=2;

	//Name of contact
	itemd->SetSubCellMarginsL(0, marg);		
	//itemd->SetSubCellSizeL(0, TSize(118, 18) );
	itemd->SetSubCellSizeL(0, TSize(132,19));//name of contact
	itemd->SetSubCellPositionL(0, TPoint(16, 0) );
	itemd->SetSubCellBaselinePosL(0, 14);
	itemd->SetSubCellFontL(0, iEikonEnv->DenseFont() );
	itemd->SetSubCellAlignmentL(0, CGraphicsContext::ELeft);
	
	//Textual PresenceInfo
	itemd->SetSubCellMarginsL(1, marg2);
	//itemd->SetSubCellSizeL(1, TSize(166, 19) );
	itemd->SetSubCellSizeL(1, TSize(136, 19) ); // location
	itemd->SetSubCellPositionL(1, TPoint(0, 19) );
	itemd->SetSubCellBaselinePosL(1, 32);
	itemd->SetSubCellFontL(1, iEikonEnv->DenseFont() );
	itemd->SetSubCellAlignmentL(1, CGraphicsContext::ELeft);

	// Contact Icon (type of number)
	itemd->SetSubCellMarginsL(2, marg);
	itemd->SetSubCellSizeL(2, TSize(16, 19) );
	itemd->SetSubCellPositionL(2, TPoint(0, 0) );
	itemd->SetSubCellBaselinePosL(2, 17);
	itemd->SetSubCellFontL(2, iEikonEnv->DenseFont() );
	itemd->SetGraphicsSubCellL(2,ETrue);
	itemd->SetSubCellAlignmentL(2, CGraphicsContext::ECenter);

	// Ringing volume
	itemd->SetSubCellMarginsL(3, marg);
	itemd->SetSubCellSizeL(3, TSize(16, 19) );
	itemd->SetSubCellPositionL(3, TPoint(142, 0) );
	itemd->SetSubCellBaselinePosL(3, 17);
	itemd->SetSubCellFontL(3, iEikonEnv->DenseFont() );
	itemd->SetSubCellAlignmentL(3, CGraphicsContext::ECenter);
	itemd->SetGraphicsSubCellL(3,ETrue);

	// Vibrator
	itemd->SetSubCellMarginsL(4, marg);
	itemd->SetSubCellSizeL(4, TSize(16, 19) );
	itemd->SetSubCellPositionL(4, TPoint(158, 0) );
	itemd->SetSubCellBaselinePosL(4, 17);
	itemd->SetSubCellFontL(4, iEikonEnv->DenseFont() );
	itemd->SetSubCellAlignmentL(4, CGraphicsContext::ECenter);
	itemd->SetGraphicsSubCellL(4,ETrue);

	// BT buddies
	itemd->SetSubCellMarginsL(5, marg);
	itemd->SetSubCellSizeL(5, TSize(20, 19) );
	itemd->SetSubCellPositionL(5, TPoint(134, 19) );
	itemd->SetSubCellBaselinePosL(5, 32);
	itemd->SetSubCellFontL(5, iEikonEnv->DenseFont() );
	itemd->SetSubCellAlignmentL(5, CGraphicsContext::ECenter);
	itemd->SetGraphicsSubCellL(5,ETrue);

	// other phones
	itemd->SetSubCellMarginsL(6, marg);
	itemd->SetSubCellSizeL(6, TSize(20, 19) );
	itemd->SetSubCellPositionL(6, TPoint(154, 19) );
	itemd->SetSubCellBaselinePosL(6, 32);
	itemd->SetSubCellFontL(6, iEikonEnv->DenseFont() );
	itemd->SetSubCellAlignmentL(6, CGraphicsContext::ECenter);
	itemd->SetGraphicsSubCellL(6,ETrue);

	//Marked or not
	itemd->SetSubCellMarginsL(7, marg);
	itemd->SetSubCellSizeL(7, TSize(0, 19) );
	itemd->SetSubCellPositionL(7, TPoint(174, 0) );
	itemd->SetSubCellBaselinePosL(7, 17);
	itemd->SetSubCellFontL(7, iEikonEnv->DenseFont() );
	itemd->SetSubCellAlignmentL(7, CGraphicsContext::ECenter);
	itemd->SetGraphicsSubCellL(7,ETrue);

	iItemDrawer=new (ELeave) drawer(Model(), iEikonEnv->NormalFont(), itemd.get());
	itemd.release();
}

doublelinebox::~doublelinebox()
{
	CALLSTACKITEM(_L("doublelinebox::~doublelinebox"));

}

