/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#include "keycapture.h"
#include "independent.h"
#include <apgtask.h> // Going background 
#include <bautils.h>
#include <w32std.h>
#include "screen.h"
#include <viewcli.h> //CVwsSessionWrapper
#include <apgwgnam.h>

#include <symbian_auto_ptr.h>
#include <raii_w32std.h>
#include <raii_e32std.h>
#include <raii_f32file.h>

enum JOYSTICK_EVENTS {
	JOY_LEFT = 0xF807,
	JOY_RIGHT = 0xF808,
	JOY_UP = 0xF809,
	JOY_DOWN = 0xF80A,
	JOY_CLICK = EKeyDevice3
};

#include <context_uids.h>
const TUid KUidPhone = { 0x100058b3 };
const TUid KUidMenu = {  0x101f4cd2 };

#ifndef __WINS__
_LIT(contextbook_filen, "c:\\system\\apps\\contextbook\\contextbook.app");
_LIT(contextcontacts_filen, "c:\\system\\apps\\contextcontacts\\contextcontacts.app");
_LIT(contextcalllog_filen, "c:\\system\\apps\\contextcalllog\\contextcalllog.app");
#else
_LIT(contextcontacts_filen, "z:\\system\\apps\\contextcontacts\\contextcontacts.app");
_LIT(contextbook_filen, "z:\\system\\apps\\contextbook\\contextbook.app");
_LIT(contextcalllog_filen, "z:\\system\\apps\\contextcalllog\\contextcalllog.app");
#endif

void do_start_keycapture(TAny* aPtr)
{
	RAWsSession ws; ws.ConnectLA();

	worker_info *wi=(worker_info*)aPtr;
	TKeycaptureArgs *args=(TKeycaptureArgs*)wi->worker_args;

	TRequestStatus status;
	
	RAWindowGroup wg(ws); wg.ConstructLA((TUint32)&wg, EFalse);

	/*
	 * This will mess the key repeat for these keys.
	 * Could be fixed by writing our own key repeat
	 * timer (or on S60v2 by using CaptureLongKey).
	 */

	User::LeaveIfError(wg.CaptureKey(EKeyLeftArrow, 0, 0));
	User::LeaveIfError(wg.CaptureKey(EKeyRightArrow, 0, 0));
	User::LeaveIfError(wg.CaptureKey(JOY_CLICK, 0, 0));
	User::LeaveIfError(wg.CaptureKey(EKeyUpArrow, 0, 0));
	User::LeaveIfError(wg.CaptureKey(EKeyDownArrow, 0, 0)); 
	User::LeaveIfError(wg.CaptureKey(EKeyYes, 0, 0));
	User::LeaveIfError(wg.CaptureKey(EKeyNo, 0, 0));

/*
	User::LeaveIfError(wg.CaptureKeyUpAndDowns(JOY_LEFT, 0, 0));
	User::LeaveIfError(wg.CaptureKeyUpAndDowns(JOY_RIGHT, 0, 0));
	User::LeaveIfError(wg.CaptureKeyUpAndDowns(JOY_CLICK, 0, 0));
	User::LeaveIfError(wg.CaptureKeyUpAndDowns(JOY_UP, 0, 0));
	User::LeaveIfError(wg.CaptureKeyUpAndDowns(JOY_DOWN, 0, 0));
	User::LeaveIfError(wg.CaptureKeyUpAndDowns(EKeyYes, 0, 0));
	User::LeaveIfError(wg.CaptureKeyUpAndDowns(EKeyNo, 0, 0));
*/

	bool book_exists=false;
	bool log_exists=false;
	TVwsViewId callid, recentid;

	{
		RAFs fsSession; fsSession.ConnectLA();

		// ContextBook activation
		if (BaflUtils::FileExists(fsSession, contextbook_filen)) {
			callid=TVwsViewId(KUidcontextbook, TUid::Uid(1));
			recentid=TVwsViewId(KUidcontextbook, TUid::Uid(2));
			book_exists=true;
		} 
		// ContextCallLog activation
		if (BaflUtils::FileExists(fsSession, contextcalllog_filen)) {
			recentid = TVwsViewId(KUidContextCallLog, TUid::Uid(8));
			log_exists=true;
		} 
		// ContextContact activation
		if (BaflUtils::FileExists(fsSession, contextcontacts_filen)) {
			callid=TVwsViewId(KUidContextContacts, TUid::Uid(1));
			book_exists=true;
		}
	}

	auto_ptr<screen> screenhelp(new (ELeave) screen);
	screenhelp->ConstructL(&ws);

	auto_ptr<CVwsSessionWrapper> vws(CVwsSessionWrapper::NewL());

	ws.EventReady(&status);

	wg.SetOrdinalPosition(-1);
	wg.EnableReceiptOfFocus(EFalse);
	auto_ptr<CApaWindowGroupName> wn(CApaWindowGroupName::NewL(ws));
	wn->SetHidden(ETrue);
	wn->SetWindowGroupName(wg);

	//TRequestStatus parent_thread_status;
	RAThread parent; parent.OpenLA(wi->parent_threadid);
	/*
		We'd like to actually react to parent thread death
		and try to log it, put once the main thread of a process
		is killed all other threads are too, that means this thread :-)
	*/

	for(;;) {
		User::WaitForAnyRequest();
		
		if ( (*wi->do_stop)!=KRequestPending) {
			break;
		}
		if (status.Int()==KErrNone) {
			TWsEvent e;
			ws.GetEvent(e);

			if (*(args->iKeyStatus)==KRequestPending) {
				TRequestStatus *sp=args->iKeyStatus;
				parent.RequestComplete(sp, KErrNone);
			}
			TInt wgid=ws.GetFocusWindowGroup();

			TInt c;
			TKeyEvent* aKeyEvent=e.Key();
			c=aKeyEvent->iCode;
            
			auto_ptr<CApaWindowGroupName> gn(CApaWindowGroupName::NewL(ws, wgid));

			// There's no Phone app on the emulator, so
			// we test it with Menu; on the phone the joystick
			// is used for the menu so we cannot use it
#ifndef __WINS__
			if (gn->AppUid()==KUidPhone && 
				! screenhelp->dialog_on_screen() /*&& book_exists*/) {
#else
			if (gn->AppUid()==KUidMenu && 
				! screenhelp->dialog_on_screen() /*&& book_exists*/) {
#endif
				switch(c) {
				case JOY_CLICK:
					if (callid!=TVwsViewId())
						vws->ActivateView(callid,TUid::Null(),KNullDesC8);
					else
						ws.SendEventToWindowGroup(wgid, e);
					break;
				case EKeyYes:
					if (recentid!=TVwsViewId())
						vws->ActivateView(recentid,TUid::Null(),KNullDesC8);
					else
						ws.SendEventToWindowGroup(wgid, e);
					break;
				//case JOY_RIGHT:
				default:
					ws.SendEventToWindowGroup(wgid, e);
					break;
				}
			} else {
				// otherwise send event to foreground app
				ws.SendEventToWindowGroup(wgid, e);
				

			}
			//ws->EventReady(&status);
			ws.EventReady(&status);

		}
		if ( (*wi->do_stop)!=KRequestPending) {
			break;
		}
	}
	//ws->EventReadyCancel();
	ws.EventReadyCancel();
}

TInt start_keycapture(TAny* aPtr)
{

        CTrapCleanup *cl;
        cl=CTrapCleanup::New();

        TInt err=0;
        TRAP(err,
                do_start_keycapture(aPtr));

	delete cl;

	TTimeIntervalMicroSeconds32 w(50*1000);
	User::After(w);
	worker_info* wi=(worker_info*)aPtr;
	wi->stopped();
        return err;
}
