/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#include "log_base_impl.h"

#include <e32std.h>
#include <eikenv.h>

void Mlog_base_impl::ConstructL(const TDesC& name, const TDesC& format)
{
	CALLSTACKITEM(_L("Mlog_base_impl::ConstructL"));

	log_name=name.AllocL();
	log_format=format.AllocL();
	loggers=new (ELeave) CArrayFixFlat<Mlogger*>(1);
}

Mlog_base_impl::Mlog_base_impl(MApp_context& Context) : MContextBase(Context),
	log_name(0), log_format(0), loggers(0)
{
	CALLSTACKITEM(_L("Mlog_base_impl::Mlog_base_impl"));

}

void Mlog_base_impl::release_sinks()
{
	CALLSTACKITEM(_L("Mlog_base_impl::release_sinks"));

	if (!loggers) return;
	TTime time;
	time.HomeTime();



	for (int i=0; i<loggers->Count(); i++) {
		(*loggers)[i]->unregister_source(get_name(), time);
	}
	loggers->Reset();
}

Mlog_base_impl::~Mlog_base_impl()
{
	CALLSTACKITEM(_L("Mlog_base_impl::~Mlog_base_impl"));

	release_sinks();

	delete log_name;
	delete log_format;
	delete loggers;
}

void Mlog_base_impl::add_sinkL(Mlogger* sink)
{
	CALLSTACKITEM(_L("Mlog_base_impl::add_sinkL"));

	TTime time;
	time.HomeTime();


	add_sinkL(sink, time);
}

void Mlog_base_impl::add_sinkL(Mlogger* sink, const TTime& time)
{
	CALLSTACKITEM(_L("Mlog_base_impl::add_sinkL"));

	if (!sink) return;
	loggers->AppendL(sink);
	sink->register_source(log_name->Des(), get_value(), time);
}

const TDesC& Mlog_base_impl::get_name()
{
	CALLSTACKITEM(_L("Mlog_base_impl::get_name"));

	return *log_name;
}

const TDesC& Mlog_base_impl::get_value()
{
	CALLSTACKITEM(_L("Mlog_base_impl::get_value"));

	return *log_format;
}

void Mlog_base_impl::post_new_value(const TDesC& value, Mlogger::log_priority priority)
{
	CALLSTACKITEM(_L("Mlog_base_impl::post_new_value"));

	TTime time;
	time.HomeTime();

	post_new_value(value, time, priority);
}

void Mlog_base_impl::post_new_value(const TDesC& value, const TTime& time, Mlogger::log_priority priority)
{
	CALLSTACKITEM(_L("Mlog_base_impl::post_new_value"));

	for (int i=0; i<loggers->Count(); i++) {
		Mlogger* l=(*loggers)[i];
		if (l) {
			l->new_value(priority, get_name(), value, time);
		}
	}
}

Clog_base_impl::Clog_base_impl(MApp_context& Context) : Mlog_base_impl(Context)
{
	CALLSTACKITEM(_L("Clog_base_impl::Clog_base_impl"));

}


Clog_base_impl* Clog_base_impl::NewL(MApp_context& Context, const TDesC& name, const TDesC& format)
{
	CALLSTACKITEM2(_L("Clog_base_impl::NewL"), &Context);

	auto_ptr<Clog_base_impl> ret(new (ELeave) Clog_base_impl(Context));
	ret->ConstructL(name, format);
	return ret.release();
}
