/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#include "log_idle.h"
#include "symbian_auto_ptr.h"

CLog_idle::~CLog_idle()
{
	CALLSTACKITEM(_L("Clog_comm::~CLog_idle"));

	Cancel();
	iTimer.Close();
	delete iValue;
}

const TDesC& CLog_idle::get_value()
{
	CALLSTACKITEM(_L("CLog_idle::get_value"));

	return *iValue;
}

void CLog_idle::CheckedRunL()
{
	CALLSTACKITEM(_L("CLog_idle::CheckedRunL"));

	if (iStatus!=KErrNone) {
		if (User::InactivityTime().Int()>iTimeOut) {
			iCurrentState=EActive;
		} else {
			iCurrentState=EIdle;
		}
	}

	if (iCurrentState==EIdle) {
		*iValue=_L("active");
		iCurrentState=EActive;
		iTimer.Inactivity(iStatus, iTimeOut);
	} else {
		*iValue=_L("idle");
		iCurrentState=EIdle;
		iTimer.Inactivity(iStatus, 0);
	}
	post_new_value(*iValue);
	SetActive();
}

CLog_idle* CLog_idle::NewL(MApp_context& Context)
{
	CALLSTACKITEMSTATIC(_L("CLog_idle::NewL"));

	auto_ptr<CLog_idle> ret(new (ELeave) CLog_idle(Context));
	ret->ConstructL();
	return ret.release();
}

void CLog_idle::DoCancel()
{
	CALLSTACKITEM(_L("CLog_idle::DoCancel"));

	iTimer.Cancel();
}

void CLog_idle::GetState()
{
	CALLSTACKITEM(_L("CLog_idle::GetState"));

	if (User::InactivityTime().Int()>iTimeOut) {
		iCurrentState=EIdle;
		*iValue=_L("idle");
	} else {
		iCurrentState=EActive;
		*iValue=_L("active");
	}
}

void CLog_idle::Start()
{
	CALLSTACKITEM(_L("CLog_idle::Start"));

	GetState();
	if (iCurrentState==EIdle) {
		iTimer.Inactivity(iStatus, 0);
	} else {
		iTimer.Inactivity(iStatus, iTimeOut);
	}
	SetActive();
}

TInt CLog_idle::CheckedRunError(TInt /*aError*/)
{
	CALLSTACKITEM(_L("CLog_idle::CheckedRunError"));

	Start();
	return KErrNone;
}

CLog_idle::CLog_idle(MApp_context& Context) : CCheckedActive(EPriorityHigh, _L("CLog_idle")), Mlog_base_impl(Context), iTimeOut(60)
{
	CALLSTACKITEM(_L("CLog_idle::CLog_idle"));

}

void CLog_idle::ConstructL()
{
	CALLSTACKITEM(_L("CLog_idle::ConstructL"));

	iValue=HBufC::NewL(8);
	Mlog_base_impl::ConstructL(KLog_activity, _L("%S"));
	GetState();
	iTimer.CreateLocal();
	CActiveScheduler::Add(this);
	Start();
}
