/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#include "log_local.h"
#include "symbian_auto_ptr.h"

#define IDLE_TIME	60

CLog_local* CLog_local::NewL(MApp_context& Context, const TDesC& name)
{
	CALLSTACKITEMSTATIC(_L("CLog_local::NewL"));

	auto_ptr<CLog_local> ret(new (ELeave) CLog_local(Context));
	ret->ConstructL(name);
	return ret.release();
}

CLog_local::~CLog_local()
{
	CALLSTACKITEM(_L("CLog_local::~CLog_local"));

	Cancel();
	delete iTimer;
}

TRequestStatus* CLog_local::RequestStatus()
{
	CALLSTACKITEM(_L("CLog_local::RequestStatus"));

	return &iStatus;
}

CLog_local::CLog_local(MApp_context& Context) : CCheckedActive(EPriorityNormal, _L("CLog_local")), Mlog_base_impl(Context)
{
	CALLSTACKITEM(_L("CLog_local::CLog_local"));

}

void CLog_local::ConstructL(const TDesC& name)
{
	CALLSTACKITEM(_L("CLog_local::ConstructL"));

	Mlog_base_impl::ConstructL(name, _L("active"));
	CActiveScheduler::Add(this); // add to scheduler
	iStatus=KRequestPending;
	SetActive();
	iTimer=CTimeOut::NewL(*this);
	iTimer->Wait(IDLE_TIME);
}

void CLog_local::DoCancel()
{
	CALLSTACKITEM(_L("CLog_local::DoCancel"));

	TRequestStatus *sp=&iStatus;
	User::RequestComplete(sp, KErrNone);
}

void CLog_local::CheckedRunL()
{
	CALLSTACKITEM(_L("CLog_local::CheckedRunL"));

	if (! iTimer->IsActive() ) {
		post_new_value(_L("active"));
	}
	//RDebug::Print(_L("user active"));
	iStatus=KRequestPending;
	iTimer->Wait(IDLE_TIME);
	SetActive();
}

TInt CLog_local::CheckedRunError(TInt /*aError*/)
{
	CALLSTACKITEM(_L("CLog_local::CheckedRunError"));

	return KErrNone;
}

void CLog_local::expired(CBase*)
{
	CALLSTACKITEM(_L("CLog_local::expired"));

	post_new_value(_L("idle"));
}
