/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#include "log_profile.h"
#include "symbian_auto_ptr.h"
#include <e32std.h>
#define INTERVAL 30

#ifndef NO_PROFILEAPI_H
#include <profileapi.h>
#else
typedef TInt32 TContactItemId;
class CProfileAPI : public CBase {
public:
	enum TProErrorCode
	    {
	    EPro0=0
	   ,EPro1
	    };
	IMPORT_C static CProfileAPI* NewL(TBool);
	IMPORT_C virtual ~CProfileAPI();
	IMPORT_C TProErrorCode GetProfileActiveName(TPtr, TInt*);
	IMPORT_C TProErrorCode GetProfileMultiData( TDes&, TDes&, TInt&,
					       TInt&, TBool&, TInt&, CArrayFixFlat<TContactItemId>*,
					       TInt&, TInt);
};
#endif


Clog_profile::Clog_profile(MApp_context& Context) : CCheckedActive(CCheckedActive::EPriorityIdle, _L("Clog_profile")), Mlog_base_impl(Context)
{
	CALLSTACKITEM(_L("Clog_profile::Clog_profile"));

}

void Clog_profile::ConstructL()
{
	CALLSTACKITEM(_L("Clog_profile::ConstructL"));

	profile_value=HBufC::NewL(40);
	name=HBufC::NewL(50);
	Mlog_base_impl::ConstructL(KLog_profile, _L("%d %S (%d %d %S)"));

	aConditions=new (ELeave) CArrayFixFlat<TSysAgentCondition>(sizeof(TSysAgentCondition));
	aConditions->SetReserveL(1);
	
	CActiveScheduler::Add(this);
	listen_for_notification();
}

void Clog_profile::listen_for_notification()
{
	CALLSTACKITEM(_L("Clog_profile::listen_for_notification"));

	Cancel();

	if (! iAgentIsOpen ) {
		TInt ret=iSysAgent.Connect();
		if (ret!=KErrNone) {
			iWait->Wait(5);
			return;
		} else {
			iAgentIsOpen=true;
		}
	}

	prev_profile=get_profile_via_profilapi();
	TSysAgentCondition cond(KUidProfile, prev_profile, ESysAgentNotEquals);
	if (aConditions->Count()==0) {
		aConditions->AppendL(cond);
	} else {
		aConditions->At(0)=cond;
	}

	TInt ret=iSysAgent.NotifyOnCondition(*aConditions, iStatus);
	if (ret==KErrNone) {
		SetActive();
	} else {
		iStatus=ret;
		iWait->Wait(5);
	}
}

void Clog_profile::expired(CBase* )
{
	CALLSTACKITEM(_L("Clog_profile::expired"));

	CheckedRunL();
}

Clog_profile* Clog_profile::NewL(MApp_context& Context)
{
	CALLSTACKITEMSTATIC(_L("Clog_profile::NewL"));

	auto_ptr<Clog_profile> ret(new (ELeave) Clog_profile(Context));
	ret->ConstructL();
	return ret.release();
}

void Clog_profile::DoCancel()
{
	CALLSTACKITEM(_L("Clog_profile::DoCancel"));

	iSysAgent.NotifyEventCancel();
}

Clog_profile::~Clog_profile()
{
	CALLSTACKITEM(_L("Clog_profile::~Clog_profile"));

	delete iWait;
	Cancel();

	if (iAgentIsOpen) iSysAgent.Close();

	delete name;
	delete profile_value;
	delete aConditions;

}

TInt Clog_profile::CheckedRunError(TInt /*aError*/)
{
	CALLSTACKITEM(_L("Clog_profile::CheckedRunError"));

	if (iErrorCount>10) {
		return -1010;
	}

	Cancel();
	listen_for_notification();
	return KErrNone;
}

void Clog_profile::CheckedRunL()
{
	CALLSTACKITEM(_L("Clog_profile::CheckedRunL"));

	if (iStatus!=KErrNone) {
		if (iErrorCount>10) {
			User::Leave(-1010);
		}
		iErrorCount++;
		if (iAgentIsOpen) {
			iSysAgent.Close();
			iAgentIsOpen=true;
		}
	} else {
		iErrorCount=0;
	}

	iProfileUid=get_profile_via_profilapi();

	if (prev_profile==iProfileUid) {
		listen_for_notification();
		return;
	}

	prev_profile=iProfileUid;

	TPtrC namep=name->Des();
	profile_value->Des().Format(*log_format, iProfileUid, &(namep), iRingingType, iRingingVolume, &iVibraDescr);
	post_new_value(profile_value->Des());

	listen_for_notification();
}

const TDesC& Clog_profile::get_value()
{
	CALLSTACKITEM(_L("Clog_profile::get_value"));

	TPtrC namep=name->Des();
	profile_value->Des().Format(*log_format, prev_profile, &(namep), iRingingType, iRingingVolume,
		&iVibraDescr);
	return *profile_value;
}

TInt Clog_profile::get_profile_via_profilapi()
{
	CALLSTACKITEM(_L("Clog_profile::get_profile_via_profilapi"));

	TInt profileUid=0;
#ifndef __WINS__

	auto_ptr<CProfileAPI> profile(CProfileAPI::NewL(EFalse));
	if (profile->GetProfileActiveName(name->Des(), &profileUid)!= 0)
		return -1; // Get active profile

	if (profileUid<0 || profileUid>10) return -1;

	TFileName dummy1, dummy2;
	TInt dummy3, dummy4;
	auto_ptr<CArrayFixFlat<TContactItemId> > dummy6(new (ELeave) CArrayFixFlat<TContactItemId>(1));
	profile->GetProfileMultiData(dummy1, dummy2, iRingingType, iRingingVolume, iVibra, dummy3, dummy6.get(),
		dummy4, -1);
#else
	iVibra=true;
	iRingingType=3;
	iRingingVolume=2;
	*name=_L("Genrl");

#endif
	if (iVibra) {
		iVibraDescr=_L("On");
	} else {
		iVibraDescr=_L("Off");
	}
	return profileUid;
}