/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#include "recorder.h"

Mrecorder::Mrecorder(): buf(0), bufdes(0, 0), istream(0)
{
	CALLSTACKITEM(_L("Mrecorder::Mrecorder"));

}

void Mrecorder::MaiscOpenComplete(TInt aError)
{
	CALLSTACKITEM(_L("Mrecorder::MaiscOpenComplete"));

        if (aError != KErrNone)	{
                _LIT(f, "open err %d");
		msg.Format(f, aError);
		error(msg);
	} else {
		opened();
	}
}

void Mrecorder::MaiscBufferCopied(TInt aError, const TDesC8& /*aBuffer*/)
{
	CALLSTACKITEM(_L("Mrecorder::MaiscBufferCopied"));

        if (aError != KErrNone)	{
                _LIT(f, "buffer err %d");
		msg.Format(f, aError);
		error(msg);
		stopped(true);
	} else {
	}
}

void Mrecorder::MaiscRecordComplete(TInt aError)
{
	CALLSTACKITEM(_L("Mrecorder::MaiscRecordComplete"));

        if (aError != KErrNone)	{
                _LIT(f, "record err %d");
		msg.Format(f, aError);
		error(msg);
		stopped(true);
	} else {
		stopped();
	}
}

void Mrecorder::record()
{
	CALLSTACKITEM(_L("Mrecorder::record"));

	bufdes.Zero();
	//bufdes.SetMax();
	istream->SetGain(istream->MaxGain());
	istream->ReadL(bufdes);
}

void Mrecorder::ConstructL(TInt channels, TInt freq, TInt seconds)
{
	CALLSTACKITEM(_L("Mrecorder::ConstructL"));

	buf=HBufC8::NewMaxL(channels*freq*seconds*2); // 16 bits
	bufdes.Set(buf->Des());
	rec_channels=args.iChannels=channels;
	rec_freq=args.iSampleRate=freq;
	rec_seconds=seconds;
	istream=CMdaAudioInputStream::NewL(*this);
	istream->SetDataTypeL(KMMFFourCCCodePCM16);
	istream->Open(&args);
}

Mrecorder::~Mrecorder()
{
	CALLSTACKITEM(_L("Mrecorder::~Mrecorder"));

	if (istream) {
		istream->Stop();
		delete istream;
	}	
	delete buf;
}

void Mrecorder::save(const TDesC& filename)
{
	CALLSTACKITEM(_L("Mrecorder::save"));

	WaveFile file;
        file.OpenForWrite(filename, rec_freq, 16, rec_channels);
	TInt ret;
        ret=file.WriteData((INT16*) bufdes.Ptr(), rec_freq*rec_channels*rec_seconds);
	if (ret!=DDC_SUCCESS) {
		msg.Format(_L("Write error: %d"), ret);
		error(msg);
	}
        ret=file.Close();
	if (ret!=DDC_SUCCESS) {
		msg.Format(_L("Close error: %d"), ret);
		error(msg);
	}
}
