/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#include "screen.h"
#include <gdi.h>

#include "app_context.h"

screen::screen()
{

}

screen::~screen()
{

}

void screen::ConstructL(RWsSession* wsSession)
{

	if (CEikonEnv::Static()) {
		screenDevice = CEikonEnv::Static()->ScreenDevice();
	} else {
		screenDevice =new(ELeave) CWsScreenDevice(*wsSession);
		User::LeaveIfError(screenDevice->Construct());
	}
	
	black=0;
	gray=221;
}

bool screen::dialog_on_screen()
{

	TSize size=screenDevice->SizeInPixels();

	TBuf8<200> scan1;
	TBuf8<200> scan2;

	TInt w=size.iWidth;
	if (w>200) w=200;

	screenDevice->GetScanLine(scan1, TPoint(0, size.iHeight-27), w, EColor256);
	screenDevice->GetScanLine(scan2, TPoint(0, size.iHeight-26), w, EColor256);

	bool dialog=true;
	for (int i=10; i<w-10; i++) {
		if (scan1[i]!=black) {
			dialog=false;
			break;
		}
		if (scan2[i]!=gray) {
			dialog=false;
			break;
		}
	}
	
	return dialog;
}
