/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#include "sms.h"

#include <mtclreg.h>                        // for CClientMtmRegistry 
#include <msvids.h>                         // for Message type IDs
#include <AknQueryDialog.h>                 // for CAknTextQueryDialog
#include <smscmds.h>
#include <smuthdr.h>
#include <smutset.h>
#include <msvuids.h>
#include <txtrich.h>
#include <smsclnt.h>
#include <mtmdef.h>
#include <gsmupdu.h>

#include "Context_logapp.h"

class dummyhandler: public MMsvSessionObserver {
public:
	virtual void HandleSessionEventL(TMsvSessionEvent, TAny*, TAny*, TAny*) { }
};

sms::sms() : CCheckedActive(EPriorityIdle, _L("sms"))
{
	CALLSTACKITEM(_L("sms::sms"));

}

sms::~sms()
{
	CALLSTACKITEM(_L("sms::~sms"));

	Cancel();
	
	delete sendOptions;
	delete op;
	delete iMtm;
	delete iReceiveMtm;
	delete iMtmReg;
	delete iReceiveMtmReg;
	delete iReceiveSession;
	delete iSession;
	delete dummy;
	delete iHandlers;

#ifdef __WINS__
	delete iTimer;
#endif

}

void sms::ConstructL()
{
	CALLSTACKITEM(_L("sms::ConstructL"));

	dummy=new (ELeave) dummyhandler;
	//unread_messages = new (ELeave) RArray<TMsvId>;

	// Create CMsvSession
	iReceiveSession = CMsvSession::OpenSyncL(*this); // new session is opened synchronously
	iReceiveMtmReg = CClientMtmRegistry::NewL(*iReceiveSession);
	iReceiveMtm = iReceiveMtmReg->NewMtmL(KUidMsgTypeSMS);

	iSession = CMsvSession::OpenSyncL(*dummy); // new session is opened synchronously
	iMtmReg = CClientMtmRegistry::NewL(*iSession);
	iMtm = iMtmReg->NewMtmL(KUidMsgTypeSMS);

	iHandlers=CList<i_handle_received_sms*>::NewL();

	CActiveScheduler::Add(this); // add to scheduler

#ifdef __WINS__
	iTimer=CTimeOut::NewL(*this);
#endif

}

TInt sms::send_message(const TDesC& recipient, const TDesC& body, bool keep_sent)
{
	CALLSTACKITEM(_L("sms::send_message"));

	TRAPD(err, send_messageL(recipient, body, keep_sent));
	if (err!=KErrNone /*&& reception_handler*/) {
		TBuf<50> errs;
		errs.Format(_L("err %d: %S"), err, &state);
		//reception_handler->handle_error(errs);
		handle_error(errs);
	}
	//send_messageL(recipient, body);
	return err;
}

#ifdef __WINS__
void sms::expired(CBase*)
{
	CALLSTACKITEM(_L("sms::expired"));

		//if (reception_handler) {
		iCount++;
		TBuf<100> msg;
		msg.Format(_L("itse  on alueella  TESTI%d   "), iCount);
		//reception_handler->handle_reception(_L("16507"), msg);
		
		CList<i_handle_received_sms*>::Node* i=iHandlers->iFirst;
		while (i) 
		{
			i->Item->handle_reception(0,0,_L("16507"), msg);
			i=i->Next;
		}
		
		
		
	//}
}
#endif

void sms::send_messageL(const TDesC& recipient, const TDesC& body, bool keep_sent)
{
	CALLSTACKITEM(_L("sms::send_messageL"));

#ifdef __WINS__
	iTimer->Wait(1);
	return;
#endif

	if (iStatus==KRequestPending) {
		User::Leave(KErrServerBusy);
	}

	state=_L("send_messageL");
	
	TMsvEntry newEntry;								 // This represents an entry in the Message Server index
	newEntry.iMtm = KUidMsgTypeSMS;                         // message type is SMS
	newEntry.iType = KUidMsvMessageEntry;                   // this defines the type of the entry: message 
	newEntry.iServiceId = KMsvLocalServiceIndexEntryId;     // ID of local service (containing the standard folders)
	newEntry.iDate.HomeTime();                              // set the date of the entry to home time
			
	newEntry.SetInPreparation(ETrue);                       // a flag that this message is in preparation
	

	// get ref to outbox
	state=_L("NewL");
	auto_ptr<CMsvEntry> entry(CMsvEntry::NewL(*iSession, KMsvGlobalOutBoxIndexEntryId ,TMsvSelectionOrdering()));
	
	// create message in outbox
	state=_L("CreateL");
	entry->CreateL(newEntry);	
	
	state=_L("GetEntry");
	entry.reset(iSession->GetEntryL(newEntry.Id()));
	
	// SetCurrentEntryL takes ownership of the CMsvEntry
	state=_L("SetCurrentEntry");
	iMtm->SetCurrentEntryL(entry.get());
	entry.release();
	
	state=_L("Entry()");
	TMsvEntry msvEntry = (iMtm->Entry()).Entry();
	
	state=_L("Body()");
	CRichText& mtmBody = iMtm->Body();
	mtmBody.Reset();
	
	state=_L("set message");
	mtmBody.InsertL(0, body);   // insert our msg tag as the body text
	
	// set iRecipient into the Details of the entry
	msvEntry.iDetails.Set(recipient);  // set recipient info in details
	msvEntry.SetInPreparation(EFalse);         // set inPreparation to false
	
	msvEntry.SetSendingState(KMsvSendStateWaiting);   // set the sending state (immediately)
	msvEntry.iDate.HomeTime();                        // set time to Home Time


	
	
	// To handle the sms specifics we start using SmsMtm
	CSmsClientMtm* smsMtm = STATIC_CAST(CSmsClientMtm*, iMtm);
	
	state=_L("RestoreServiceAndSettingsL");
	smsMtm->RestoreServiceAndSettingsL();
	
	state=_L("set header");
	// CSmsHeader encapsulates data specific for sms messages,
	// like service center number and options for sending.
	CSmsHeader& header = smsMtm->SmsHeader();
	state=_L("get options");

	if (!sendOptions) {
		sendOptions = CSmsSettings::NewL();
		sendOptions->CopyL(smsMtm->ServiceSettings()); // restore existing settings
		state=_L("SetDelivery");
		sendOptions->SetDelivery(ESmsDeliveryImmediately);      // set to be delivered immediately
	}
	
	// set send options
	// ERROR HERE!
	state=_L("SetSmsSettingsL");
	header.SetSmsSettingsL(*sendOptions);
	
	state=_L("check sc");
	// let's check if there's sc address
	if (header.Message().ServiceCenterAddress().Length() == 0)
	{
		// no, there isn't. We assume there is at least one sc number set and use
		// the default SC number. 
		CSmsSettings* serviceSettings = &(smsMtm->ServiceSettings());
		
		// if number of scaddresses in the list is null
		if (!serviceSettings->NumSCAddresses())
		{
			// FIXME: what to do?
			User::Leave(1);
		} else {
			// set sc address to default. 
			CSmsNumber* sc = 0;
			sc = &(serviceSettings->SCAddress(serviceSettings->DefaultSC()));
			header.Message().SetServiceCenterAddressL(sc->Address());
		}
	}
	
	state=_L("add addresses");
	// Add our recipient to the list, takes in two TDesCs, first is real address and second is an alias
	// works also without the alias parameter.
	smsMtm->AddAddresseeL(recipient, msvEntry.iDetails);
	
	// if message is to be deleted after sending, mark with our UID
	if (!keep_sent) {
		msvEntry.iMtmData3 = KUidcontext_log.iUid;
	}
	
	state=_L("save");
	// save message
	iMtm->Entry().ChangeL(msvEntry);                // make sure that we are handling the right entry
	smsMtm->SaveMessageL();                 // closes the message
	
	state=_L("move");
	// This moves the message entry to outbox, we'll schedule it for sending after this. 
	//    TMsvId movedId = MoveMessageEntryL( KMsvGlobalOutBoxIndexEntryId );  // move message to outbox
	TMsvId movedId = iMtm->Entry().Entry().Id();
	
	// We must create an entry selection for message copies (although now we only have one message in selection)
	auto_ptr<CMsvEntrySelection> selection(new (ELeave) CMsvEntrySelection);
	
	selection->AppendL(movedId);            // add our message to the selection
	
	TBuf8<1> dummyParams;
	//    CCommandAbsorbingControl::NewLC();
	
	state=_L("InvokeAsyncFunctionL");
	// invoking async schedule copy command on our mtm
	op=iMtm->InvokeAsyncFunctionL(
		ESmsMtmCommandScheduleCopy,
		*selection,
		dummyParams,
		iStatus);
	
	SetActive();
	
	//return KErrNone;
}

void sms::HandleSessionEventL(TMsvSessionEvent aEvent, TAny* aArg1, TAny* aArg2, TAny* aArg3)
{
	CALLSTACKITEM(_L("sms::HandleSessionEventL"));

	switch(aEvent) {
	case EMsvEntriesCreated:
		{
			if (!aArg1 || !aArg2 || !iReceiveMtm) return;
			CMsvEntrySelection* entries=(CMsvEntrySelection *)aArg1;
			TMsvId id=*(TMsvId*)aArg2;
			if (id != KMsvGlobalInBoxIndexEntryId) return;
			
			for (int i=0; i< entries->Count(); i++) 
			{
				handle_received(entries->At(i), id);
			}
		}
		break;

	case EMsvEntriesMoved:      // this event is given when message entries are moved
		{
			// An entry has been moved to another parent
			// We are interested messages that have been moved to Sent folder
			if (!aArg1 || !aArg2 || !aArg3 ) return;
			
			TMsvId* toEntryId;
			TMsvId* fromEntryId;
			toEntryId = static_cast<TMsvId*>(aArg2); 
			fromEntryId = static_cast<TMsvId*>(aArg3);
			
			CMsvEntrySelection* entries = static_cast<CMsvEntrySelection*>(aArg1);

			if ( *toEntryId == KMsvSentEntryId )   // the entry has been moved into Sent folder
			{
				// We take the moved entries into a selection
						
				//Process each created entry, one at a time.
				for(TInt i = 0; i < entries->Count(); i++)
				{
					//DeleteSentEntry(entries->At(i)); // this checks the entry and deletes if it is created by GDSMS app
					handle_sent(entries->At(i)); 
				}

			}
			
			for(TInt i = 0; i < entries->Count(); i++)
			{
				handle_moved(entries->At(i), *fromEntryId, *toEntryId);
			}
		}
		break;

	case EMsvEntriesChanged:
		{
			if (!aArg1) return;

			CMsvEntrySelection* entries = static_cast<CMsvEntrySelection*>(aArg1);
			TMsvId* ParentFolder = static_cast<TMsvId*>(aArg2);
			
			// 'changed' event + Inbox folder = Read
			if (*ParentFolder == KMsvGlobalInBoxIndexEntryId )
			{
				for(TInt i = 0; i < entries->Count(); i++)
				{
					handle_read(entries->At(i));
				}
			}
			else
			{
				for(TInt i = 0; i < entries->Count(); i++)
				{
					handle_changed(entries->At(i));
				}
			}
		}
		break;

	case EMsvEntriesDeleted:
		{
				
			if (!aArg1 || !aArg2) return;

			TMsvId* folderId;
			folderId = static_cast<TMsvId*>(aArg2); 
				
			CMsvEntrySelection* entries = static_cast<CMsvEntrySelection*>(aArg1);
						
			for(TInt i = 0; i < entries->Count(); i++)
			{
				handle_deleted(entries->At(i), *folderId);
			}
			
			
				
			
		}
		break;

	default:
		break;
	}
	
}

/*void sms::set_reception_handler(i_handle_received_sms* handler)
{
	CALLSTACKITEM(_L("sms::set_reception_handler"));

	reception_handler=handler;
}*/

/*
class hide_message: public CBase {
public:
static NewLC(
*/

TBool sms::DeleteSentEntry(TMsvId entry)
{
	CALLSTACKITEM(_L("sms::DeleteSentEntry"));

	TInt err;
	// Load this entry to our mtm
	TRAP(err, iReceiveMtm->SwitchCurrentEntryL(entry));
	// probably wasn't compatible, ignore
	if (err!=KErrNone) return EFalse;
	TRAP(err, iReceiveMtm->LoadMessageL());
	// probably wasn't compatible, ignore
	if (err!=KErrNone) return EFalse;
	
	TMsvEntry msvEntry( (iReceiveMtm->Entry()).Entry() );
		
        if (msvEntry.iMtmData3 == KUidcontext_log.iUid)    // this entry has been created by our app
	{
		// Taking a handle to the Sent folder...
		TMsvSelectionOrdering sort;
		sort.SetShowInvisibleEntries(ETrue);    // we want to handle also the invisible entries
		// Take a handle to the parent entry
		auto_ptr<CMsvEntry> parentEntry(CMsvEntry::NewL(iReceiveMtm->Session(), msvEntry.Parent(), sort));
		
		// here parentEntry is the Sent folder (must be so that we can call DeleteL) 
		parentEntry->DeleteL(msvEntry.Id());
				
		return ETrue; // entry was deleted
	}
	
	return EFalse; // no entries deleted
}

void sms::handle_error(const TDesC& descr)
{
	CALLSTACKITEM(_L("sms::handle_error"));

	CList<i_handle_received_sms*>::Node* i=iHandlers->iFirst;
	while (i) 
	{
		i->Item->handle_error(descr);
		i=i->Next;
	}	
}

bool sms::loadmessageL(const TMsvId& entry_id, TMsvEntry& entry)
{
	CALLSTACKITEM(_L("sms::loadmessageL"));

	TInt err;
	//if (!reception_handler) return;
	
	auto_ptr<CMsvEntry> realentry(0);
	TRAP(err, realentry.reset(iReceiveSession->GetEntryL(entry_id)) );
	if (err!=KErrNone) 
	{
		TBuf<50> msg;
		msg.Format(_L("Error in GetEntry %d"), err);
		handle_error(msg);
		return false;
	}
	entry=realentry->Entry();
	if (entry.iMtm != KUidMsgTypeSMS) 
	{
		handle_error(_L("Not an SMS"));
		return false;
	}
	
	// SetCurrentEntryL takes ownership of the CMsvEntry
	TRAP(err, iReceiveMtm->SetCurrentEntryL(realentry.get()));
	realentry.release();
	if (err!=KErrNone) 
	{
		TBuf<50> msg;
		msg.Format(_L("Error in SetCurrentEntryL: %d"), err);
		handle_error(msg);
		return false;
	}
	TMsvPartList validationFlags(KMsvMessagePartBody|
		KMsvMessagePartDescription|KMsvMessagePartOriginator);
	if (iReceiveMtm->ValidateMessage(validationFlags != 0)) 
	{
		return false;
	}
	
	// The message loading sometimes fails with KErrAccessDenied - the message server is
	// busy. Just retry loading. 
	TInt retry_count=0; TInt MAX_RETRIES=5;
	while (retry_count<MAX_RETRIES) 
	{
		TRAP(err, iReceiveMtm->LoadMessageL());
		if (err==KErrAccessDenied || err==KErrInUse) {
			retry_count++;
			User::After(TTimeIntervalMicroSeconds32(100*1000)); //100 ms
		} else if (err==-1) {
			// can ignore
			return false;
		} else if (err!=KErrNone) {
			TBuf<50> msg;
			msg.Format(_L("Error in LoadMessageL: %d"), err);
			handle_error(msg);
			return false;
		} else {
			break;
		}
	}
	if (retry_count==MAX_RETRIES) {
		//reception_handler->handle_error(_L("max retries on LoadMessageL reached"));
		handle_error(_L("max retries on LoadMessageL reached"));
		return false;
	}
	return true;
}

void sms::handle_received(const TMsvId& entry_id, const TMsvId& folder_id)
{
	CALLSTACKITEM(_L("sms::handle_received"));

	TInt err;

	TMsvEntry entry;
	if (!loadmessageL(entry_id, entry)) return;

	CSmsClientMtm* smsMtm = STATIC_CAST(CSmsClientMtm*, iReceiveMtm);

	//-------------------------------------------------------------------------------------------
	
	CList<i_handle_received_sms*>::Node* i=iHandlers->iFirst;
	while (i) 
	{
		if ( i->Item->handle_reception(entry_id, folder_id, smsMtm->SmsHeader().FromAddress(), iReceiveMtm->Body().Read(0)) )
		{
			entry.SetNew(EFalse);
			entry.SetVisible(EFalse);
		
			// if this fails, a message notification will pop up
			// but nothing drastic happens. Nothing we can do to fix,
			// so just ignore it
			TRAP(err, iReceiveMtm->Entry().ChangeL(entry));
			if (err!=KErrNone) 
			{
				smsMtm->SaveMessageL();                 // closes the message
			}
			
			TMsvSelectionOrdering sort;
			sort.SetShowInvisibleEntries(ETrue);
			
			auto_ptr<CMsvEntry> parent(CMsvEntry::NewL(*iReceiveSession, entry.Parent(), sort));					
			parent->DeleteL(entry_id);
		}
		i=i->Next;
	}

}

void sms::AddHandler(i_handle_received_sms* handler)
{
	CALLSTACKITEM(_L("sms::AddHandler"));

	iHandlers->AppendL(handler);
}

void sms::handle_deleted(const TMsvId& entry_id, const TMsvId& parent_id)
{
	CALLSTACKITEM(_L("sms::handle_deleted"));

	auto_ptr<CMsvEntry> realentry(0);
	TRAPD(err, realentry.reset(iReceiveSession->GetEntryL(entry_id)) );
	if (err!=KErrNone) 
	{
		return;
	}
	if (realentry->Entry().iMtm != KUidMsgTypeSMS) {
		return;
	}

	CSmsClientMtm* smsMtm = STATIC_CAST(CSmsClientMtm*, iReceiveMtm);

	CList<i_handle_received_sms*>::Node* i=iHandlers->iFirst;
	while (i) 
	{
		i->Item->handle_delete(entry_id, parent_id, smsMtm->SmsHeader().FromAddress() );
		i=i->Next;
	}
	
}

void sms::handle_sent(const TMsvId& entry_id)
{
	CALLSTACKITEM(_L("sms::handle_sent"));

	TMsvEntry entry;
	if (!loadmessageL(entry_id, entry)) return;
		
	CSmsClientMtm* smsMtm = STATIC_CAST(CSmsClientMtm*, iReceiveMtm);

	//-------------------------------------------------------------------------------------------
	
	CList<i_handle_received_sms*>::Node* i=iHandlers->iFirst;
	while (i) 
	{
		i->Item->handle_sending(entry_id, smsMtm->SmsHeader().FromAddress(), iReceiveMtm->Body().Read(0)) ;
		i=i->Next;
	}	

}

void sms::handle_moved(const TMsvId& /*entry_id*/, const TMsvId& /*from_entry_id*/, const TMsvId& /*to_entry_id*/)
{
	CALLSTACKITEM(_L("sms::handle_moved"));

	/*CSmsClientMtm* smsMtm = STATIC_CAST(CSmsClientMtm*, iReceiveMtm);

	CList<i_handle_received_sms*>::Node* i=iHandlers->iFirst;
	while (i) 
	{
		i->Item->handle_move(entry_id, from_entry_id, to_entry_id, smsMtm->SmsHeader().FromAddress());
		i=i->Next;
	}*/

}

void sms::handle_changed(const TMsvId& /*entry_id*/)
{
	CALLSTACKITEM(_L("sms::handle_changed"));

	/*CSmsClientMtm* smsMtm = STATIC_CAST(CSmsClientMtm*, iReceiveMtm);
	
	CList<i_handle_received_sms*>::Node* i=iHandlers->iFirst;
	while (i) 
	{
		//if ( buf.Length()<=0)
		//{
			i->Item->handle_change(entry_id, _L(""));
		//}
		//else
		//{
		//	i->Item->handle_change(entry_id, smsMtm->SmsHeader().FromAddress());
		//}
		i=i->Next;
	}*/
}

void sms::handle_read(const TMsvId& entry_id)
{
	CALLSTACKITEM(_L("sms::handle_read"));

	CSmsClientMtm* smsMtm = STATIC_CAST(CSmsClientMtm*, iReceiveMtm);

	CList<i_handle_received_sms*>::Node* i=iHandlers->iFirst;
	while (i) 
	{
		i->Item->handle_read(entry_id, smsMtm->SmsHeader().FromAddress());
		i=i->Next;
	}
}
