/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/
#include <aknnavi.h>
#include "icons.h"
#include <aknIconArray.h>
#include "userview.h"
#include "symbian_auto_ptr.h"
#include <context_log.rsg>
#include "context_log.hrh"
#include <aknviewappui.h> 
#include <eiktxlbm.h>
#include <akntitle.h> 

#include <gulbordr.h>
#include <gulicon.h>
#include <eikmenup.h>

#include "app_context.h"

// ================= MEMBER FUNCTIONS =======================

CUserContextContainer::CUserContextContainer(CAknViewAppUi* AppUi) : iAppUi(AppUi)
{
	CALLSTACKITEM(_L("CUserContextContainer::CUserContextContainer"));

}

void CUserContextContainer::SetSizes(const TRect& aRect)
{
	TRect r(aRect);
	r.SetHeight(20);
	r.Move(2, 2);
	r.SetWidth(r.Width());

	TRect c(r);
	//c.Move( (c.Width()-iTitle->MinimumSize().iWidth)/2, 0);
	//iTitle->SetRect(c);

	r.SetHeight(42);
	r.Move(0, 21);
	iListBox->SetRect(r);

	r.SetHeight(aRect.Height()-r.Height()-28);
	r.Move(0, 45);
	c=r;
	c.Move( (c.Width()-iDescription->MinimumSize().iWidth)/2, 0);
	c.Move( 0, (c.Height()-iDescription->MinimumSize().iHeight)/2 );
	iDescription->SetRect(c);
}

void CUserContextContainer::ConstructL(const TRect& aRect, CCircularLog* Log, MEikListBoxObserver* ListBoxObserver)
{
	CALLSTACKITEM(_L("CUserContextContainer::ConstructL"));

	CEikStatusPane* sp=iEikonEnv->AppUiFactory()->StatusPane();
	CAknTitlePane* tp=(CAknTitlePane*)sp->ControlL(TUid::Uid(EEikStatusPaneUidTitle));
	tp->SetText(CEikonEnv::Static()->AllocReadResourceL(R_MY_CONTEXT_CAPTION));

	iDescriptionText=CEikonEnv::Static()->AllocReadResourceL(R_MY_CONTEXT_DESCRIPTION);

	iLog=Log;
	
	iLog->SetObserver(this);

	CreateWindowL(); 

	//iListBox = new (ELeave) CEikTextListBox;
	iListBox = new (ELeave) doublelinebox;
	iListBox->SetMopParent(this);
	iListBox->ConstructL(this, EAknListBoxSelectionList);


	iListBox->SetItemHeightL(40);
	iListBox->View()->SetMatcherCursor(EFalse);
	
	// icon array
	CAknIconArray * icons = new (ELeave) CAknIconArray(30);
	LoadIcons(icons);
	iListBox->ItemDrawer()->FormattedCellData()->SetIconArray(icons);

	iListBox->Model()->SetItemTextArray(iLog);
	iListBox->Model()->SetOwnershipType(ELbmDoesNotOwnItemArray);
	iListBox->CreateScrollBarFrameL(ETrue);
	iListBox->ScrollBarFrame()->SetScrollBarVisibilityL( CEikScrollBarFrame::EOff, CEikScrollBarFrame::EAuto);

	iListBox->MakeVisible(ETrue);

	//iTitle=new (ELeave) CEikLabel;
	//iTitle->SetContainerWindowL( *this );
	//iTitle->SetTextL(*iTitleText);
	//iTitle->OverrideColorL(EColorLabelText, KRgbBlue);

	iDescription=new (ELeave) CEikLabel;
	iDescription->SetContainerWindowL( *this );
	iDescription->SetTextL(*iDescriptionText);
	iDescription->SetFont(CEikonEnv::Static()->DenseFont());

	SetSizes(aRect);

	iListBox->ActivateL();
	iListBox->DrawNow();

	iListBox->SetListBoxObserver(ListBoxObserver);

	SetRect(aRect);
	ActivateL();
}

CUserContextContainer::~CUserContextContainer()
{
	CALLSTACKITEM(_L("CUserContextContainer::~CUserContextContainer"));

	iLog->SetObserver(0);
	delete iListBox;
	delete iDescription;
	//delete iTitle;

	delete iDescriptionText;
	//delete iTitleText;
}
void CUserContextContainer::SizeChanged()
{
	CALLSTACKITEM(_L("CUserContextContainer::SizeChanged"));

	SetSizes(Rect());
}

TInt CUserContextContainer::CountComponentControls() const
{
	CALLSTACKITEM(_L("CUserContextContainer::CountComponentControls"));

	return 2;
}

CCoeControl* CUserContextContainer::ComponentControl(TInt aIndex) const
{
	CALLSTACKITEM(_L("CUserContextContainer::ComponentControl"));

	switch(aIndex) {
	case 0:
		return iListBox;
		break;
	case 1:
		return iDescription;
		break;
	
	default:
		return 0;
	}
}

void CUserContextContainer::Draw(const TRect& aRect) const
{
	CALLSTACKITEM(_L("CUserContextContainer::Draw"));

	CWindowGc& gc = SystemGc();
	// TODO: Add your drawing code here
	// example code...
	gc.SetPenStyle(CGraphicsContext::ENullPen);
	gc.SetBrushColor(KRgbWhite);
	gc.SetBrushStyle(CGraphicsContext::ESolidBrush);
	gc.DrawRect(aRect);

	
}

void CUserContextContainer::HandleControlEventL(
						CCoeControl* /*aControl*/,TCoeEvent /*aEventType*/)
{
	CALLSTACKITEM(_L("CUserContextContainer::HandleControlEventL"));

	// TODO: Add your control event handler code here
}

void CUserContextContainer::ContentsChanged()
{
	CALLSTACKITEM(_L("CUserContextContainer::ContentsChanged"));

	TRAPD(err,
		if (iListBox) iListBox->HandleItemRemovalL();
		iListBox->DrawNow());
}

TKeyResponse CUserContextContainer::OfferKeyEventL(const TKeyEvent &aKeyEvent, TEventCode aType)
{
	CALLSTACKITEM(_L("CUserContextContainer::OfferKeyEventL"));

	if (aType==EEventKey) 
	{
		if (aKeyEvent.iCode=='5') {
			iPresses++;
			if (iPresses==3) {
				iAppUi->HandleCommandL(Econtext_logDetailedView);
			}
		} else {
			iPresses=0;
		}
	}
	
	return iListBox->OfferKeyEventL(aKeyEvent, aType);
}

CUserView* CUserView::NewL(CCircularLog* Log, CPresencePublisher*& PresencePublisher)
{
	CALLSTACKITEM(_L("CUserView::NewL"));

	auto_ptr<CUserView> ret(new (ELeave) CUserView(PresencePublisher));
	ret->ConstructL(Log);
	return ret.release();
}

CUserView::CUserView(CPresencePublisher*& PresencePublisher) : iPresencePublisher(PresencePublisher)
{
	CALLSTACKITEM(_L("CUserView::CUserView"));

}

// ---------------------------------------------------------
// CAppLogView::ConstructL(const TRect& aRect)
// EPOC two-phased constructor
// ---------------------------------------------------------
//
void CUserView::ConstructL(CCircularLog* Log)
{
	CALLSTACKITEM(_L("CUserView::ConstructL"));

	BaseConstructL( R_USERVIEW_VIEW );
	iLog=Log;
}


// ---------------------------------------------------------
// CAppLogView::~CAppLogView()
// ?implementation_description
// ---------------------------------------------------------
//
CUserView::~CUserView()
{
	CALLSTACKITEM(_L("CUserView::~CUserView"));

	if ( iContainer )
        {
		AppUi()->RemoveFromViewStack( *this, iContainer );
        }
	
	delete iContainer;
}

// ---------------------------------------------------------
// TUid CAppLogView::Id()
// ?implementation_description
// ---------------------------------------------------------
//
TUid CUserView::Id() const
{
	CALLSTACKITEM(_L("CUserView::Id"));

	return KUserViewId;
}

// ---------------------------------------------------------
// CAppLogView::HandleCommandL(TInt aCommand)
// ?implementation_description
// ---------------------------------------------------------
//
void CUserView::HandleCommandL(TInt aCommand)
{   
	CALLSTACKITEM(_L("CUserView::HandleCommandL"));

	AppUi()->HandleCommandL(aCommand);
}

// ---------------------------------------------------------
// CAppLogView::HandleClientRectChange()
// ---------------------------------------------------------
//
void CUserView::HandleClientRectChange()
{
	CALLSTACKITEM(_L("CUserView::HandleClientRectChange"));

	if ( iContainer )
        {
		iContainer->SetRect( ClientRect() );
        }
}

// ---------------------------------------------------------
// CAppLogView::DoActivateL(...)
// ?implementation_description
// ---------------------------------------------------------
//
void CUserView::DoActivateL(
				const TVwsViewId& /*aPrevViewId*/,TUid /*aCustomMessageId*/,
				const TDesC8& /*aCustomMessage*/)
{
	CALLSTACKITEM(_L("CUserView::DoActivateL"));

	if (!iContainer) {
		iContainer=new (ELeave) CUserContextContainer(AppUi());
		iContainer->SetMopParent(this);
		iContainer->ConstructL( ClientRect(), iLog, this);
		AppUi()->AddToStackL( *this, iContainer );
        } 
}

// ---------------------------------------------------------
// CAppLogView::HandleCommandL(TInt aCommand)
// ?implementation_description
// ---------------------------------------------------------
//
void CUserView::DoDeactivate()
{
	CALLSTACKITEM(_L("CUserView::DoDeactivate"));

	if ( iContainer )
        {
		AppUi()->RemoveFromViewStack( *this, iContainer );
        }
	
	delete iContainer;
	iContainer = 0;
}

void CUserView::HandleListBoxEventL(CEikListBox* /*aListBox*/,TListBoxEvent /*aEventType*/)
{
	CALLSTACKITEM(_L("CUserView::HandleListBoxEventL"));
	AppUi()->HandleCommandL(Econtext_logPresenceDetails);
}

void CUserView::DynInitMenuPaneL(
					 TInt aResourceId,CEikMenuPane* aMenuPane)
{
	CALLSTACKITEM(_L("CUserView::DynInitMenuPaneL"));

	switch(aResourceId) {
	case R_USERVIEW_VIEW_MENU:
		if (iPresencePublisher) {
			if (iPresencePublisher->ConnectionSuspended()) {
				aMenuPane->SetItemDimmed(Econtext_logCmdAppSuspendPresence, ETrue);	
				aMenuPane->SetItemDimmed(Econtext_logCmdAppResumePresence, EFalse);
			} else {
				aMenuPane->SetItemDimmed(Econtext_logCmdAppSuspendPresence, EFalse);	
				aMenuPane->SetItemDimmed(Econtext_logCmdAppResumePresence, ETrue);
			}
		} else {
			aMenuPane->SetItemDimmed(Econtext_logCmdAppSuspendPresence, ETrue);	
			aMenuPane->SetItemDimmed(Econtext_logCmdAppResumePresence, ETrue);
		}
		break;
	default:
		break;
	}
}
// End of File
