#!/usr/bin/perl

$libdump=$ARGV[0];

open(IN, "<$libdump") || die "cannot open $libdump";
%classses=%h=();

while(<IN>) {
	chop; s/
//;
	next unless (/Symbol name/);
	#print $_, "\n";
	/^[^(]*\((.*)\)$/;
	$sig=$1;
	#print "SIG: $sig\n";
	$sig=~s/__\w+//;
	$sig=~/([^:]*): ([^:]*) (\w+)::(.*)/;
	($vis, $return, $class, $method)=($1, $2, $3, $4);
	#print "VIS: $vis RETURN $return CLASS $class METHOD $method\n";
	#($class, $method)=($1, $2);
	$classes{$class}=1;
	$method=~s/,/, /g;
	push( @{$h{$class}{$vis}}, $return . " " . $method);
}
close(IN);

$libdump=~s/\./_/g;
$libdump.=".h";
open(OUT, ">$libdump") || die "cannot open $libdump";

$libdump=~s/\./_/g;
$libdump=uc($libdump);

print OUT "#ifndef $libdump", "_INCLUDED\n";
print OUT "#define $libdump", "_INCLUDED 1\n\n";

foreach $class (keys %classes) {
	next if ($class eq "");
	print OUT "class $class;\n";
}

print OUT "\n";

foreach $class (keys %classes) {
	next if ($class eq "");
	print OUT "class $class ";
	if ($class=~/^C/) { print OUT ": public CBase "; }
	print OUT {\n";
	foreach $vis ("public", "protected") {
		$head=$vis . ":\n";
		@methods=@{$h{$class}{$vis}};
		foreach $m (@methods) {
			print OUT $head;
			print OUT "\tIMPORT_C ", $m, ";\n";
			$head="";
		}
	}
	if ($clas=~/^R/) {
		print OUT "\tchar dummy[24];\n";
	}
	print OUT "};\n\n";
}

print OUT "#endif\n";
