/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#include <e32base.h>
#include <e32cons.h>
#include <stdlib.h>
#include <apgcli.h>
#include <apgtask.h>
#include <w32std.h>
#include <saclient.h>

#include <app_context.h>
#include <file_output_base.h>

#include <context_uids.h>
const TUid KUidPhone = { 0x100058b3 };
const TUid KUidMenu = {  0x101f4cd2 };

const TInt KUidCloseLogValue=0x2003;
const TUid KUidCloseLog={KUidCloseLogValue};
const TInt KUidToBackgroundValue=0x2004;
const TUid KUidToBackground={KUidToBackgroundValue};

class TFileStack : public MCallStackVisitor {
public:
	TFileStack(Cfile_output_base& aInto) : iInto(aInto) { }
private:
	virtual void BeginStack()
	{
		iInto.log_message(_L8("Stack trace: "));
	}
	virtual void VisitItem(const TDesC& Name)
	{
		iInto.log_message(Name);
	}
	virtual void EndStack()
	{
	}

	Cfile_output_base& iInto;
};

const TInt KUidSimCStatusValue = 0x100052E9;
const TUid KUidSimCStatus = {KUidSimCStatusValue};
enum TSASimCStatus
        {
        ESACSimInitWait,
        ESACSimLockOperative,
        ESACSimPinVerifyRequired,
        ESACSimPermanentlyBlocked,
        ESACSimRemoved,
        ESACSimRejected,
        ESACSimBlocked,
        ESACSimOk
        };

// This is the mainloop game loop or whatever
void mainloop(void)
{

	TInt pushed=0;

	HBufC* cmdh=0;
#ifndef __WINS__
	RProcess p=RProcess();
	cmdh=HBufC::NewLC( p.CommandLineLength() ); ++pushed;
	TPtr16 cmd=cmdh->Des();
	p.CommandLine(cmd);
#else
	cmdh=HBufC::NewLC(30);  ++pushed;
	TPtr16 cmd=cmdh->Des();
	cmd=_L("context_log ");
	cmd.AppendNum( KUidcontext_log.iUid );
#endif
	_LIT(Kcontext_log, "context_log");
	TBuf<30> chunkname;
	TUid appuid;

	if (cmd.Length() > 0) {
		TLex l(cmd);
		l.Mark();
		l.SkipCharacters();
		chunkname=l.MarkedToken();
		l.SkipSpace();
		TInt uid;
		User::LeaveIfError( l.Val(uid) );
		appuid.iUid=uid;
	} else {
		appuid=KUidcontext_log;
		chunkname=Kcontext_log;
	}

	CApp_context* ctx=CApp_context::NewL(true);
	CleanupStack::PushL(ctx); ++pushed;
	ctx->SetDataDir(_L("c:\\system\\data\\context\\"), false);

	Cfile_output_base *fo=0;
	RTimer timer;
	CConsoleBase* console=0;
	TTime time;
	RApaLsSession ls;
	RWsSession ws;
	User::LeaveIfError(ws.Connect());
	CleanupClosePushL(ws); ++pushed;
	TRequestStatus app_status, timer_status;
	TApaTaskList tl(ws);

	timer.CreateLocal();
	CleanupClosePushL(timer); ++pushed;
	User::LeaveIfError(ls.Connect());
	CleanupClosePushL(ls); ++pushed;

	if (cmd.Length()==0) {
		fo=Cfile_output_base::NewL(*ctx, _L("starter"));
		CleanupStack::PushL(fo); ++pushed;

		//console=Console::NewL(_L("starter"),TSize(KConsFullScreen,KConsFullScreen));
		//CleanupStack::PushL(console); ++pushed;

		if (fo) fo->log_message(_L8("waiting for phone start"));
		// don't start app until phone has actually booted up
#ifndef __WINS__
		RSystemAgent	iAgent;
		User::LeaveIfError(iAgent.Connect());
		CleanupClosePushL(iAgent);
		while ( iAgent.GetState(KUidSimCStatus) != ESACSimOk ) {
#else
		while (! tl.FindApp(KUidMenu).Exists()) {
#endif
			time.HomeTime();
			time+=TTimeIntervalSeconds(30);
			//time+=TTimeIntervalMicroSeconds(50);
			timer.At(timer_status,time);
			User::WaitForRequest(timer_status);
		}
#ifndef __WINS__
			CleanupStack::PopAndDestroy(); // iAgent
#endif
	}

	RChunk stackchunk;
	TInt cerr=stackchunk.OpenGlobal(chunkname, EFalse);
	if (cerr!=KErrNone) {
		User::LeaveIfError(stackchunk.CreateGlobal(chunkname, 4096, 4096));
		*(TInt*)stackchunk.Base()=0;
	}
	CleanupClosePushL(stackchunk); ++pushed;

	_LIT(filen, ""); //dummy

	TThreadId app_threadid;

	//wake up on thread death
	RThread app_thread;
	bool thread_is_open=false;

#ifndef __WINS__
	TTimeIntervalHours wait_interval(1);
	//TTimeIntervalMinutes wait_interval(1);
	TInt restart_on_count=23;
	//TInt restart_on_count=2;
#else
	//TTimeIntervalSeconds wait_interval(5);
	TTimeIntervalHours wait_interval(1);
	TInt restart_on_count=23;
#endif

	int wait_count=0; // we can only wait upto 1 hour at a time,
			// so count to 24...

	time.HomeTime();
#ifdef __WINS__
	time += TTimeIntervalSeconds(1);
#else
	time += TTimeIntervalSeconds(10);
#endif
	if (console) {
		TBuf<30> dt;
		time.FormatL(dt, _L("%F%Y-%M-%D %H:%T:%S\n"));
		console->Printf(dt);
	}

	bool done=false; bool restarting=false; bool doing_restart=false;
	bool logged_on=false;
	int restart_count=0; const int RESTART_MAX=20;
	TInt restart_time=30;

	if (cmd.Length()==0) {
		timer.At(timer_status,time);
		app_status=KRequestPending;
		doing_restart=restarting=true;
	} else {
		time.HomeTime();
		time += wait_interval;
		timer.At(timer_status, time);

		TApaTask app_task=tl.FindApp(appuid);
		if (!app_task.Exists()) {
			User::Leave(KErrNotFound);
		}
		User::LeaveIfError(app_thread.Open(app_task.ThreadId()));
		thread_is_open=true;
		app_thread.Logon(app_status); logged_on=true;
		doing_restart=restarting=false;
		restart_time=0;
	}

	while(!done) {
		//if (fo) fo->log_message(_L8("waiting"));
		User::WaitForRequest(timer_status, app_status);
		if (timer_status!=KRequestPending && !doing_restart) {
			//if (fo) fo->log_message(_L8("timer expired"));
			RDebug::Print(_L("timer!"));
			if (console) {
				TBuf<30> dt;
				time.FormatL(dt, _L("%F%Y-%M-%D %H:%T:%S\n"));
				console->Printf(_L("%d "), timer_status);
				console->Printf(dt);
			}
			if (wait_count==restart_on_count) {
				if (fo) fo->switch_file();
				TApaTask app_task=tl.FindApp(appuid);
				if (!app_task.Exists()) {
					if (fo) fo->log_message(_L8("app already dead"));
					restarting=true;
					doing_restart=true;
				} else {
					if (fo) fo->log_message(_L8("shutting down context_log"));
					app_task.SendSystemEvent(EApaSystemEventShutdown);
					//app_task.SendMessage(KUidCloseLog, _L8(""));

					if (console) console->Printf(_L("shut app\n"));
				}
				restarting=true; restart_count=0;
				wait_count=0;
			} else {
				wait_count++;
			}
			time.HomeTime();
			time += wait_interval;
			timer.At(timer_status, time);
		} 
		if (app_status!=KRequestPending || doing_restart) {
			TInt etype=0, ereason=0;
			TExitCategoryName ecat=0;
			if (app_status!=KRequestPending) {
				if (fo) fo->log_message(_L8("app stopped"));
				if (console) console->Printf(_L("app stopped\n"));
				logged_on=false;
				etype=app_thread.ExitType();
				ereason=app_thread.ExitReason();
				ecat=app_thread.ExitCategory();
				app_thread.Close(); thread_is_open=false;
				if (etype!=0 || ereason!=0) {
					if (!fo) {
						TBuf<100> name=_L("starter-");
						name.Append(chunkname);
						fo=Cfile_output_base::NewL(*ctx, name);
						CleanupStack::PushL(fo); ++pushed;
					}
					TBuf8<100> msg=_L8("reasons: ");
					msg.AppendNum(etype); msg.Append(_L8(", "));
					msg.AppendNum(ereason); msg.Append(_L8(", "));
					msg.Append(ecat);
					fo->log_message(msg);
					TFileStack fs(*fo);
					ctx->IterateStack(fs, (char*)stackchunk.Base());
					*(TInt*)stackchunk.Base()=0;
				}
			}
			
			if ((etype!=0 || (etype==0 && ereason==2003) || restarting) && restart_count<RESTART_MAX) {

				if (fo) fo->log_message(_L8("restarting app"));
				time.HomeTime();
				time+=TTimeIntervalSeconds(restart_time);
				restart_time=30;
				timer.Cancel();
				timer.At(timer_status, time);
				User::WaitForRequest(timer_status);

				TInt err;
				err=ls.StartDocument(filen, appuid, app_threadid);
				restart_count++;
				if (err==KErrNone) {
					if (fo) fo->log_message(_L8("success in restarting app"));
					if (logged_on) {
						app_thread.LogonCancel(app_status);
						logged_on=false;
					}
					if (thread_is_open) {
						app_thread.Close();
						thread_is_open=false;
					}
	
					err=app_thread.Open(app_threadid);

					if (err==KErrNone) {
						thread_is_open=true;
						app_thread.Logon(app_status);
						logged_on=true;
						restarting=false;
						doing_restart=false;

						time.HomeTime();
						time+=TTimeIntervalSeconds(6);
						timer.At(timer_status, time);
						User::WaitForRequest(timer_status);

						TApaTask app_task=tl.FindApp(appuid);
						if (app_task.Exists()) {
							//app_task.SendMessage(KUidToBackground, _L8(""));
							TWsEvent e;
							e.SetType(999);
							ws.SendEventToWindowGroup(app_task.WgId(), e);
							if (fo) fo->log_message(_L8("Sent toBckgnd msg"));
						} 
						time.HomeTime();
						time+=wait_interval;
						timer.At(timer_status, time);
					}
					else
					{
						if (fo) fo->log_message(_L8("test"));
					}
				} 
				if (err!=KErrNone) {
					TBuf<30> msg;
					msg.Format(_L("Error starting %d\n"), err);
					if (console) {
						console->Printf(msg);
					}
					if (fo) fo->log_message(msg);
					doing_restart=true;
					time.HomeTime();
					time+=TTimeIntervalSeconds(30);
					timer.Cancel();
					timer.At(timer_status, time);
					restarting=true;
				}
			} else {
				// user shutdown
				done=true;
			}
		}
	}
	if (fo) fo->log_message(_L8("stopping"));
	if (logged_on) app_thread.LogonCancel(app_status);
	if (thread_is_open) app_thread.Close();
	if (console) {
		console->Getch(); // get and ignore character
	}
	CleanupStack::PopAndDestroy(pushed); //console, ws, ls, timer

}

_LIT(KTxtEPOC32EX,"STARTER");

#ifdef __WINS__

EXPORT_C TInt InitEmulator() // mainloop function called by the emulator software
{
	__UHEAP_MARK;
	CTrapCleanup* cleanup=CTrapCleanup::New(); // get clean-up stack
	TRAPD(error,mainloop()); // more initialization, then do example
	__ASSERT_ALWAYS(!error,User::Panic(KTxtEPOC32EX,error));
	delete cleanup; // destroy clean-up stack
	__UHEAP_MARKEND;
	
	//CloseSTDLIB();
	User::Exit(0);
	
	return KErrNone;
}

int GLDEF_C E32Dll(TDllReason)
{
	return(KErrNone);
}

#else

GLDEF_C TInt E32Main() // mainloop function called by E32
{
	__UHEAP_MARK;
	CTrapCleanup* cleanup=CTrapCleanup::New(); // get clean-up stack
	TRAPD(error,mainloop()); // more initialization, then do example
	__ASSERT_ALWAYS(!error,User::Panic(KTxtEPOC32EX,error));
	delete cleanup; // destroy clean-up stack
	__UHEAP_MARKEND;
	
	//CloseSTDLIB();
	User::Exit(0);
	
	return KErrNone; // and return
}

#endif

