#!/usr/bin/perl

$version=$ARGV[0];

open(INV, "<$version") || die "cannot open $version";
while(<INV>) {
	chop;
	($t, $v)=split(/\s*=\s*/);
	$versions{lc($t)}=$v;
}
close(INV);
die "no minor version specified" if ($versions{'minor'} eq "");
die "no major version specified" if ($versions{'major'} eq "");

$version=~s/version\.txt/context_uids/;

my $v21=0;

if ($ENV{'EPOCROOT'} =~ /Series60_v21/i) { $v21=1; }

foreach $h ( ".rh", ".h") {
	$file=$version . $h;
	open(INV, "<$file") || die "cannot open version file";
	while(<INV>) {
		if (/^const/) {
			chop;
			/const tuid kuid([^ ]+) = { ([^ ]+) }/i;
			($name, $uid) = ($1, $2);
			unless ($defs{$uid} eq "") {
				$uids{lc($name)}=$defs{$uid};
			} else {
				$uids{lc($name)}=$uid;
			}
		} elsif (/^#\s*define/) {
			/#\s*define\s+([^ \t]+)\s+([x0-9A-F]+)/i;
			$defs{$1}=$2;
		}
	}
	close(INV);
}

open(BLDINF, "<bld.inf") || die "cannot open bld.inf";
while(<BLDINF>) {
	next if (m!^//!);
	next unless (/mmp$/i);
	chop; s/
//;
	$name="";
	/.*\\([^\\.]+).mmp/i;
	$name=lc($1);
	s/mmp/pkg/i;
	$file=$_;

	die "no uid for $name" if ($uids{$name} eq "");

	open(IN, "<$file") || die "cannot open input $file";
	$file=~s/.pkg/_build.pkg/i;
	open(OUT, ">${file}") || die "cannot open output";

	while(<IN>) {
		if ($v21) {
			s/Series60_v20/Series60_v21/ig;
		} else {
			s/Series60_v21/Series60_v20/ig;
		}
		if (/^#/) {
			/(.*, *)([0-9]+), *([0-9]+)( *,[0-9]+\s*)$/;
			($beg,$major,$minor,$rest)=($1,$2,$3,$4);
			$minor=$versions{'minor'};
			$major=$versions{'major'};

			$beg=~s/(.*}, *\().*/$1/;
			$beg .= $uids{$name} . "),";
			
			print OUT $beg, $major, ",", $minor, $rest;
		} else {
			print OUT $_;
		}
	}

	close(IN);
	close(OUT);

	#system("move ${file}.tmp $file");
}

close(BLDINF);


@pkgs=<*.pkg>;
foreach $file (@pkgs) {
	open(OUT, ">${file}.tmp") || die "cannot open output";
	open(IN, "<$file") || die "cannot open input";

	while(<IN>) {
		if (/^#/ || /^@/) {
			$name="";
			/"([^"]*)"/;
			$name=lc($1);
			if ($name=~/\\/) {
				$name=~s/^.*\\([^\\]+)$/$1/;
			}
			$name=~s/_build//i;
			$name=~s/\.sis//i;
			$name=~s/_dbg//i;
			die "no uid for $name" if ($uids{$name} eq "");
			$uid=$uids{$name};
			s/\(0x[0-9A-F]+\)/($uid)/i;
		}
		if ($v21) {
			s/Series60_v20/Series60_v21/ig;
		} else {
			s/Series60_v21/Series60_v20/ig;
		}

		print OUT $_;
	}

	close(IN);
	close(OUT);

	system("move ${file}.tmp $file");
}
