#ifndef BB_DATA_H_INCLUDED
#define BB_DATA_H_INCLUDED 1

#include <xmlbuf.h>
#include <xml.h>
#include <s32strm.h>
#include <bamdesca.h>

class TStringArg;

struct TComponentName {
	TUid	iModule;
	TInt	iId;

	IMPORT_C bool operator==(const TComponentName& rhs) const;
	IMPORT_C operator TStringArg() const;
};

struct TTypeName {
	TUid	iModule;
	TInt	iId;
	TInt	iMajorVersion;
	TInt	iMinorVersion;

	IMPORT_C static TTypeName IdFromAttributes(const XML_Char ** atts);
	IMPORT_C void CompareMajorL(const TTypeName& aOther) const;
	IMPORT_C MDesCArray* MakeAttributesLC() const;
	IMPORT_C void ExternalizeL(RWriteStream& aStream) const;
	IMPORT_C static TTypeName IdFromStreamL(RReadStream& aStream);
	IMPORT_C void IntoStringL(TDes& aString) const;

	IMPORT_C bool operator==(const TTypeName& rhs) const;
	IMPORT_C operator TStringArg() const;
};

const int KMaxTupleSubNameLength = 128;

struct TTupleName {
	TUid	iModule;
	TInt	iId;
	IMPORT_C bool operator==(const TTupleName& rhs) const;
	IMPORT_C operator TStringArg() const;
};

class MNestedXmlHandler : public MXmlHandler {
public:
	virtual void SetError(TInt aError) = 0;
	IMPORT_C virtual ~MNestedXmlHandler();
};

class MBBExternalizer {
public:
	virtual void BeginList(const TDesC& aName, TBool aIncludeBBType, const TTypeName& aBBType) = 0;
	virtual void BeginCompound(const TDesC& aName, TBool aIncludeBBType, const TTypeName& aBBType) = 0;

	enum TBasicType {
		EInteger=0,	// decimal or hex with leading 0x
		EFloat,		// '.' point, optional sign, optional 0
		EString,
		EBoolean,	// 'true'/'false'
		EDateTime,	// ISO datetime YYYYMMDDTHHMISS
		EBinary		// as hex
	};

	virtual void Field(const TDesC& aName, TBasicType aBasicType, const TDesC& aValue,
		TBool aIncludeBBType, const TTypeName& aBBType) = 0;

	virtual void EndCompound(const TDesC& aName) = 0;
	virtual void EndList(const TDesC& aName) = 0;
};

class MBBData {
public:
        virtual const TDesC&    Name() const = 0;

        virtual void		IntoStringL(TDes& aString) const = 0;
	virtual void		IntoXmlL(MBBExternalizer* aBuf, TBool aIncludeType=ETrue) const = 0;
	virtual void		ExternalizeL(RWriteStream& aStream) const = 0;

        virtual void		FromStringL(const TDesC& aString) = 0;
	virtual MNestedXmlHandler*	FromXmlL(MNestedXmlHandler* aParent, CXmlParser* aParser,
					HBufC*& aBuf, TBool aCheckType=ETrue) = 0;
	virtual void		InternalizeL(RReadStream& aStream) = 0;

        virtual const TTypeName& Type() const = 0;
	virtual MBBData*	CloneL(const TDesC& Name) const = 0;

	IMPORT_C virtual ~MBBData();

	/*
	 * a MBBData derived class should also have the method:
	 static const TTypeName& StaticType();
	 * so that bb_cast<>() works
	 */
	virtual TBool Equals(const MBBData* aRhs) const = 0;
};

IMPORT_C void CleanupPushBBDataL(MBBData* aData);

class MBBDataFactory {
public:
	virtual MBBData* CreateBBDataL(const TTypeName& aType, const TDesC& aName, MBBDataFactory* aTopLevelFactory) = 0;
		// name's lifetime has to be as long or longer than the created object's
	virtual void ConstructL() = 0;
	virtual ~MBBDataFactory() { }
};

class CBBGeneralHolder : public CBase, public MBBData {
public:
	MBBData*		iValue;
        virtual const TDesC&    Name() const;

	IMPORT_C void SetOwnsValue(TBool aOwns);
	IMPORT_C TBool OwnsValue() const;

	IMPORT_C CBBGeneralHolder(MBBDataFactory* aFactory, MBBData* aValue=0);
	IMPORT_C ~CBBGeneralHolder();

        IMPORT_C virtual void		IntoStringL(TDes& aString) const;
	IMPORT_C virtual void		IntoXmlL(MBBExternalizer* aBuf, TBool aIncludeType=ETrue) const;
	IMPORT_C virtual void		ExternalizeL(RWriteStream& aStream) const;

        IMPORT_C virtual void		FromStringL(const TDesC& aString);
	IMPORT_C virtual MNestedXmlHandler*	FromXmlL(MNestedXmlHandler* aParent, CXmlParser* aParser,
					HBufC*& aBuf, TBool aCheckType=ETrue);
	IMPORT_C virtual void		InternalizeL(RReadStream& aStream);

        IMPORT_C virtual const TTypeName& Type() const;

	IMPORT_C virtual TBool Equals(const MBBData* aRhs) const;
	IMPORT_C virtual MBBData*	CloneL(const TDesC& Name) const;

	const MBBData* operator()() const { return iValue; }
	MBBData*& operator()() { return iValue; }
private:
	MBBDataFactory*	iFactory;
	TBool iOwnsValue;
};

class CBBDataFactory : public CBase, public MBBDataFactory {
public:
	EXPORT_C static CBBDataFactory* NewL();

	virtual MBBData* CreateBBDataL(const TTypeName& aType, const TDesC& aName, MBBDataFactory* aTopLevelFactory) = 0;
		// name's lifetime has to be as long or longer than the created object's
	IMPORT_C void ConstructL();
	IMPORT_C virtual ~CBBDataFactory();
	virtual void Reset() = 0;
};

template<typename T>
T* bb_cast(MBBData* o) { 
	if (!o) return 0; 
	if (! (o->Type() == T::StaticType())) return 0; 
	return static_cast<T*>(o);
}

template<typename T>
const T* bb_cast(const MBBData* o) { 
	if (!o) return 0; 
	if (! (o->Type() == T::StaticType())) return 0; 
	return static_cast<const T*>(o);
}

#endif
