#ifndef CONTEXT_BBERRORINFO_H_INCLUDED
#define CONTEXT_BBERRORINFO_H_INCLUDED 1

#include "concretedata.h"
#include "errorhandling.h"

_LIT(KErrorCode, "error_code");
_LIT(KUid, "uid");
_LIT(KCode, "code");

class TBBErrorCode : public TBBCompoundData  {
public:
	TBBUid		iUid;
	TBBInt		iCode;

	IMPORT_C operator TErrorCode() const;
        IMPORT_C virtual const TTypeName& Type() const;
	IMPORT_C virtual TBool Equals(const MBBData* aRhs) const;

	IMPORT_C static const TTypeName& StaticType();
	IMPORT_C const MBBData* Part(TUint aPartNo) const;

	IMPORT_C TBBErrorCode& operator=(const TBBErrorCode& aErrorCode);
	IMPORT_C MBBData* CloneL(const TDesC& Name) const;
public:
	IMPORT_C TBBErrorCode();
	IMPORT_C TBBErrorCode(const TBBErrorCode& aErrorCode);
	IMPORT_C TBBErrorCode(TUid aUid, TInt aCode);
	IMPORT_C TBBErrorCode(TErrorCode aErrorCode);
	virtual const TDesC& StringSep(TUint aBeforePart) const;

	IMPORT_C bool operator==(const TBBErrorCode& aRhs) const;
};

_LIT(KSeverity, "severity");
_LIT(KInfo, "INFO");
_LIT(KWarning, "WARNING");
_LIT(KError, "ERROR");
_LIT(KCorrupt, "CORRUPT");

class TBBSeverity : public TBBUint {
public:
        IMPORT_C virtual const TTypeName& Type() const;
	IMPORT_C static const TTypeName& StaticType();
	IMPORT_C MBBData* CloneL(const TDesC& Name) const;
	IMPORT_C TBBSeverity();
	IMPORT_C TBBSeverity(TUint aSeverity);
	IMPORT_C TBBSeverity(TSeverity aSeverity);

	IMPORT_C operator TSeverity() const;
        virtual void IntoStringL(TDes& aString) const;
        virtual void FromStringL(const TDesC& aString);
};

_LIT(KErrorType, "error_type");

_LIT(KBug, "BUG");
_LIT(KInput, "INPUTDATA");
_LIT(KTemporary, "TEMPORARY");
_LIT(KLocalEnvironment, "LOCALENVIRONMENT");
_LIT(KRemote, "REMOTE");

class TBBErrorType : public TBBUint {
public:
        IMPORT_C virtual const TTypeName& Type() const;
	IMPORT_C MBBData* CloneL(const TDesC& Name) const;
	IMPORT_C TBBErrorType();
	IMPORT_C TBBErrorType(TUint aErrorType);
	IMPORT_C TBBErrorType(TErrorType aErrorType);
	IMPORT_C operator TErrorType() const;

        virtual void IntoStringL(TDes& aString) const;
        virtual void FromStringL(const TDesC& aString);
};

_LIT(KErrorInfo, "error_info");
_LIT(KUserMsg, "user_msg");
_LIT(KTechnicalMsg, "tech_msg");
_LIT(KStackTrace, "stack_trace");

class CBBErrorInfo : public CBase, public TBBCompoundData, public MErrorInfo {
public:
	TBBSeverity	iSeverity;
	TBBErrorType	iErrorType;
	TBBErrorCode	iErrorCode;

	CBBString*	iUserMsg;
	CBBString*	iTechnicalMsg;
	CBBString*	iStackTrace;

        IMPORT_C virtual const TTypeName& Type() const;
	IMPORT_C static const TTypeName& StaticType();
	IMPORT_C	MBBData* CloneL(const TDesC& Name) const;
	IMPORT_C static CBBErrorInfo* NewL(MBBDataFactory* aFactory, TSeverity aSeverity, TErrorType aErrorType,
		TErrorCode aErrorCode);
	IMPORT_C static CBBErrorInfo* NewL(MBBDataFactory* aFactory, const MErrorInfo* aInfo);
	IMPORT_C virtual TBool Equals(const MBBData* aRhs) const;
	IMPORT_C const MBBData* Part(TUint aPartNo) const;

	IMPORT_C virtual void AddRef() const;
	IMPORT_C virtual void Release() const;
	IMPORT_C void SetInnerError(CBBErrorInfo* aInfo);
	IMPORT_C void SetInnerError(const MErrorInfo* aInfo);
	IMPORT_C void SetNextError(CBBErrorInfo* aInfo);
	IMPORT_C void SetNextError(const MErrorInfo* aInfo);
	IMPORT_C const MErrorInfo* InnerErrorInfo();
	IMPORT_C const MErrorInfo* NextErrorInfo();
private:
	CBBGeneralHolder iInnerErrorInfo;
	CBBGeneralHolder iNextErrorInfo;

	~CBBErrorInfo();
	CBBErrorInfo(MBBDataFactory* aFactory,
		TSeverity aSeverity, TErrorType aErrorType,
		TErrorCode aErrorCode);
	void ConstructL();
	virtual TErrorCode ErrorCode() const;
	virtual const TDesC& StackTrace() const;
	virtual const TDesC& UserMessage() const;
	virtual const TDesC& TechMessage() const;
	virtual TErrorType ErrorType() const;
	virtual TSeverity Severity() const;
	virtual const MErrorInfo* InnerError() const;
	virtual const MErrorInfo* NextError() const;

	virtual const TDesC& StringSep(TUint aBeforePart) const;

	MBBDataFactory* iFactory;

	mutable TUint	iRefCount;
	friend class auto_ptr<CBBErrorInfo>;
};

#endif