#ifndef BB_LIST_H_INCLUDED
#define BB_LIST_H_INCLUDED 1

#include "bbdata.h"
#include <list.h>

class CBBGenericList : public CBase, public MBBData {
public:
	IMPORT_C static CBBGenericList* NewL(const TDesC& aName, const TDesC& aChildName,
		const TDesC& aStringSep, MBBDataFactory* aFactory);
	IMPORT_C virtual ~CBBGenericList();

        IMPORT_C virtual const TDesC&    Name() const;

        IMPORT_C virtual void		IntoStringL(TDes& aString) const;
	IMPORT_C virtual void		IntoXmlL(MBBExternalizer* aBuf, TBool aIncludeType=ETrue) const;
	IMPORT_C virtual void		ExternalizeL(RWriteStream& aStream) const;

        IMPORT_C virtual void		FromStringL(const TDesC& aString);
	IMPORT_C virtual MNestedXmlHandler*	FromXmlL(MNestedXmlHandler* aParent, CXmlParser* aParser,
					HBufC*& aBuf, TBool aCheckType=ETrue);
	IMPORT_C virtual void		InternalizeL(RReadStream& aStream);

        IMPORT_C virtual const TTypeName& Type() const;
        IMPORT_C static const TTypeName& StaticType();
	IMPORT_C virtual void	AddItemL(HBufC*	aName, MBBData* aData); // takes ownership
	IMPORT_C TInt		Count() const;
	IMPORT_C MBBData*	First();
	IMPORT_C MBBData*	Next();
	IMPORT_C const MBBData*	First() const;
	IMPORT_C const MBBData*	Next() const;
	IMPORT_C TBool Equals(const MBBData* aRhs) const;
	IMPORT_C void Reset();

	IMPORT_C virtual MBBData* CloneL(const TDesC& Name) const;
protected:
	IMPORT_C CBBGenericList& operator=(const CBBGenericList& aRhs);
	IMPORT_C CBBGenericList(const TDesC& aName, const TDesC& aChildName,
		const TDesC& aStringSep, MBBDataFactory* aFactory);
	IMPORT_C void	ConstructL();
	IMPORT_C virtual TBool	FixedType() const;
protected:
	struct TDataItem {
		HBufC*		iName;
		MBBData*	iData;

		TDataItem(HBufC* aName, MBBData* aData) : iName(aName), iData(aData) { }
		TDataItem() : iName(0), iData(0) { }
	};
	CList<TDataItem>*	iData;
	const TDesC&		iName;
	const TDesC&		iChildName;
	const TDesC&		iStringSep;
	MBBDataFactory*		iFactory;

	// used by CListXml to store intermediate results
	HBufC*			iCurrentName;
	MBBData*		iCurrentData;
	void			AddCurrentItemL();
	mutable CList<TDataItem>::Node  *iIterator;

	friend class CListXml;
};

#endif
