#ifndef BB_UTIL_H_INCLUDED
#define BB_UTIL_H_INCLUDED 1

#include <e32std.h>
#include "bbdata.h"

IMPORT_C void CheckStringSpaceL(const TDes& aString, TInt aSpace);
IMPORT_C void AppendCheckingSpaceL(TDes& aString, const TDesC& toAppend);
IMPORT_C void CloseMBBDataIndirect(TAny* aPtr);

template<class Y> struct bb_auto_ptr_ref
{
  Y* iPtr;
  bb_auto_ptr_ref(Y* aPtr) : iPtr(aPtr) {}
};

template<class X> class bb_auto_ptr
{
public:  
  typedef X element_type;

  bb_auto_ptr(X* aPtr = 0): iPtr(aPtr), iBasePtr(aPtr)
  {
    CleanupStack::PushL(TCleanupItem(CloseMBBDataIndirect, (void*)&iBasePtr));
  }  
  
  bb_auto_ptr(bb_auto_ptr& aPtr): iPtr(aPtr.release()), iBasePtr(iPtr)
  {
    CleanupStack::PushL(TCleanupItem(CloseMBBDataIndirect, (void*)&iBasePtr));
  }

  bb_auto_ptr<X>& operator=(bb_auto_ptr<X>& aRhs)
  {
    if (&aRhs != this)
    {
      delete iPtr;
      iBasePtr = iPtr = aRhs.release();
    }
    return (*this); 
  }

  ~bb_auto_ptr() 
  { 
    CleanupStack::Pop();
    delete iPtr;
  }

  X& operator *() const { return *iPtr; }
  X* operator ->() const { return iPtr; }
   
  X* get() const { return iPtr; }

  X* release()
 	{ 
    X* result = iPtr;
    iBasePtr = iPtr = 0;
		return result; 
  }

  void reset(X* aPtr = 0) {
    if (aPtr != iPtr) {
      delete iPtr;
      iBasePtr = iPtr = aPtr;
    }
  }


  bb_auto_ptr(bb_auto_ptr_ref<X> aRef): iPtr(aRef.iPtr), iBasePtr(iPtr)
  {
    CleanupStack::PushL(TCleanupItem(CloseMBBDataIndirect, (void*)&iBasePtr));
  }


  template <class Y> operator bb_auto_ptr_ref<Y>() 
    { return bb_auto_ptr_ref<Y>(this->release()); }
  
private:
  X* iPtr;  
  MBBData* iBasePtr;
};

#endif