#ifndef BBXML_H_INCLUDED 
#define BBXML_H_INCLUDED 1

#include "bbdata.h"
#include "concretedata.h"

class CXmlBufExternalizer : public CXmlBuf16, public MBBExternalizer {
public:
	IMPORT_C static CXmlBufExternalizer* NewL(TInt aInitialSize);
};

class TIgnoreXml : public MNestedXmlHandler {
public:
	IMPORT_C TIgnoreXml(MNestedXmlHandler* aParent, CXmlParser* aParser);
	virtual void SetError(TInt aError);
	virtual void StartElement(const XML_Char *name,
				const XML_Char **atts);

	virtual void EndElement(const XML_Char *name);
	virtual void CharacterData(const XML_Char *s,
				    int len);
	virtual void Error(XML_Error Code, const XML_LChar * String, long ByteIndex);

private:
	TUint	iDepth;
	MNestedXmlHandler* iParent;
	CXmlParser* iParser;
};

class TCheckingXml : public MNestedXmlHandler {
private:
	IMPORT_C virtual void StartElement(const XML_Char *name,
				const XML_Char **atts);
	IMPORT_C virtual void EndElement(const XML_Char *name);

	IMPORT_C virtual void CharacterData(const XML_Char *s,
				    int len);
protected:
	IMPORT_C TCheckingXml(MNestedXmlHandler* aParent, CXmlParser* aParser);

	IMPORT_C virtual void ErrorInHandler(TInt aError);

	IMPORT_C virtual void StartElementL(const XML_Char *name,
				const XML_Char **atts) = 0;
	IMPORT_C virtual void EndElementL(const XML_Char *name) = 0;

	IMPORT_C virtual void CharacterDataL(const XML_Char *s,
				    int len) = 0;

	MNestedXmlHandler*	iParent;
	TIgnoreXml	iIgnore; TBool iIgnoreElement;
	CXmlParser*	iParser;
};

class TBBXml : public TCheckingXml {
protected:
	IMPORT_C TBBXml(MNestedXmlHandler* aParent, CXmlParser* aParser,
		HBufC*& aBuf, MBBData& aValue, TBool aCheckType);

	HBufC*&		iBuf;
	MBBData&	iValue;
	TBool		iCheckType;
};

class TSingleXml : public TBBXml {
public:
	IMPORT_C TSingleXml(MNestedXmlHandler* aParent, CXmlParser* aParser,
		HBufC*& aBuf, MBBData& aValue, TBool aCheckType);
protected:
	IMPORT_C virtual void StartElementL(const XML_Char *name,
				const XML_Char **atts);
	IMPORT_C virtual void EndElementL(const XML_Char *name);

	IMPORT_C virtual void CharacterDataL(const XML_Char *s,
				    int len);

	IMPORT_C virtual void Error(XML_Error Code, const XML_LChar * String, long ByteIndex);
	IMPORT_C virtual void SetError(TInt aError);

};

class CContainerXml : public TBBXml, public CBase
{
protected:
	IMPORT_C CContainerXml(MNestedXmlHandler* aParent, CXmlParser* aParser,
		HBufC*& aBuf, MBBData& aValue, TBool aCheckType);
	IMPORT_C ~CContainerXml();
protected:
	IMPORT_C virtual void StartElementL(const XML_Char *name,
				const XML_Char **atts);

	IMPORT_C virtual void StartInnerElementL(const XML_Char *name, const XML_Char **atts) = 0;
	IMPORT_C virtual void EndInnerElementL(const XML_Char *name) = 0;

	IMPORT_C virtual void CharacterDataL(const XML_Char *s,
				    int len);
	IMPORT_C virtual void EndElementL(const XML_Char *s);
	IMPORT_C void EndElement(const XML_Char * name);

	IMPORT_C void SetCurrentHandler(MNestedXmlHandler* aHandler); // takes ownership
	IMPORT_C MNestedXmlHandler* GetCurrentHandler();
private:
	TInt	iDepth;
	MNestedXmlHandler* iCurrentHandler;
};

class CPartContainerXml : public CContainerXml
{
public:
	IMPORT_C CPartContainerXml(MNestedXmlHandler* aParent, CXmlParser* aParser,
		HBufC*& aBuf, TBBCompoundData& aValue, TBool aCheckType);
private:
	IMPORT_C virtual void StartInnerElementL(const XML_Char *name, const XML_Char **atts);
	IMPORT_C virtual void EndInnerElementL(const XML_Char *name);

	IMPORT_C virtual void Error(XML_Error Code, const XML_LChar * String, long ByteIndex);
	IMPORT_C virtual void SetError(TInt aError);

	TBBCompoundData& iCompoundValue;
	TInt	iCurrentPart; TBool iErrorsInCurrent;
};

class CSingleParser : public CBase {
public:
	IMPORT_C static CSingleParser* NewL(MBBData* aParseInto, TBool  aCheckType,
		TBool aIgnoreUnknown);
	virtual void ParseL(const TDesC8& aXml) = 0;
};

#endif
