#ifndef BB_CONCRETEDATA_H_INCLUDED
#define BB_CONCRETEDATA_H_INCLUDED 1

#pragma warning(disable: 4800)

#include "bbdata.h"
#include "bbutil.h"
#include "bberrors.h"

class TBBSimpleData : public MBBData {
public:
	const TDesC&		iName;
	TBBSimpleData(const TDesC& aName) : iName(aName) { }

	IMPORT_C virtual MNestedXmlHandler*	FromXmlL(MNestedXmlHandler* aParent, CXmlParser* aParser,
					HBufC*& aBuf, TBool aCheckType=ETrue);
	IMPORT_C virtual const TDesC&	Name() const;
};

class TBBInt : public TBBSimpleData  {
public:
	TInt			iValue;

	IMPORT_C virtual void		IntoXmlL(MBBExternalizer* aBuf, TBool aIncludeType=ETrue) const;
        IMPORT_C virtual void		IntoStringL(TDes& aString) const;
	IMPORT_C virtual void		ExternalizeL(RWriteStream& aStream) const;

        IMPORT_C virtual void		FromStringL(const TDesC& aString);
	IMPORT_C virtual void		InternalizeL(RReadStream& aStream);

        IMPORT_C virtual const TTypeName& Type() const;
	IMPORT_C virtual TBool Equals(const MBBData* aRhs) const;

	IMPORT_C static const TTypeName& StaticType();
	IMPORT_C MBBData* CloneL(const TDesC& Name) const;

public:
	TBBInt(const TDesC& aName) : TBBSimpleData(aName), iValue(0) { }
	TBBInt(TInt aValue, const TDesC& aName) : TBBSimpleData(aName), iValue(aValue) { }
	TBBInt& operator=(TInt aValue) { iValue=aValue; return *this; }

	TInt& operator()() { return iValue; }
	const TInt& operator()() const { return iValue; }
	bool operator==(const TBBInt& aRhs) const { return iValue==aRhs.iValue; }
};

class TBBFixedLengthStringBase  : public TBBSimpleData {
public:
	TBBFixedLengthStringBase(const TDesC& aName) : TBBSimpleData(aName) { }
	IMPORT_C void IntoXmlL(MBBExternalizer* aBuf, TBool aIncludeType=ETrue) const;
	IMPORT_C void IntoStringL(TDes& aString) const;
	IMPORT_C void ExternalizeL(RWriteStream& aStream) const;
	IMPORT_C void FromStringL(const TDesC& aString);
	IMPORT_C void InternalizeL(RReadStream& aStream);

	virtual TDes& Value() = 0;
	virtual const TDesC& Value() const = 0;
};

class TBBFixedLengthStringBase8 : public TBBSimpleData {
public:
	TBBFixedLengthStringBase8(const TDesC& aName) : TBBSimpleData(aName) { }
	IMPORT_C void IntoXmlL(MBBExternalizer* aBuf, TBool aIncludeType=ETrue) const;
	IMPORT_C void IntoStringL(TDes& aString) const;
	IMPORT_C void ExternalizeL(RWriteStream& aStream) const;
	IMPORT_C void FromStringL(const TDesC& aString);
	IMPORT_C void InternalizeL(RReadStream& aStream);

	virtual TDes8& Value() = 0;
	virtual const TDesC8& Value() const = 0;
};

class TBBShortString : public TBBFixedLengthStringBase {
public:
	TBuf<50> iValue;

        IMPORT_C virtual const TTypeName& Type() const;
	IMPORT_C static const TTypeName& StaticType();

	IMPORT_C virtual TBool Equals(const MBBData* aRhs) const;

	TDes& operator()() { return iValue; }
	const TDesC& operator()() const { return iValue; }

	virtual TDes& Value() { return iValue; }
	virtual const TDesC& Value() const  { return iValue; }
	IMPORT_C MBBData* CloneL(const TDesC& Name) const;
public:

	TBBShortString(const TDesC& aName) : TBBFixedLengthStringBase(aName) { }
	TBBShortString(const TDesC& aValue, const TDesC& aName) : TBBFixedLengthStringBase(aName) { iValue=aValue.Left(50); }
	TBBShortString& operator=(const TDesC& aValue) { iValue=aValue.Left(50); return *this; }
	bool operator==(const TBBShortString& aRhs) const { return !(iValue.Compare(aRhs.iValue)); }
};

class TBBShortString8 : public TBBFixedLengthStringBase8 {
public:
	TBuf8<50> iValue;

        IMPORT_C virtual const TTypeName& Type() const;
	IMPORT_C static const TTypeName& StaticType();

	IMPORT_C virtual TBool Equals(const MBBData* aRhs) const;

	TDes8& operator()() { return iValue; }
	const TDesC8& operator()() const { return iValue; }

	virtual TDes8& Value() { return iValue; }
	virtual const TDesC8& Value() const  { return iValue; }
	IMPORT_C MBBData* CloneL(const TDesC& Name) const;
public:

	TBBShortString8(const TDesC& aName) : TBBFixedLengthStringBase8(aName) { }
	TBBShortString8(const TDesC8& aValue, const TDesC& aName) : TBBFixedLengthStringBase8(aName) { iValue=aValue.Left(50); }
	TBBShortString8& operator=(const TDesC8& aValue) { iValue=aValue.Left(50); return *this; }
	bool operator==(const TBBShortString8& aRhs) const { return !(iValue.Compare(aRhs.iValue)); }
};

class TBBLongString : public TBBFixedLengthStringBase {
public:
	TBuf<256> iValue;

        IMPORT_C virtual const TTypeName& Type() const;
	IMPORT_C static const TTypeName& StaticType();

	IMPORT_C virtual TBool Equals(const MBBData* aRhs) const;

	TDes& operator()() { return iValue; }
	const TDesC& operator()() const { return iValue; }

	virtual TDes& Value() { return iValue; }
	virtual const TDesC& Value() const  { return iValue; }
	IMPORT_C MBBData* CloneL(const TDesC& Name) const;
public:

	TBBLongString(const TDesC& aName) : TBBFixedLengthStringBase(aName) { }
	TBBLongString(const TDesC& aValue, const TDesC& aName) : TBBFixedLengthStringBase(aName) { iValue=aValue.Left(256); }
	TBBLongString& operator=(const TDesC& aValue) { iValue=aValue.Left(256); return *this; }
	bool operator==(const TBBLongString& aRhs) const { return !(iValue.Compare(aRhs.iValue)); }
};

class TBBBool : public TBBSimpleData {
public:
	TBool			iValue;

	IMPORT_C virtual void		IntoXmlL(MBBExternalizer* aBuf, TBool aIncludeType=ETrue) const;
        IMPORT_C virtual void		IntoStringL(TDes& aString) const;
	IMPORT_C virtual void		ExternalizeL(RWriteStream& aStream) const;

        IMPORT_C virtual void		FromStringL(const TDesC& aString);
	IMPORT_C virtual void		InternalizeL(RReadStream& aStream);

        IMPORT_C virtual const TTypeName& Type() const;
	IMPORT_C static const TTypeName& StaticType();

	IMPORT_C virtual TBool Equals(const MBBData* aRhs) const;
	IMPORT_C MBBData* CloneL(const TDesC& Name) const;
public:
	TBBBool(const TDesC& aName) : TBBSimpleData(aName), iValue() { }
	TBBBool(TBool aValue, const TDesC& aName) : TBBSimpleData(aName), iValue(aValue) {  }
	TBBBool& operator=(TBool aValue) { iValue=aValue; return *this; }

	TBool& operator()() { return iValue; }
	const TBool& operator()() const { return iValue; }

	bool operator==(const TBBBool& aRhs) const { 
		return ( (iValue && aRhs.iValue) || (!iValue && !aRhs.iValue)); 
	}
};

class TBBTime : public TBBSimpleData {
public:
	TTime			iValue;

	IMPORT_C virtual void		IntoXmlL(MBBExternalizer* aBuf, TBool aIncludeType=ETrue) const;
        IMPORT_C virtual void		IntoStringL(TDes& aString) const;
	IMPORT_C virtual void		ExternalizeL(RWriteStream& aStream) const;

        IMPORT_C virtual void		FromStringL(const TDesC& aString);
	IMPORT_C virtual void		InternalizeL(RReadStream& aStream);

        IMPORT_C virtual const TTypeName& Type() const;
	IMPORT_C static const TTypeName& StaticType();

	IMPORT_C virtual TBool Equals(const MBBData* aRhs) const;
	IMPORT_C MBBData* CloneL(const TDesC& Name) const;
public:
	TBBTime(const TDesC& aName) : TBBSimpleData(aName), iValue() { }
	TBBTime(TTime aValue, const TDesC& aName) : TBBSimpleData(aName), iValue(aValue) {  }
	TBBTime& operator=(TTime aValue) { iValue=aValue; return *this; }

	TTime& operator()() { return iValue; }
	const TTime& operator()() const { return iValue; }

	bool operator==(const TBBTime& aRhs) const { 
		return (iValue==aRhs.iValue); 
	}
};

class TBBUint : public TBBSimpleData  {
public:
	TUint			iValue;

	IMPORT_C virtual void		IntoXmlL(MBBExternalizer* aBuf, TBool aIncludeType=ETrue) const;
        IMPORT_C virtual void		IntoStringL(TDes& aString) const;
	IMPORT_C virtual void		ExternalizeL(RWriteStream& aStream) const;

        IMPORT_C virtual void		FromStringL(const TDesC& aString);
	IMPORT_C virtual void		InternalizeL(RReadStream& aStream);

        IMPORT_C virtual const TTypeName& Type() const;
	IMPORT_C virtual TBool Equals(const MBBData* aRhs) const;

	IMPORT_C static const TTypeName& StaticType();
	IMPORT_C MBBData* CloneL(const TDesC& Name) const;
public:
	TBBUint(const TDesC& aName) : TBBSimpleData(aName), iValue(0) { }
	TBBUint(TUint aValue, const TDesC& aName) : TBBSimpleData(aName), iValue(aValue) { }
	TBBUint& operator=(TUint aValue) { iValue=aValue; return *this; }

	TUint& operator()() { return iValue; }
	const TUint& operator()() const { return iValue; }

	bool operator==(const TBBUint& aRhs) const { return iValue==aRhs.iValue; }
};

class TBBUid : public TBBUint {
public:
	IMPORT_C virtual void		IntoXmlL(MBBExternalizer* aBuf, TBool aIncludeType=ETrue) const;
        IMPORT_C virtual void		IntoStringL(TDes& aString) const;

        IMPORT_C virtual const TTypeName& Type() const;
	IMPORT_C virtual TBool Equals(const MBBData* aRhs) const;

	IMPORT_C static const TTypeName& StaticType();

	TBBUid(const TDesC& aName) : TBBUint(0, aName) { }
	TBBUid(TUint aValue, const TDesC& aName) : TBBUint(aValue, aName) { }
	bool operator==(const TBBUid& aRhs) const { return iValue==aRhs.iValue; }
	IMPORT_C MBBData* CloneL(const TDesC& Name) const;
};


class TBBCompoundData : public TBBSimpleData {
	// if using the default ReadPart():
	// max 32 parts, because read parts are kept in
	// a 32 bit bitmap
public:
	IMPORT_C virtual void		IntoXmlL(MBBExternalizer* aBuf, TBool aIncludeType=ETrue) const;
        IMPORT_C virtual void		IntoStringL(TDes& aString) const;
	IMPORT_C virtual void		ExternalizeL(RWriteStream& aStream) const;

        IMPORT_C virtual void		FromStringL(const TDesC& aString);
	IMPORT_C virtual void		InternalizeL(RReadStream& aStream);
	IMPORT_C virtual MNestedXmlHandler*	FromXmlL(MNestedXmlHandler* aParent, CXmlParser* aParser,
					HBufC*& aBuf, TBool aCheckType=ETrue);
	TBBCompoundData(const TDesC& aName) : TBBSimpleData(aName), iReadParts(0) { }
	IMPORT_C virtual void		ReadPart(TUint aPart, TBool aErrors); // default implementation
							       // sets corresponding bit in iReadParts
protected:
	IMPORT_C virtual MBBData*	GetPart(const TDesC& aName, const TTypeName& aType, TUint& aPartNoInto);
	virtual const MBBData* Part(TUint aPartNo) const = 0;
	virtual const TDesC& StringSep(TUint aBeforePart) const = 0;

	friend class CPartContainerXml;
	TUint	iReadParts;
};

class CBBString : public TBBFixedLengthStringBase, public CBase {
public:
	HBufC*		iBuf;
	TPtr		iPtr;

	IMPORT_C static CBBString* NewL(const TDesC& aName, const TInt aSize=256);
	IMPORT_C void Zero();
	IMPORT_C void Append(const TDesC& aStr);

        IMPORT_C virtual const TTypeName& Type() const;
	IMPORT_C static const TTypeName& StaticType();

	IMPORT_C virtual TBool Equals(const MBBData* aRhs) const;
	IMPORT_C void FromStringL(const TDesC& aString);
	IMPORT_C void InternalizeL(RReadStream& aStream);

	const TDesC& operator()() const { return *iBuf; }

	virtual TDes& Value() { return iPtr; }
	virtual const TDesC& Value() const  { return *iBuf; }
	bool operator==(const CBBString& aRhs) const { return !(iBuf->Des().Compare(*(aRhs.iBuf))); }
	IMPORT_C MBBData* CloneL(const TDesC& Name) const;

	~CBBString();
	IMPORT_C CBBString(const TDesC& aName);
	IMPORT_C void ConstructL(TInt aSize);
};


class CBBString8 : public TBBFixedLengthStringBase8, public CBase {
public:
	HBufC8*		iBuf;
	TPtr8		iPtr;

	IMPORT_C static CBBString8* NewL(const TDesC& aName, const TInt aSize=256);
	IMPORT_C void Zero();
	IMPORT_C void Append(const TDesC8& aStr);

        IMPORT_C virtual const TTypeName& Type() const;
	IMPORT_C static const TTypeName& StaticType();

	IMPORT_C virtual TBool Equals(const MBBData* aRhs) const;
	IMPORT_C void FromStringL(const TDesC8& aString);
	IMPORT_C void InternalizeL(RReadStream& aStream);

	const TDesC8& operator()() const { return *iBuf; }

	virtual TDes8& Value() { return iPtr; }
	virtual const TDesC8& Value() const  { return *iBuf; }
	bool operator==(const CBBString8& aRhs) const { return !(iBuf->Des().Compare(*(aRhs.iBuf))); }
	IMPORT_C MBBData* CloneL(const TDesC& Name) const;

	~CBBString8();
private:
	void ConstructL(TInt aSize);
	CBBString8(const TDesC& aName) : TBBFixedLengthStringBase8(aName), iPtr(0, 0) { }
};

class TBBInt64 : public TBBSimpleData  {
public:
	TInt64			iValue;

	IMPORT_C virtual void		IntoXmlL(MBBExternalizer* aBuf, TBool aIncludeType=ETrue) const;
        IMPORT_C virtual void		IntoStringL(TDes& aString) const;
	IMPORT_C virtual void		ExternalizeL(RWriteStream& aStream) const;

        IMPORT_C virtual void		FromStringL(const TDesC& aString);
	IMPORT_C virtual void		InternalizeL(RReadStream& aStream);

        IMPORT_C virtual const TTypeName& Type() const;
	IMPORT_C virtual TBool Equals(const MBBData* aRhs) const;

	IMPORT_C static const TTypeName& StaticType();
	IMPORT_C MBBData* CloneL(const TDesC& Name) const;
public:
	TBBInt64(const TDesC& aName) : TBBSimpleData(aName), iValue(0) { }
	TBBInt64(TInt64 aValue, const TDesC& aName) : TBBSimpleData(aName), iValue(aValue) { }
	TBBInt64& operator=(TInt64 aValue) { iValue=aValue; return *this; }

	TInt64& operator()() { return iValue; }
	const TInt64& operator()() const { return iValue; }

	bool operator==(const TBBInt64& aRhs) const { return iValue==aRhs.iValue; }
};

class TBBTupleName : public TBBCompoundData {
public:
	TBBUid			iModuleUid;
	TBBInt			iModuleId;

        IMPORT_C virtual const TTypeName& Type() const;
	IMPORT_C virtual TBool Equals(const MBBData* aRhs) const;

	IMPORT_C static const TTypeName& StaticType();
	IMPORT_C const MBBData* Part(TUint aPartNo) const;

	IMPORT_C TBBTupleName(const TDesC& aName);
	IMPORT_C TBBTupleName(const TDesC& aName, TInt aModuleUid, TInt aModuleId);

	IMPORT_C bool operator==(const TBBTupleName& aRhs) const;
	virtual const TDesC& StringSep(TUint aBeforePart) const;
	IMPORT_C TBBTupleName& operator=(const TBBTupleName& aNameData);
	IMPORT_C TBBTupleName& operator=(const TTupleName& aNameData);
	IMPORT_C MBBData* CloneL(const TDesC& Name) const;
};

class TBBComponentName : public TBBTupleName {
public:
        IMPORT_C virtual const TTypeName& Type() const;
	IMPORT_C virtual TBool Equals(const MBBData* aRhs) const;

	IMPORT_C static const TTypeName& StaticType();

	IMPORT_C TBBComponentName(const TDesC& aName);
	IMPORT_C TBBComponentName(const TDesC& aName, TInt aModuleUid, TInt aModuleId);

	IMPORT_C TBBComponentName& operator=(const TComponentName& aNameData);
	IMPORT_C MBBData* CloneL(const TDesC& Name) const;
};

#endif
