#include "concretedata.h"
#include "bberrors.h"
#include "bbtypes.h"
#include "bbutil.h"
#include "bbxml.h"

void LeaveCannotParseValue()
{
	User::Leave(KCannotParseValue);
}

EXPORT_C const TDesC& TBBSimpleData::Name() const
{
	return iName;
}

EXPORT_C MNestedXmlHandler* TBBSimpleData::FromXmlL(MNestedXmlHandler* aParent, CXmlParser* aParser, 
						    HBufC*& aBuf, TBool aCheckType)
{
	return new(ELeave) TSingleXml(aParent, aParser, aBuf, *this, aCheckType);
}


EXPORT_C void TBBInt::IntoStringL(TDes& aString) const
{
	TBuf<20> b;
	b.AppendNum(iValue);
	CheckStringSpaceL(aString, b.Length());
	aString.AppendNum(iValue);
}

EXPORT_C void TBBInt::IntoXmlL(MBBExternalizer* aBuf, TBool aIncludeType) const
{
	TBuf<15> buf;
	buf.AppendNum(iValue);
	aBuf->Field(Name(), MBBExternalizer::EInteger, buf, aIncludeType, Type());
}

EXPORT_C TBool TBBInt::Equals(const MBBData* aRhs) const
{
	const TBBInt* rhs=bb_cast<TBBInt>(aRhs);
	return (rhs && iValue==rhs->iValue);
}

EXPORT_C void TBBInt::ExternalizeL(RWriteStream& aStream) const
{
	aStream.WriteInt32L(iValue);
}

EXPORT_C void TBBInt::FromStringL(const TDesC& aString)
{
	TInt err; TLex aLex;
	if (aString.Left(2).CompareF(_L("0x"))) {
		aLex.Assign(aString);
		err=aLex.Val(iValue);
	} else {
		aLex.Assign(aString.Mid(2));
		TUint v;
		err=aLex.Val(v, EHex);
		iValue=(TInt)v;
	}
	if (err==KErrNone) {
		if (aLex.Remainder().Length()==0) return;
		else 
			LeaveCannotParseValue();
	}
	if (err==KErrGeneral) 
		LeaveCannotParseValue();
	User::Leave(err);
}

EXPORT_C void TBBInt::InternalizeL(RReadStream& aStream)
{
	iValue=aStream.ReadInt32L();
}

EXPORT_C const TTypeName& TBBInt::Type() const
{
	return KIntType;
}

EXPORT_C const TTypeName& TBBInt::StaticType()
{
	return KIntType;
}


EXPORT_C const TTypeName& TBBShortString::Type() const
{
	return KShortStringType;
}

EXPORT_C const TTypeName& TBBShortString::StaticType()
{
	return KShortStringType;
}

EXPORT_C TBool TBBShortString::Equals(const MBBData* aRhs) const
{
	const TBBShortString* rhs=bb_cast<TBBShortString>(aRhs);
	return (rhs && iValue.Compare(rhs->iValue)==0);
}


EXPORT_C void TBBBool::IntoXmlL(MBBExternalizer* aBuf, TBool aIncludeType) const
{
	TBuf<5> b;
	if (iValue) b=_L("true");
	else b=_L("false");

	aBuf->Field(Name(), MBBExternalizer::EBoolean, b, aIncludeType, Type());
}

EXPORT_C void TBBBool::IntoStringL(TDes& aString) const
{
	TBuf<5> b;
	if (iValue) b=_L("true");
	else b=_L("false");

	CheckStringSpaceL(aString, 5);
	aString.Append(b);
}

EXPORT_C void TBBBool::ExternalizeL(RWriteStream& aStream) const
{
	if (iValue)
		aStream.WriteInt8L(1);
	else
		aStream.WriteInt8L(0);
}

EXPORT_C void TBBBool::FromStringL(const TDesC& aString)
{
	if (aString.CompareF(_L("true"))==0 || aString.CompareF(_L("1"))==0 ) iValue=ETrue;
	else if (aString.CompareF(_L("false"))==0 || aString.CompareF(_L("0"))==0 ) iValue=EFalse;
	else LeaveCannotParseValue();	
}

EXPORT_C void TBBBool::InternalizeL(RReadStream& aStream)
{
	TInt8 val=aStream.ReadInt8L();
	if (val) iValue=ETrue;
	else iValue=EFalse;
}

EXPORT_C const TTypeName& TBBBool::Type() const
{
	return KBoolType;
}

EXPORT_C const TTypeName& TBBBool::StaticType()
{
	return KBoolType;
}

EXPORT_C TBool TBBBool::Equals(const MBBData* aRhs) const
{
	const TBBBool* rhs=bb_cast<TBBBool>(aRhs);
	return (rhs && *this == *rhs);
}

EXPORT_C void TBBTime::IntoXmlL(MBBExternalizer* aBuf, TBool aIncludeType) const
{
	TBuf<16> b;
	IntoStringL(b);

	aBuf->Field(Name(), MBBExternalizer::EDateTime, b, aIncludeType, Type());
}

EXPORT_C void TBBTime::IntoStringL(TDes& aString) const
{
	TBuf<16> b;
	TDateTime dt;
	dt=iValue.DateTime();
	_LIT(KFormatTxt,"%04d%02d%02dT%02d%02d%02d");
	b.Format(KFormatTxt, dt.Year(), (TInt)dt.Month()+1, (TInt)dt.Day()+1,
		dt.Hour(), dt.Minute(), dt.Second());

	CheckStringSpaceL(aString, 15);
	aString.Append(b);
}

EXPORT_C void TBBTime::ExternalizeL(RWriteStream& aStream) const
{
	TInt64 val=iValue.Int64();

	aStream.WriteInt32L(val.High());
	aStream.WriteInt32L(val.Low());
}

TTime ParseTimeL(const TDesC& Str)
{
	if (Str.Length() < 15) LeaveCannotParseValue();

	TInt year, month, day, hour, min, sec, err=KErrNone;
        TLex lex;
        
	lex=Str.Mid(0, 4);
        err += lex.Val(year);

        lex=Str.Mid(4, 2);
        err += lex.Val(month);

        lex=Str.Mid(6, 2);
        err += lex.Val(day);

        lex=Str.Mid(9, 2);
        err += lex.Val(hour);

        lex=Str.Mid(11, 2);
        err += lex.Val(min);

        lex=Str.Mid(13, 2);
        err += lex.Val(sec);
	
	TTime Stamp(0);
	if (err ==KErrNone) {
		TDateTime dt; 
		dt.Set(year,TMonth(month-1),day-1,hour,min,sec,0);
		Stamp=TTime(dt);
		return Stamp;
	} else {
		LeaveCannotParseValue();
	}
	return Stamp;
}

EXPORT_C void TBBTime::FromStringL(const TDesC& aString)
{
	iValue=ParseTimeL(aString);
}

EXPORT_C void TBBTime::InternalizeL(RReadStream& aStream)
{
	TInt32 low, high;
	high=aStream.ReadInt32L();
	low=aStream.ReadInt32L();
	TInt64 val(high, low);
	iValue=val;
}

EXPORT_C const TTypeName& TBBTime::Type() const
{
	return KTimeType;
}

EXPORT_C const TTypeName& TBBTime::StaticType()
{
	return KTimeType;
}

EXPORT_C TBool TBBTime::Equals(const MBBData* aRhs) const
{
	const TBBTime* rhs=bb_cast<TBBTime>(aRhs);
	return (rhs && *this == *rhs);
}

EXPORT_C void TBBUint::IntoStringL(TDes& aString) const
{
	TBuf<20> b;
	b.AppendNum(iValue);
	CheckStringSpaceL(aString, b.Length());
	aString.AppendNum(iValue);
}

EXPORT_C void TBBUint::IntoXmlL(MBBExternalizer* aBuf, TBool aIncludeType) const
{
	TBuf<15> buf;
	buf.AppendNum(iValue);

	aBuf->Field(Name(), MBBExternalizer::EInteger, buf, aIncludeType, Type());

}

EXPORT_C TBool TBBUint::Equals(const MBBData* aRhs) const
{
	const TBBUint* rhs=bb_cast<TBBUint>(aRhs);
	return (rhs && iValue==rhs->iValue);
}

EXPORT_C void TBBUint::ExternalizeL(RWriteStream& aStream) const
{
	aStream.WriteUint32L(iValue);
}

EXPORT_C void TBBUint::FromStringL(const TDesC& aString)
{
	TLex aLex; TInt err;
	if (aString.Left(2).CompareF(_L("0x"))) {
		aLex.Assign(aString);
		err=aLex.Val(iValue);
	} else {
		aLex.Assign(aString.Mid(2));
		err=aLex.Val(iValue, EHex);
	}
	if (err==KErrNone) {
		if (aLex.Remainder().Length()==0) return;
		else LeaveCannotParseValue();
	}
	if (err==KErrGeneral) LeaveCannotParseValue();
	User::Leave(err);
}

EXPORT_C void TBBUint::InternalizeL(RReadStream& aStream)
{
	iValue=aStream.ReadUint32L();
}

EXPORT_C const TTypeName& TBBUint::Type() const
{
	return KUintType;
}

EXPORT_C const TTypeName& TBBUint::StaticType()
{
	return KUintType;
}

EXPORT_C void TBBCompoundData::IntoXmlL(MBBExternalizer* aBuf, TBool aIncludeType) const
{
	aBuf->BeginCompound(Name(), aIncludeType, Type());

	TInt i=0;
	for (const MBBData *p=Part(i); p; p=Part(++i)) {
		p->IntoXmlL(aBuf, EFalse);
	}

	aBuf->EndCompound(Name());
}

EXPORT_C void TBBCompoundData::IntoStringL(TDes& aString) const
{
	TUint i=0;
	for (const MBBData *p=Part(0); p; p=Part(++i)) {
		const TDesC& sep=StringSep(i);
		CheckStringSpaceL(aString, sep.Length());
		aString.Append(sep);
		p->IntoStringL(aString);
	}
	const TDesC& sep=StringSep(i);
	CheckStringSpaceL(aString, sep.Length());
	aString.Append(sep);
}

EXPORT_C void TBBCompoundData::ExternalizeL(RWriteStream& aStream) const
{
	TUint i=0, count=0;
	const MBBData *p=0;
	for (p=Part(i); p; p=Part(++i)) {
		count=i+1;
	}
	aStream.WriteInt32L(count);
	i=0;
	for (p=Part(i); p; p=Part(++i)) {
		p->ExternalizeL(aStream);
	}
}


EXPORT_C void TBBCompoundData::FromStringL(const TDesC&)
{
	User::Leave(KErrNotSupported);
}

EXPORT_C void TBBCompoundData::InternalizeL(RReadStream& aStream)
{
	TUint i=0, count=0;
	count=aStream.ReadInt32L();
	for (MBBData *p=(MBBData *)Part(i); p && i<count; p=(MBBData *)Part(++i)) {
		p->InternalizeL(aStream);
	}
}

EXPORT_C MNestedXmlHandler* TBBCompoundData::FromXmlL(MNestedXmlHandler* aParent, CXmlParser* aParser,
				HBufC*& aBuf, TBool aCheckType)
{
	iReadParts=0;
	return new(ELeave) CPartContainerXml(aParent, aParser, aBuf, *this, aCheckType);
}

EXPORT_C void	TBBCompoundData::ReadPart(TUint aPart, TBool aErrors)
{
	if (!aErrors)
		iReadParts ^= 0x1U << aPart;
}


EXPORT_C MBBData* TBBCompoundData::GetPart(const TDesC& aName, const TTypeName&, TUint& aPartNoInto)
{
	TUint i=0;
	for (MBBData *p=(MBBData *)Part(i); p; p=(MBBData *)Part(++i)) {
		if (p->Name().Compare(aName)==0) {
			aPartNoInto=i;
			return p;
		}
	}
	return 0;
}


EXPORT_C void TBBFixedLengthStringBase::IntoXmlL(MBBExternalizer* aBuf, TBool aIncludeType) const 
{
	aBuf->Field(Name(), MBBExternalizer::EString, Value(), aIncludeType, Type());
}

EXPORT_C void TBBFixedLengthStringBase::IntoStringL(TDes& aString) const 
{
	CheckStringSpaceL(aString, Value().Length());
	aString.Append(Value());
}

EXPORT_C void TBBFixedLengthStringBase::ExternalizeL(RWriteStream& aStream) const 
{
	aStream.WriteInt32L(Value().Length());
	if (Value().Length()>0) {
		aStream.WriteL(Value());
	}
}

EXPORT_C void TBBFixedLengthStringBase::FromStringL(const TDesC& aString) 
{
	if (aString.Length()>Value().MaxLength()) User::Leave(KStringTooLong);
	Value()=aString;
}

EXPORT_C void TBBFixedLengthStringBase::InternalizeL(RReadStream& aStream) 
{
	TInt aLen=aStream.ReadInt32L();
	if (aLen > Value().MaxLength()) User::Leave(KStringTooLong);
	if (aLen>0) 
		aStream.ReadL(Value(), aLen);
	else
		Value().Zero();
}

EXPORT_C void TBBFixedLengthStringBase8::IntoXmlL(MBBExternalizer* aBuf, TBool aIncludeType) const 
{
	auto_ptr<HBufC> buf(HBufC::NewL(Value().Length()*2));

	TPtr p(buf->Des());
	IntoStringL(p);
	aBuf->Field(Name(), MBBExternalizer::EBinary, *buf, aIncludeType, Type());
}

EXPORT_C void TBBFixedLengthStringBase8::IntoStringL(TDes& aString) const 
{
	CheckStringSpaceL(aString, Value().Length()*2);
	TBuf<4> hex, b;
	const TDesC8& val=Value();
	for (TInt i=0; i<val.Length(); i++) {
		hex.Num( val[i], EHex );
		if (hex.Length()==1) b=_L("0");
		else b.Zero();
		b.Append(hex);
		aString.Append(b);
	}
}

EXPORT_C void TBBFixedLengthStringBase8::ExternalizeL(RWriteStream& aStream) const 
{
	aStream.WriteInt32L(Value().Length());
	if (Value().Length()>0)
		aStream.WriteL(Value());
}

EXPORT_C void TBBFixedLengthStringBase8::FromStringL(const TDesC& aString) 
{
	if (aString.Length()/2 > Value().MaxLength()) User::Leave(KStringTooLong);

	TDes8& val=Value();
	val.Zero();

	TBuf<2> hex;
	for (TInt i=0; i<aString.Length(); i+=2) {
		TUint8 c;
		hex=aString.Mid(i, 2);
		TLex l(hex);
		User::LeaveIfError( l.Val(c, EHex) );
		val.Append(c);
	}
}

EXPORT_C void TBBFixedLengthStringBase8::InternalizeL(RReadStream& aStream) 
{
	TInt aLen=aStream.ReadInt32L();
	if (aLen > Value().MaxLength()) User::Leave(KStringTooLong);
	if (aLen>0)
		aStream.ReadL(Value(), aLen);
	else
		Value().Zero();
}


EXPORT_C void TBBUid::IntoXmlL(MBBExternalizer* aBuf, TBool aIncludeType) const
{
	TBuf<15> buf=_L("0x");
	buf.AppendNum(iValue, EHex);
	aBuf->Field(Name(), MBBExternalizer::EInteger, buf, aIncludeType, Type());
}

EXPORT_C void TBBUid::IntoStringL(TDes& aString) const
{
	TBuf<20> b=_L("0x");
	b.AppendNum(iValue, EHex);
	CheckStringSpaceL(aString, b.Length());
	aString.Append(b);
}

EXPORT_C const TTypeName& TBBUid::Type() const
{
	return KUidType;
}

EXPORT_C TBool TBBUid::Equals(const MBBData* aRhs) const
{
	const TBBUid* rhs=bb_cast<TBBUid>(aRhs);
	return (rhs && *this==*rhs);
}

EXPORT_C const TTypeName& TBBUid::StaticType()
{
	return KUidType;
}

EXPORT_C const TTypeName& TBBLongString::Type() const
{
	return KLongStringType;
}

EXPORT_C const TTypeName& TBBLongString::StaticType()
{
	return KLongStringType;
}

EXPORT_C TBool TBBLongString::Equals(const MBBData* aRhs) const
{
	const TBBLongString* rhs=bb_cast<TBBLongString>(aRhs);
	return (rhs && *this==*rhs);
}

EXPORT_C CBBString* CBBString::NewL(const TDesC& aName, const TInt aSize)
{
	auto_ptr<CBBString> ret(new (ELeave) CBBString(aName));
	ret->ConstructL(aSize);
	return ret.release();
}

EXPORT_C CBBString::CBBString(const TDesC& aName): TBBFixedLengthStringBase(aName), iPtr(0, 0) { }

EXPORT_C void CBBString::Zero()
{
	iBuf->Des().Zero();
	iPtr.Set(iBuf->Des());
}

EXPORT_C void CBBString::Append(const TDesC& aStr)
{
	while ( iBuf->Des().Length() + aStr.Length() > iBuf->Des().MaxLength() ) {
		iBuf=iBuf->ReAllocL(iBuf->Des().MaxLength() * 2);
	}
	iBuf->Des().Append(aStr);
	iPtr.Set(iBuf->Des());
}

EXPORT_C const TTypeName& CBBString::Type() const
{
	return KStringType;
}

EXPORT_C const TTypeName& CBBString::StaticType()
{
	return KStringType;
}


EXPORT_C TBool CBBString::Equals(const MBBData* aRhs) const
{
	const CBBString* rhs=bb_cast<CBBString>(aRhs);
	return (rhs && *this==*rhs);
}

EXPORT_C void CBBString::FromStringL(const TDesC& aString)
{
	iBuf->Des().Zero();
	Append(aString);
}

EXPORT_C void CBBString::InternalizeL(RReadStream& aStream)
{
	iBuf->Des().Zero();
	TInt aLen=aStream.ReadInt32L();
	if (aLen > iBuf->Des().MaxLength() ) {
		iBuf=iBuf->ReAllocL(aLen);
	}
	iPtr.Set(iBuf->Des());
	aStream.ReadL(iPtr, aLen);
}

EXPORT_C void CBBString::ConstructL(TInt aSize)
{
	iBuf=HBufC::NewL(aSize);
	iPtr.Set(iBuf->Des());
}

CBBString::~CBBString()
{
	delete iBuf;
}

EXPORT_C CBBString8* CBBString8::NewL(const TDesC& aName, const TInt aSize)
{
	auto_ptr<CBBString8> ret(new (ELeave) CBBString8(aName));
	ret->ConstructL(aSize);
	return ret.release();
}

EXPORT_C void CBBString8::Zero()
{
	iBuf->Des().Zero();
}

EXPORT_C void CBBString8::Append(const TDesC8& aStr)
{
	while ( iBuf->Des().Length() + aStr.Length() > iBuf->Des().MaxLength() ) {
		iBuf=iBuf->ReAllocL(iBuf->Des().MaxLength() * 2);
	}
	iBuf->Des().Append(aStr);
	iPtr.Set(iBuf->Des());
}

EXPORT_C const TTypeName& CBBString8::Type() const
{
	return KString8Type;
}

EXPORT_C const TTypeName& CBBString8::StaticType()
{
	return KString8Type;
}


EXPORT_C TBool CBBString8::Equals(const MBBData* aRhs) const
{
	const CBBString8* rhs=bb_cast<CBBString8>(aRhs);
	return (rhs && *this==*rhs);
}

EXPORT_C void CBBString8::FromStringL(const TDesC8& aString)
{
	iBuf->Des().Zero();
	Append(aString);
}

EXPORT_C void CBBString8::InternalizeL(RReadStream& aStream)
{
	iBuf->Des().Zero();
	TInt aLen=aStream.ReadInt32L();
	if (aLen > iBuf->Des().MaxLength() ) {
		iBuf=iBuf->ReAllocL(aLen);
	}
	iPtr.Set(iBuf->Des());
	aStream.ReadL(iPtr, aLen);
}

void CBBString8::ConstructL(TInt aSize)
{
	iBuf=HBufC8::NewL(aSize);
	iPtr.Set(iBuf->Des());
}

CBBString8::~CBBString8()
{
	delete iBuf;
}

EXPORT_C MBBData* CBBString8::CloneL(const TDesC& Name) const
{
	CBBString8* ret=CBBString8::NewL(Name, iBuf->Size());
	ret->Value()=Value();
	return ret;
}

//--


EXPORT_C MBBData* TBBInt::CloneL(const TDesC& Name) const
{
	return new (ELeave) TBBInt(iValue, Name);
}

EXPORT_C MBBData* TBBShortString::CloneL(const TDesC& Name) const
{
	return new (ELeave) TBBShortString(iValue, Name);
}

EXPORT_C MBBData* TBBLongString::CloneL(const TDesC& Name) const
{
	return new (ELeave) TBBLongString(iValue, Name);
}

EXPORT_C MBBData* TBBBool::CloneL(const TDesC& Name) const
{
	return new (ELeave) TBBBool(iValue, Name);
}

EXPORT_C MBBData* TBBTime::CloneL(const TDesC& Name) const
{
	return new (ELeave) TBBTime(iValue, Name);
}

EXPORT_C MBBData* TBBUint::CloneL(const TDesC& Name) const
{
	return new (ELeave) TBBUint(iValue, Name);
}

EXPORT_C MBBData* TBBUid::CloneL(const TDesC& Name) const
{
	return new (ELeave) TBBUid(iValue, Name);
}

EXPORT_C MBBData* CBBString::CloneL(const TDesC& Name) const
{
	CBBString* ret=CBBString::NewL(Name, iBuf->Length());
	ret->Value()=Value();
	return ret;
}

EXPORT_C void TBBInt64::IntoStringL(TDes& aString) const
{
	TBuf<20> b;
	b.AppendNum(iValue);
	CheckStringSpaceL(aString, b.Length());
	aString.AppendNum(iValue);
}

EXPORT_C void TBBInt64::IntoXmlL(MBBExternalizer* aBuf, TBool aIncludeType) const
{
	TBuf<30> buf;
	buf.AppendNum(iValue);
	aBuf->Field(Name(), MBBExternalizer::EInteger, buf, aIncludeType, Type());
}

EXPORT_C TBool TBBInt64::Equals(const MBBData* aRhs) const
{
	const TBBInt64* rhs=bb_cast<TBBInt64>(aRhs);
	return (rhs && iValue==rhs->iValue);
}

EXPORT_C void TBBInt64::ExternalizeL(RWriteStream& aStream) const
{
	aStream.WriteInt32L(iValue.Low());
	aStream.WriteInt32L(iValue.High());
}

EXPORT_C void TBBInt64::FromStringL(const TDesC& aString)
{
	TLex aLex; TInt err;
	if (aString.Left(2).CompareF(_L("0x"))) {
		aLex.Assign(aString);
		err=aLex.Val(iValue);
	} else {
		aLex.Assign(aString.Mid(2));
		err=aLex.Val(iValue, EHex);
	}
	if (err==KErrNone) {
		if (aLex.Remainder().Length()==0) return;
		else 
			LeaveCannotParseValue();
	}
	if (err==KErrGeneral) 
		LeaveCannotParseValue();
	User::Leave(err);
}

EXPORT_C void TBBInt64::InternalizeL(RReadStream& aStream)
{
	TInt32 low, high;
	low=aStream.ReadInt32L();
	high=aStream.ReadInt32L();
	iValue=TInt64(high, low);
}

EXPORT_C const TTypeName& TBBInt64::Type() const
{
	return KInt64Type;
}

EXPORT_C const TTypeName& TBBInt64::StaticType()
{
	return KInt64Type;
}

EXPORT_C MBBData* TBBInt64::CloneL(const TDesC& Name) const
{
	return new (ELeave) TBBInt64(iValue, Name);
}

EXPORT_C const TTypeName& TBBShortString8::Type() const
{
	return KShortString8Type;
}

EXPORT_C const TTypeName& TBBShortString8::StaticType()
{
	return KShortString8Type;
}

EXPORT_C TBool TBBShortString8::Equals(const MBBData* aRhs) const
{
	const TBBShortString8* rhs=bb_cast<TBBShortString8>(aRhs);
	return (rhs && *rhs==*this);
}
EXPORT_C MBBData* TBBShortString8::CloneL(const TDesC& Name) const
{
	TBBShortString8* ret=new (ELeave) TBBShortString8(Name);
	ret->iValue=iValue;
	return ret;
}


EXPORT_C const TTypeName& TBBTupleName::Type() const
{
	return KTupleNameType;
}

EXPORT_C TBool TBBTupleName::Equals(const MBBData* aRhs) const
{
	const TBBTupleName* rhs=bb_cast<TBBTupleName>(aRhs);
	return (rhs && *this==*rhs);
}

EXPORT_C const TTypeName& TBBTupleName::StaticType()
{
	return KTupleNameType;
}

EXPORT_C const MBBData* TBBTupleName::Part(TUint aPartNo) const
{
	switch(aPartNo) {
	case 0:
		return &iModuleUid;
	case 1:
		return &iModuleId;
	default:
		return 0;
	}
}

_LIT(KModuleUid, "module_uid");
_LIT(KModuleId, "module_id");
_LIT(KSpace, " ");

EXPORT_C TBBTupleName::TBBTupleName(const TDesC& aName) : TBBCompoundData(aName),
	iModuleUid(KModuleUid), iModuleId(KModuleId) { }

EXPORT_C TBBTupleName::TBBTupleName(const TDesC& aName, TInt aModuleUid, TInt aModuleId) :
	TBBCompoundData(aName), iModuleUid(aModuleUid, KModuleUid), iModuleId(aModuleId, KModuleUid) { }

EXPORT_C bool TBBTupleName::operator==(const TBBTupleName& aRhs) const
{
	return (iModuleUid==aRhs.iModuleUid && iModuleId==aRhs.iModuleId);
}

const TDesC& TBBTupleName::StringSep(TUint ) const
{
	return KSpace;
}

EXPORT_C TBBTupleName& TBBTupleName::operator=(const TBBTupleName& aNameData)
{
	iModuleUid()=aNameData.iModuleUid();
	iModuleId()=aNameData.iModuleId();

	return *this;
}

EXPORT_C TBBTupleName& TBBTupleName::operator=(const TTupleName& aNameData)
{
	iModuleUid()=aNameData.iModule.iUid;
	iModuleId()=aNameData.iId;

	return *this;
}

EXPORT_C MBBData* TBBTupleName::CloneL(const TDesC& Name) const
{
	TBBTupleName* ret=new (ELeave) TBBTupleName(Name);
	*ret=*this;
	return ret;
}

EXPORT_C const TTypeName& TBBComponentName::Type() const
{
	return KComponentNameType;
}

EXPORT_C TBool TBBComponentName::Equals(const MBBData* aRhs) const
{
	const TBBComponentName* rhs=bb_cast<TBBComponentName>(aRhs);
	return *rhs==*this;
}

EXPORT_C const TTypeName& TBBComponentName::StaticType()
{
	return KComponentNameType;
}

EXPORT_C TBBComponentName::TBBComponentName(const TDesC& aName) : TBBTupleName(aName) { }

EXPORT_C TBBComponentName::TBBComponentName(const TDesC& aName, TInt aModuleUid, TInt aModuleId) :
	TBBTupleName(aName, aModuleUid, aModuleId) { }

EXPORT_C TBBComponentName& TBBComponentName::operator=(const TComponentName& aNameData)
{
	iModuleUid()=aNameData.iModule.iUid;
	iModuleId()=aNameData.iId;

	return *this;	
}

EXPORT_C MBBData* TBBComponentName::CloneL(const TDesC& Name) const
{
	TBBComponentName* ret=new (ELeave) TBBComponentName(Name);
	*ret=*this;
	return ret;
}
