#include "bbdata.h"
#include "bbtypes.h"
#include "concretedata.h"
#include "bblist.h"

_LIT(KDefaultStringSep, " ");

class TConcreteDataFactory : public MBBDataFactory {
	virtual MBBData* CreateBBDataL(const TTypeName& aType, const TDesC& aName, MBBDataFactory* aTopLevelFactory) {
		if (aType==KIntType) {
			return new (ELeave) TBBInt(aName);
		} else if (aType==KShortStringType) {
			return new (ELeave) TBBShortString(aName);
		} else if (aType==KListType) {
			return CBBGenericList::NewL(aName, aName, KDefaultStringSep, aTopLevelFactory);
		} else if (aType==KBoolType) {
			return new (ELeave) TBBBool(aName);
		} else if (aType==KTimeType) {
			return new (ELeave) TBBTime(aName);
		} else if (aType==KUintType) {
			return new (ELeave) TBBUint(aName);
		} else if (aType==KGeneralType) {
			return new (ELeave) CBBGeneralHolder(aTopLevelFactory);
		} else if (aType==KUidType) {
			return new (ELeave) TBBUid(aName);
		} else if (aType==KLongStringType) {
			return new (ELeave) TBBLongString(aName);
		} else if (aType==KStringType) {
			return CBBString::NewL(aName);
		} else if (aType==KString8Type) {
			return CBBString8::NewL(aName);
		} else if (aType==KInt64Type) {
			return new (ELeave) TBBInt64(aName);
		} else if (aType==KShortString8Type) {
			return new (ELeave) TBBShortString8(aName);

		} else {
			User::Leave(KErrNotSupported);
		}
		return 0;
	}
	virtual ~TConcreteDataFactory() { }
	virtual void ConstructL() { }
};

EXPORT_C MBBDataFactory* CreateDataFactory()
{
	return new TConcreteDataFactory;
}
