#include "bbtypes.h"
#include "concretedata.h"
#include "bberrors.h"
#include "bbutil.h"
#include "bbxml.h"

const TTypeName KPairType = { KBBUidValue, 1002, 1, 0 };
_LIT(KFirst, "first");
_LIT(KSecond, "second");

class TBBPair : public MBBData {
public:
	const TDesC&		iName;

	TBBInt			iIntVal;
	TBBShortString		iStringVal;

        virtual void		IntoStringL(TDes& aString) const;
	virtual void		IntoXmlL(MBBExternalizer* aBuf, TBool aIncludeType=ETrue) const;
	virtual void		ExternalizeL(RWriteStream& aStream) const;

        virtual void		FromStringL(const TDesC& aString);
	virtual MNestedXmlHandler*	FromXmlL(MNestedXmlHandler* aParent, CXmlParser* aParser,
					HBufC*& aBuf, TBool aCheckType=ETrue);
	virtual void		InternalizeL(RReadStream& aStream);
	virtual const TDesC&	Name() const;
	virtual MBBData*	CloneL(const TDesC& aName) const; 

        virtual const TTypeName& Type() const;
	TBool Equals(const MBBData* aRhs) const;

	TBBPair(const TDesC& aName) : iName(aName), iIntVal(KFirst), iStringVal(KSecond) { }
	TBBPair(TInt aIntValue, const TDesC& aStringVal, const TDesC& aName) : iName(aName), iIntVal(aIntValue, KFirst), iStringVal(aStringVal, KSecond) { }
	TBBPair& operator=(const TBBPair aValue) { iIntVal=aValue.iIntVal.iValue; iStringVal=aValue.iStringVal.iValue; return *this; }
	bool operator==(const TBBPair& aRhs) const  { return iIntVal==aRhs.iIntVal &&
		iStringVal==aRhs.iStringVal; }
};

class CPairXml : public CContainerXml {
public:
	CPairXml(MNestedXmlHandler* aParent, CXmlParser* aParser,
		HBufC*& aBuf, TBBPair& aValue, TBool aCheckType) : 
		CContainerXml(aParent, aParser, aBuf, aValue, aCheckType), iPairValue(aValue) { }
private:
	TBBPair& iPairValue;
	virtual void StartInnerElementL(const XML_Char *name, const XML_Char **atts) {
		TPtrC namep(name);
		if (! namep.Compare(_L("first")) ) {
			SetCurrentHandler( iPairValue.iIntVal.FromXmlL(this, iParser,
				iBuf, iCheckType) );
			GetCurrentHandler()->StartElement(name, atts);
		} else if (! namep.Compare(_L("second")) ) {
			SetCurrentHandler( iPairValue.iStringVal.FromXmlL(this, iParser,
				iBuf, iCheckType) );
			GetCurrentHandler()->StartElement(name, atts);
		} else {
			User::Leave(KUnexpectedElement);
		}
	}

	virtual void EndInnerElementL(const XML_Char * /*name*/) {
	}

	virtual void Error(XML_Error Code, const XML_LChar * /*String*/, long /*ByteIndex*/) {
		SetError(Code);
	}
	virtual void SetError(TInt aError) {
		User::Leave(aError);
	}
};

MBBData* TBBPair::CloneL(const TDesC& aName) const
{
	TBBPair* p=new (ELeave) TBBPair(aName);
	p->iIntVal()=iIntVal();
	p->iStringVal()=iStringVal();
	return p;
}

void TBBPair::IntoStringL(TDes& aString) const
{
	iIntVal.IntoStringL(aString);
	CheckStringSpaceL(aString, 1);
	aString.Append(_L(" "));
	iStringVal.IntoStringL(aString);
}

void TBBPair::IntoXmlL(MBBExternalizer* aBuf, TBool aIncludeType) const
{
	aBuf->BeginCompound(Name(), aIncludeType, Type());
	iIntVal.IntoXmlL(aBuf, aIncludeType);
	iStringVal.IntoXmlL(aBuf, aIncludeType);
	aBuf->EndCompound(Name());
}

void TBBPair::ExternalizeL(RWriteStream& aStream) const
{
	iIntVal.ExternalizeL(aStream);
	iStringVal.ExternalizeL(aStream);
}

void TBBPair::FromStringL(const TDesC& aString)
{
	TLex aLex(aString);
	aLex.Mark();
	aLex.SkipCharacters();
	iIntVal.FromStringL(aLex.MarkedToken());
	aLex.SkipSpace();
	aLex.Mark();
	iStringVal.FromStringL(aLex.RemainderFromMark());
}

MNestedXmlHandler* TBBPair::FromXmlL(MNestedXmlHandler* aParent, CXmlParser* aParser, HBufC*& aBuf, TBool aCheckType)
{
	return new(ELeave) CPairXml(aParent, aParser, aBuf, *this, aCheckType);
}

void TBBPair::InternalizeL(RReadStream& aStream)
{
	iIntVal.InternalizeL(aStream);
	iStringVal.InternalizeL(aStream);
}

const TTypeName& TBBPair::Type() const
{
	return KPairType;
}

const TDesC& TBBPair::Name() const
{
	return iName;
}

TBool TBBPair::Equals(const MBBData* aRhs) const
{
	if (!aRhs) return EFalse;
	if (aRhs->Type() == Type() ) return EFalse;
	const TBBPair* rhs=static_cast<const TBBPair*>(aRhs);
	return (iIntVal==rhs->iIntVal && iStringVal==rhs->iStringVal);
}
