#include "testdriver_bbdata_base.cpp"

#include "test_pair.cpp"
#include "bblist.h"

_LIT(KTestInt, "TestInt");
_LIT(KTestSS, "TestSS");
_LIT(KTestShortString, "TestSS");

void bbint()
{
	TBBInt t(1, KTestInt);
	test_conversions(1, t, _L("1"), _L("<x>1</x>"), _L(""), _L("x"), 1);
	test_conversions(3, t, _L("2"), _L("<x>2</x>"), _L(""), _L("x"), 2, false);

	int END=-2;
	int tests[]={ INT_MIN, -1023984, -56, -1, 0, 1, 2, 3, 14, 90849, INT_MAX, END };
	int i=0;
	while (tests[i]!=END) {
		TBuf<15> b; b.AppendNum(tests[i]);
		TBuf<25> xml1=_L("<x>");
		xml1.AppendNum(tests[i]);
		xml1.Append(_L("</x>"));
		TBuf<100> xml2=_L("<x module=\"0x1020811a\" id=\"1\" major_version=\"1\" minor_version=\"0\">");
		xml2.AppendNum(tests[i]);
		xml2.Append(_L("</x>"));
		
		test_conversions(tests[i], t, b, xml1, xml2, _L("x"), i+3);
		++i;
	}

	CTestXml* tx=0;
	CXmlParser* p=0;
	TBBInt t2(_L("TestInt"));

	_LIT(xml41, "<?xml version='1.0'?><TestInt module=\"0x1020811a\" id=\"1\" major_version=\"1\" minor_version=\"0\">14aa</TestInt>");
	tx=CTestXml::NewL(&t2, 0);
	p=CXmlParser::NewL(*tx);
	tx->SetParser(p);
	TRAPD(err41, p->Parse( (char*)(xml41().Ptr()), xml41().Size(), 1));
	TEST_EQUALS(err41, KCannotParseValue, _L("bbint:8"));
	delete p;
	delete tx;

	_LIT(xml42, "<?xml version='1.0'?><TestInt module=\"0x1020811a\" id=\"1\" major_version=\"1\" minor_version=\"0\">aa14</TestInt>");
	tx=CTestXml::NewL(&t2, 0);
	p=CXmlParser::NewL(*tx);
	tx->SetParser(p);
	TRAPD(err42, p->Parse( (char*)(xml42().Ptr()), xml42().Size(), 1));
	TEST_EQUALS(err42, KCannotParseValue, _L("bbint:8:0"));
	delete p;
	delete tx;

	_LIT(xml5, "<?xml version='1.0'?><TestInt module=\"0x1\" id=\"1\" major_version=\"1\" minor_version=\"0\">14</TestInt>");
	tx=CTestXml::NewL(&t2, 0);
	p=CXmlParser::NewL(*tx);
	tx->SetParser(p);
	TRAPD(err5, p->Parse( (char*)(xml5().Ptr()), xml5().Size(), 1));
	TEST_EQUALS(KTypeDoesNotMatch, err5, _L("bbint:8:1"));
	delete p;
	delete tx;

	TBuf<1> bsmall;
	TRAPD(err6, t2.IntoStringL(bsmall));
	TEST_EQUALS(KErrOverflow, err6, _L("bbint:9:0"));
	t2=1;
	TRAP(err6, t2.IntoStringL(bsmall));
	TEST_EQUALS(KErrNone, err6, _L("bbint:9:1"));
}

void bbbool()
{
	TBBBool t(ETrue, KTestInt);
	test_conversions(ETrue, t, _L("true"), _L("<x>true</x>"), _L(""), _L("x"), 1);
	t.iValue=EFalse;
	test_conversions(EFalse, t, _L("false"), _L("<x>false</x>"), _L(""), _L("x"), 2);
	t.iValue=ETrue;
	test_conversions(ETrue, t, _L("false"), _L("<x>false</x>"), _L(""), _L("x"), 3, false);
}

void bbshortstring()
{
	TBBShortString t(KTestSS);

	TBuf<50> tb=t();
	t()=tb;

	test_conversions(_L("jonohan tm"), t, _L("jonohan tm"), _L("<x>jonohan tm</x>"), _L(""), _L("x"), 1);
	test_conversions(_L("jonohan t,m"), t, _L("jonohan tm"), _L("<x>jonohan tm</x>"), _L(""), _L("x"), 2, false);
	
	int END=-2;
	int tests[]={ 0, 1, 3, 49, 50, END };
	int i=0;
	while (tests[i]!=END) {
		TBuf<60> val; val.Fill('y', tests[i]);
		TBuf<70> xml1;
		TBuf<200> xml2;
		xml1=_L("<x>"); xml1.Append(val); xml1.Append(_L("</x>"));
		xml2=_L("<x module=\"0x1020811a\" id=\"2\" major_version=\"1\" minor_version=\"0\">");
		xml2.Append(val);
		xml2.Append(_L("</x>"));
		test_conversions(val, t, val, xml1, xml2, _L("x"), i+3);
		++i;
	}

	TBuf<1> bsmall;
	t=_L("bi");
	TRAPD(err6, t.IntoStringL(bsmall));
	TEST_EQUALS(KErrOverflow, err6, _L("bbss:9:0"));

	TBuf<2> bsmall2;
	t=_L("bi");
	TRAPD(err7, t.IntoStringL(bsmall2));
	TEST_EQUALS(KErrNone, err7, _L("bbss:9:1"));
}

#define BBPAIR_TESTS 2

void bbpair_inner(TInt test_num)
{
	_LIT(KPair, "pair");
	TBuf<30> test_name=_L("bbpair:"); test_name.AppendNum(test_num);
	TBBPair t(30, _L("string"), KPair);
	if (test_num==0) {
		TBuf<40> b;
		t.IntoStringL(b);
		TEST_EQUALS(b, _L("30 string"), test_name);
	} else if (test_num==1) {
		TBuf<100> xml=_L("<pair><first>30</first><second>string</second></pair>");
		test_conversions_inner_nonative(t, _L("30 string"), xml, _L(""), _L("pair"), test_num);
			
	}
}

void bbpair()
{
	TInt test_num=0;
	TBuf<30> num;
	for (test_num=0; test_num < BBPAIR_TESTS; test_num++) {
		TInt err=KErrNoMemory;
		TInt fail_on=1;
		while (err==KErrNoMemory) {
			User::__DbgSetAllocFail(RHeap::EUser, RHeap::EDeterministic, fail_on);
			User::__DbgMarkStart(RHeap::EUser);
			TRAP(err, bbpair_inner(test_num));
			User::__DbgMarkEnd(RHeap::EUser,0);
			User::__DbgSetAllocFail(RHeap::EUser, RHeap::ENone, 1);
			++fail_on;
		}
		User::__DbgSetAllocFail(RHeap::EUser, RHeap::ENone, 1);
		num=_L("bbpair:memfail:"); num.AppendNum(test_num);
		TEST_EQUALS(err, KErrNone, num);
	}
}

void bbfactory_inner(TInt test_num, CBBDataFactory* f)
{
	_LIT(name, "ti");

	MBBData* d=f->CreateBBDataL(KIntType, name, 0);
	CleanupPushBBDataL(d);

	TBuf8<200> des;
	
	TBBInt wr(12, name);
	RDesWriteStream ws(des);
	CleanupClosePushL(ws);
	wr.Type().ExternalizeL(ws);
	wr.ExternalizeL(ws);
	ws.CommitL();
	CleanupStack::PopAndDestroy();

	RDesReadStream rs(des);
	CleanupClosePushL(rs);	
	TTypeName read_type=TTypeName::IdFromStreamL(rs);
	d->InternalizeL(rs);
	CleanupStack::PopAndDestroy();

	TBuf8<200> des2;
	RDesWriteStream ws2(des2);
	CleanupClosePushL(ws2);
	d->Type().ExternalizeL(ws2);
	d->ExternalizeL(ws2);
	ws2.CommitL();
	CleanupStack::PopAndDestroy();

	TEST_EQUALS(d->Type(), read_type, _L("bbfac:0"));
	TEST_EQUALS(TBinMatch8(des), TBinMatch8(des2), _L("bbfac:1"));

	CleanupStack::PopAndDestroy();
}

void bbfactory()
{
	TInt test_num=0;
	TBuf<30> num;
	CBBDataFactory* f=0;
	for (test_num=0; test_num < BBPAIR_TESTS; test_num++) {
		TInt err=KErrNoMemory;
		TInt fail_on=1;
		while (err==KErrNoMemory) {
			User::__DbgSetAllocFail(RHeap::EUser, RHeap::EDeterministic, fail_on);

			User::__DbgMarkStart(RHeap::EUser);
			TRAP(err, f=CBBDataFactory::NewL());
			if (err==KErrNone) TRAP(err, bbfactory_inner(test_num, f));
			//if (f) f->Reset();
			delete f; f=0;
			User::__DbgMarkEnd(RHeap::EUser,0);

			User::__DbgSetAllocFail(RHeap::EUser, RHeap::ENone, 1);
			++fail_on;
		}
		User::__DbgSetAllocFail(RHeap::EUser, RHeap::ENone, 1);
		num=_L("bbpair:memfail:"); num.AppendNum(test_num);
		TEST_EQUALS(err, KErrNone, num);
	}
	delete f;
}

void bblist_inner(TInt maxsize)
{
	_LIT(KListName, "list");
	_LIT(KSep, " ");
	
	TInt len[]={0, 1, 2, 3, 1000, -1};
	TInt i=0;
	state=_L("bblist::bbfac");
	auto_ptr<CBBDataFactory> fp(CBBDataFactory::NewL());
	CBBDataFactory* f=fp.get();
	while (len[i]>=0 && len[i]<maxsize) {
		state=_L("bblist::create1::"); state.AppendNum(len[i]);
		auto_ptr<CBBGenericList> l(CBBGenericList::NewL(KListName, KListName, KSep, f));
		TInt j;
		state=_L("bblist::add_items::"); state.AppendNum(len[i]);
		for (j=0; j<len[i]; j++) {
			MBBData* d=new (ELeave) TBBInt(15, KListName);
			CleanupPushBBDataL(d);
			l->AddItemL(0, d);
			CleanupStack::Pop();
		}
		TEST_EQUALS(l->Count(), len[i], state);
		state=_L("bblist::create2::"); state.AppendNum(len[i]);
		auto_ptr<CBBGenericList> l2(CBBGenericList::NewL(KListName, KListName, KSep, f));

		{
			auto_ptr<HBufC8> desp(HBufC8::NewL(20*1000+100));
			TPtr8 des=desp->Des();
			
			state=_L("bblist::write::"); state.AppendNum(len[i]);
			RDesWriteStream ws(des);
			CleanupClosePushL(ws);
			l->ExternalizeL(ws);
			CleanupStack::PopAndDestroy();

			RDesReadStream rs(des);
			CleanupClosePushL(rs);	
			l2->InternalizeL(rs);
			CleanupStack::PopAndDestroy();
		}
		state=_L("bblist::comp1::"); state.AppendNum(len[i]);
		TEST_EQUALS(l2->Count(), len[i], state);
		state=_L("bblist::comp2::"); state.AppendNum(len[i]);
		TEST_EQUALS(*l, *l2, state);
		{
			state=_L("bblist::xml1::"); state.AppendNum(len[i]);
			auto_ptr<CXmlBufExternalizer> buf(CXmlBufExternalizer::NewL(200*1000));
			l->IntoXmlL(buf.get(), EFalse);
			auto_ptr<CBBGenericList> l3(CBBGenericList::NewL(KListName, KListName, KSep, f));

			state=_L("bblist::xml2::"); state.AppendNum(len[i]);
			auto_ptr<CTestXml> tx(CTestXml::NewL(l3.get(), 0, false));
			auto_ptr<CXmlParser> p(CXmlParser::NewL(*tx));
			tx->SetParser(p.get());
			p->Parse( (char*)(buf->Buf().Ptr()), buf->Buf().Size(), 1);

			state=_L("bblist::comp_xml::"); state.AppendNum(len[i]);
			TEST_EQUALS(*l, *l3, state);
		}

		i++;
	}
}

class RunList : public MRunnable
{
public:
	TInt maxsize;
	virtual void run() {  bblist_inner(maxsize); }
};


void bblist()
{
	User::__DbgMarkStart(RHeap::EUser);

	RunList r;
	r.maxsize=2000;
	r.run();

	User::__DbgMarkEnd(RHeap::EUser,0);

	r.maxsize=15;
	test_oom(r);
}

void run_tests()
{
	User::__DbgMarkStart(RHeap::EUser);
	{
		output=new (ELeave) MOutput;

		RAFs fs; fs.ConnectLA();
		output->foutput.Replace(fs, _L("blackboardtest.txt"), EFileWrite);

		output->cons=Console::NewL(_L("test"),TSize(KConsFullScreen, KConsFullScreen));
		TInt err;
		TRAP(err, bbbool());
		TEST_EQUALS(err, KErrNone, state);

		TRAP(err, bblist());
		TEST_EQUALS(err, KErrNone, state);

		TRAP(err, bbfactory());
		TEST_EQUALS(err, KErrNone, _L("bbfactory all"));

		TRAP(err, bbint());
		TEST_EQUALS(err, KErrNone, _L("bbint all"));
		TRAP(err, bbshortstring());
		TEST_EQUALS(err, KErrNone, _L("bbshortstring all"));
		TRAP(err, bbpair());
		TEST_EQUALS(err, KErrNone, _L("bbpair all"));

		TBuf<30> b=_L("OK: "); b.AppendNum(ok); 
		b.Append(_L("/")); b.AppendNum(ok+not_ok); b.Append(_L("\n"));
		output->Write(b);
		output->Getch();
		delete output->cons;

		output->foutput.Close();
		delete output;
	}
	User::__DbgMarkEnd(RHeap::EUser,0);
}
