#pragma warning(disable: 4800)

#include <e32cons.h>
#include "xml.h"
#include <limits.h>
#include "symbian_auto_ptr.h"
#include "concretedata.h"
#include "bblist.h"

class MOutput {
public:
	CConsoleBase* cons;
	RFile	foutput;

	void Write(const TDesC& str) {
		cons->Write(str);
		TInt len=str.Length()*2;
		TPtrC8 p( (const TUint8*)str.Ptr(), len );
		foutput.Write(p);
		foutput.Flush();
	}
	void Getch() {
		cons->Getch();
	}
};

MOutput* output=0;

TInt ok=0;
TInt not_ok=0;

TBuf<100> state;

template<typename T>
bool operator!=(const T& aLhs, const T& aRhs) { return !(aLhs==aRhs); }

void WRITE_VALUES(const TDesC& lhs, const TDesC& rhs) {
	output->Write(lhs);
	output->Write(_L(" "));
	output->Write(rhs);
}
void WRITE_VALUES(const MBBData& lhs, const MBBData& rhs) {
	TBuf<200> b=_L("|");
	TRAPD(err, lhs.IntoStringL(b));
	output->Write(b);
	output->Write(_L("| |"));
	b.Zero();
	TRAP(err, rhs.IntoStringL(b));
	b.Append(_L("|"));
	output->Write(b);
}
void WRITE_VALUES(const TTypeName& lhs, const TTypeName& rhs) {
	TBuf<200> b;
	b=_L("[");
	b.AppendNum((TInt)lhs.iModule.iUid); b.Append(_L(" "));
	b.AppendNum(lhs.iId); b.Append(_L(" "));
	b.AppendNum(lhs.iMajorVersion); b.Append(_L(" "));
	b.AppendNum(lhs.iMinorVersion); b.Append(_L("]"));
	output->Write(b);

	output->Write(_L(" "));

	b=_L("[");
	b.AppendNum((TInt)rhs.iModule.iUid); b.Append(_L(" "));
	b.AppendNum(rhs.iId); b.Append(_L(" "));
	b.AppendNum(rhs.iMajorVersion); b.Append(_L(" "));
	b.AppendNum(rhs.iMinorVersion); b.Append(_L("]"));
	output->Write(b);
}
void WRITE_VALUES(const int& lhs, const int& rhs) {
	TBuf<15> b;
	b.AppendNum(lhs);
	output->Write(b);
	output->Write(_L(" "));
	b.Zero();
	b.AppendNum(rhs);
	output->Write(b);
}

void WRITE_VALUES(const TTupleName& lhs, const TTupleName& rhs) {
	TBuf<200> b;
	b.AppendNum((TInt)lhs.iModule.iUid);
	b.Append(_L(" "));
	b.AppendNum(lhs.iId);
	b.Append(_L(" "));

	output->Write(b);
	output->Write(_L(" "));
	b.Zero();
	b.AppendNum((TInt)rhs.iModule.iUid);
	b.Append(_L(" "));
	b.AppendNum(rhs.iId);
	b.Append(_L(" "));
	
	output->Write(b);
}

bool operator==(const CBBGenericList& lhs, const CBBGenericList& rhs) {
	return lhs.Equals(&rhs);
}

template<typename T, typename T1>
void TEST_EQUALS(const T& lhs, const T1& rhs, const TDesC& name, bool match=true) {
	TBuf<40> b;
	TBool fail=EFalse;
	b.Format(_L("%-20S"), &name);
	if ((match && lhs==rhs) || (!match && !(lhs==rhs))) {
		++ok; return;
		b.Append(_L(": OK"));
	} else {
		++not_ok;
		fail=ETrue;
		b.Append(_L(": ERROR "));
	}
	output->Write(b);
	if (fail) WRITE_VALUES(lhs, rhs);
	output->Write(_L("\n"));
}

template<typename T, typename T1>
void TEST_NOT_EQUALS(const T& lhs, const T1& rhs, const TDesC& name) {
	TBuf<40> b;
	b.Format(_L("%-20S"), &name);
	TBool fail=EFalse;
	if (lhs!=rhs) {
		++ok; return;
		b.Append(_L(": OK"));
	} else {
		++not_ok;
		b.Append(_L(": ERROR "));
		fail=ETrue;
	}
	output->Write(b);
	if (fail) WRITE_VALUES(lhs, rhs);
	output->Write(_L("\n"));
}


const TDesC& test_name(TDes& buf, int num1, int num2)
{
	buf=_L("test:");
	buf.AppendNum(num1);
	buf.Append(_L(":"));
	buf.AppendNum(num2);
	return buf;
}

void run_tests();

int E32Main(void)
{
    	CTrapCleanup* cleanupStack = CTrapCleanup::New();
	TRAPD(err, run_tests());
	delete cleanupStack;
	return 0;
}

class TStringMatch8 {
public:
	const TDesC8& s;
	bool operator==(const TStringMatch8& rhs) const {
		if (s.Compare(rhs.s)) return false;
		return true;
	}
	TStringMatch8(const TDesC8& as) : s(as) { }
};

class TStringMatch {
public:
	const TDesC& s;
	bool operator==(const TStringMatch& rhs) const {
		if (s.Compare(rhs.s)) return false;
		return true;
	}
	TStringMatch(const TDesC& as) : s(as) { }
};

void WRITE_VALUES(const void* lhs, const void* rhs) {
        TBuf<20> b;
	b.AppendNum((TInt)lhs);
        output->Write(b);
        output->Write(_L(" "));
	b.Zero();
	b.AppendNum((TInt)rhs);
        output->Write(b);
}

void WRITE_VALUES(const TDesC8& lhs, const TDesC8& rhs) {
        TBuf<100> b;
	b.Copy(lhs.Left(100));
        output->Write(b);
        output->Write(_L(" "));
	b.Copy(rhs.Left(100));
        output->Write(b);
}

void WRITE_VALUES(const TStringMatch& lhs, const TStringMatch& rhs) {
	WRITE_VALUES(lhs.s, rhs.s);
}

void WRITE_VALUES(const TStringMatch8& lhs, const TStringMatch8& rhs) {
	WRITE_VALUES(lhs.s, rhs.s);
}


class TBinMatch8 {
public:
        const TDesC8& s;
        bool operator==(const TBinMatch8& rhs) const {
		if (rhs.s.Length()!=s.Length()) return false;
		TInt i;
		for(i=0; i<rhs.s.Length(); i++) {
			if (rhs.s[i]!=s[i]) return false;
		}
		return true;

        }
        TBinMatch8(const TDesC8& as) : s(as) { }
};


void WRITE_VALUES(const TBinMatch8&, const TBinMatch8&) {
	output->Write(_L("binary strings differ"));
}

void test_for_error_leave(TInt aOccurred, TInt aExpected, const TDesC& name)
{
	if (aOccurred!=aExpected) User::LeaveIfError(aOccurred);
	TEST_EQUALS(aOccurred, aExpected, name);
}

class MRunnable {
public:
	virtual void run() = 0;
};

void test_oom(MRunnable& r)
{
	void* p=User::Alloc(16*1024*1024);
	User::Free(p);

	TInt err=0;
	TInt fail_on=1;
	err=KErrNoMemory;
	while (err==KErrNoMemory) {
		if (fail_on==13) {
			TInt x;
			x=0;
		}
		User::__DbgSetAllocFail(RHeap::EUser, RHeap::EDeterministic, fail_on);
		User::__DbgMarkStart(RHeap::EUser);
		TRAP(err, r.run());
		User::__DbgMarkEnd(RHeap::EUser,0);
		User::__DbgSetAllocFail(RHeap::EUser, RHeap::ENone, 1);
		++fail_on;
	}
	User::__DbgSetAllocFail(RHeap::EUser, RHeap::ENone, 1);
	state.Append(_L(":oom_")); state.AppendNum(fail_on);
	TEST_EQUALS(err, KErrNone, state);
}

class MRunnable2 {
public:
	virtual void run() = 0;
	virtual void stop() = 0;
};

void test_oom2(MRunnable2& r, TInt aMinFail=0, TInt start_with=1)
{
#ifdef __WINS__
	// grow heap so that memory leak addresses
	// are available early
	void* p=User::Alloc(16*1024*1024);
	User::Free(p);
#endif

	TInt err=0;
	TInt fail_on=start_with;
	err=KErrNoMemory;

	//fail_on=108;
	while (err==KErrNoMemory || (fail_on<aMinFail && err==KErrNone) ) {
		TBuf<20> m;
		m.AppendNum(fail_on); m.Append(_L("\n"));
		//output->Write(m);
		RDebug::Print(m);
		if (fail_on==109) {
			TInt x;
			x=0;
		}
		User::__DbgMarkStart(RHeap::EUser);
		{
			User::__DbgSetAllocFail(RHeap::EUser, RHeap::EDeterministic, fail_on);
			TRAP(err, r.run());
			User::__DbgSetAllocFail(RHeap::EUser, RHeap::ENone, 1);
			r.stop();
		}
		User::__DbgMarkEnd(RHeap::EUser,0);
		++fail_on;
	}
	User::__DbgSetAllocFail(RHeap::EUser, RHeap::ENone, 1);
	state.Append(_L(":oom_")); state.AppendNum(fail_on);
	TEST_EQUALS(err, KErrNone, state);
}
