/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


//CBlackBoardClientSession.h


#ifndef __BLACKBOARDCLIENTSESSION_H__
#define __BLACKBOARDCLIENTSESSION_H__

#include <e32base.h>
#include <bbdata.h>
#include "blackboard_cs.h"

/*
 * You can always have an outstanding WaitForNotify,
 * but the rest have to be waited upon before calling
 * another one
 */

class RBBClient : public RSessionBase {
public:
	IMPORT_C RBBClient();
	IMPORT_C TInt Connect();
	IMPORT_C TVersion Version() const;
	
	IMPORT_C void TerminateBlackBoardServer(TRequestStatus& aStatus);
	IMPORT_C void Put(TTupleName aTupleName, const TDesC& aSubName, 
			const TComponentName aComponent,
			const TDesC8& aSerializedData, TBBPriority aPriority, 
			TBool aReplace, TUint& aIdInto, TRequestStatus& aStatus,
			TBool aPersist=ETrue, TBool aNotifySender=EFalse,
			TBool aIsReply=EFalse);
	IMPORT_C void Get(const TTupleName& aName, const TDesC& aSubName, 
			TFullArgs& aMeta, TDes8& aSerializedData,
			TRequestStatus& aStatus);
	IMPORT_C void Get(const TComponentName& aName,
			TFullArgs& aMeta, TDes8& aSerializedData,
			TRequestStatus& aStatus);

	IMPORT_C void AddNotificationL(const TTupleName& aTupleName, 
			TBool aGetExisting, TBBPriority aPriority,
			TRequestStatus& aStatus);
	IMPORT_C void AddNotificationL(const TComponentName& aComponentName, 
			TRequestStatus& aStatus);

	IMPORT_C void WaitForNotify(TFullArgs& aMeta, TDes8& aSerializedData, 
		TRequestStatus& aStatus);
	IMPORT_C void Delete(TUint id, 
		TRequestStatus& aStatus);


	IMPORT_C void CancelNotify();
	IMPORT_C void CancelOther();
	IMPORT_C void Close();
private: 
	void	MakeIdPtr(TUint& aId);
	void	MakeFullPtr(TFullArgs& aFull, TPtr8& aInto);

	TFullArgs	*iArgs;
	TPckg<TFullArgs> *iArgPckg;

	TTupleArgs	*iTupleArg;
	TPckg<TTupleArgs> *iTupleArgPckg;

	TPtr8  iIdPtr;
	TPtr8  iFullPtr, iNotifyFullPtr;

	TTupleName	iTupleName;
	TPckg<TTupleName> iTupleNamePckg;

	TComponentName	iComponentName;
	TPckg<TComponentName> iComponentNamePckg;
};

#endif

