#ifndef BB_CS_H_INCLUDED
#define BB_CS_H_INCLUDED 1

#include <e32base.h>
#include <bbdata.h>

//--------------------- SERVER PANICS --------------------

//#define NO_COMPONENTNAME

//Panic Category
_LIT(KBlackBoardServer, "BlackBoard");

_LIT(KSubscriptionDir, "\\system\\data\\context\\bbsubs\\");

//Panic Codes
enum TBlackBoardServPanic
{
        EBBBadRequest,
        EBBBadDescriptor,
        ESrvCreateServer,
        ECreateTrapCleanup
};

enum TTupleType
{
	ETupleDataOrRequest,	
	ETuplePermanentSubscriptionEvent,
	ETupleSpaceInternal,
	ETupleRequest, // not used
	ETupleReply,
};

enum TBBPriority
{
	EBBPriorityLow,
	EBBPriorityNormal,
	EBBPriorityHigh,
	EBBPriorityOOB,
};

const TUint KPriorityCount = 4;
const TBBPriority KNotifyDirectLimit = EBBPriorityHigh;

_LIT(KBlackBoardServerName,"myBlackBoardServer");
_LIT(KBlackBoardServerSemaphoreName, "AmyBlackBoardServerSemaphore");

//the server version. A version must be specified when
//creating a session with the server
const TUint KBlackBoardServMajorVersionNumber=1;
const TUint KBlackBoardServMinorVersionNumber=0;
const TUint KBlackBoardServBuildVersionNumber=1;

/*
 * basic message layout:
 *	flags
 *	IN argument struct pointer 
 *	OUT argument struct pointer / IN priority
 *	return buffer pointer
 */

//opcodes used in message passing between client and server
enum TBlackBoardServRqst
{
	EGetByTuple,	// flags, IN TTupleName|TTupleArgs, OUT TFullArgs, OUT data
	EGetByComponent, // not used, IN TComponentName, OUT TFullArgs, OUT data
	EPut,		// not used, IN TFullArgs, OUT_OPT TUint id, IN data
	EDeleteByTuple, // flags,  IN TTupleName|TTupleArgs, not in use, not in use
	EDeleteById,	// not in use,  IN TUint, not in use, not in use
	EAddNotifyByTupleFilter, // flags,  IN TTupleName.iModule.iUid, IN TTupleName.iId, IN TBBPriority
	EDeleteNotifyByTupleFilter, // flags,  IN TTupleName, not in use, not in use
	EAddNotifyByComponentFilter, // not in use,  IN TComponentName.iModule.iUid, IN TComponentName.iId, not in use
	EDeleteNotifyByComponentFilter, // not in use,  IN TComponentName, not in use, not in use
	ENotifyOnChange, // not used, not used, OUT TFullArgs, OUT data
	ETerminateBlackBoardServer, // no args

        ECancelOther, // no args
	ECancelNotify,
};

const TUint KArgFlagNoSubName = 1;
const TUint KArgFlagReplace = 2;
const TUint KArgFlagGetExisting = 4;
const TUint KArgFlagDontPersist = 8; // for testing
const TUint KArgFlagDoNotNotifySender = 16;

struct TFullArgs {
	TUint		iId;
	TTupleName	iTupleName;
	TBuf<KMaxTupleSubNameLength> iSubName;
	TComponentName	iComponentName;
	TBBPriority	iPriority;
	TTupleType	iTupleType;
};

struct TTupleArgs {
	TTupleName	iTupleName;
	TBuf<KMaxTupleSubNameLength> iSubName;
};

// TComponentName passed as is

//opcodes used by server to indicate which asynchronous service
//has completed
enum TBlackBoardServRqstComplete
{
        ERequestCompleted = 1,
        EBufferTooSmall = -3,
        EBlackBoardServerTerminated = -4
};

#endif
