#ifndef CONTEXT_CBBSESSION_H_INCLUDED
#define CONTEXT_CBBSESSION_H_INCLUDED 1

#include "blackboardclientsession.h"
#include <bbtypes.h>

class MBBObserver {
public:
	virtual void NewValueL(TUint aId, const TTupleName& aName, const TDesC& aSubName, 
		const TComponentName& aComponentName, const MBBData* aData) = 0;
};

class CBBSubSession : public CCheckedActive, public MContextBase {
public:
	virtual void AddNotificationL(const TTupleName& aTupleName) = 0;
	virtual void AddNotificationL(const TComponentName& aComponentName) = 0;
	virtual void DeleteNotifications() = 0;

	virtual void GetL(const TTupleName& aName, const TDesC& aSubName, 
			MBBData*& aDataInto) = 0;
	virtual void PutL(const TTupleName& aTupleName, const TDesC& aSubName, 
			const MBBData* aData, const TComponentName& aComponentName=KNoComponent) = 0;
	virtual void PutRequestL(const TTupleName& aTupleName, const TDesC& aSubName, 
			const MBBData* aData, const TComponentName& aComponentName) = 0;
	virtual void PutReplyL(const TTupleName& aTupleName, const TDesC& aSubName, 
			const MBBData* aData, const TComponentName& aComponentName) = 0;
	virtual void DeleteL(TUint id) = 0;
protected:
	CBBSubSession(MApp_context& Context);
};

class CBBSession : public CCheckedActive, public MContextBase {
public:
	IMPORT_C static CBBSession* NewL(MApp_context& Context, MBBDataFactory* aFactory);

	virtual CBBSubSession* CreateSubSessionL(MBBObserver* anObserver) = 0;
	virtual MBBDataFactory* GetBBDataFactory() = 0;
protected:
	CBBSession(MApp_context& Context);
};

#endif
